/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core.operation.model;

import io.intino.itrules.Formatter;
import io.intino.itrules.FrameBuilder;
import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.operation.model.ModelOperation;
import io.intino.tara.builder.core.operation.model.ToNativeTransformerTemplate;
import io.intino.tara.builder.utils.FileSystemUtils;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.EmptyMogram;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Parametrized;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Property;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.Valued;
import io.intino.tara.model.rules.property.FunctionRule;
import io.intino.tara.processors.model.Model;
import io.intino.tara.processors.parser.NativeExtractor;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NativeTransformationOperation
extends ModelOperation {
    private final File resources;
    private final File srcDirectory;

    public NativeTransformationOperation(CompilationUnit unit) {
        super(unit);
        this.resources = unit.configuration().resDirectory();
        this.srcDirectory = unit.configuration().srcDirectory();
    }

    @Override
    public void call(Model model) throws CompilationFailedException {
        for (Mogram mogram : model.mograms()) {
            this.findReactiveParameters((Parametrized)mogram).forEach(p -> p.substituteValues(new ArrayList<Primitive.Expression>(Collections.singletonList(this.transformValueToExpression((Valued)p)))));
            this.findReactiveProperties((ElementContainer)mogram).forEach(v -> v.values(new ArrayList<Primitive.Expression>(Collections.singletonList(this.transformValueToExpression((Valued)v)))));
            this.findMethodReferences(mogram).forEach(v -> v.values(new ArrayList<Primitive.Expression>(Collections.singletonList(this.transformMethodReference((Valued)v, new File(v.source()).getName())))));
        }
    }

    private Primitive.Expression transformValueToExpression(Valued v) {
        return new Primitive.Expression(this.wrap(v));
    }

    private Primitive.Expression transformMethodReference(Valued v, String fileName) {
        return new Primitive.Expression(this.wrapMethodReference(v, fileName));
    }

    private String wrapMethodReference(Valued v, String fileName) {
        List value = v.values();
        return this.transformMethodReference(v.source(), NativeTransformationOperation.functionRule(v), (Primitive.MethodReference)value.get(0), fileName);
    }

    private String wrap(Valued v) {
        if (v.values().get(0) instanceof EmptyMogram) {
            return "null";
        }
        List result = v.values().stream().map(value -> this.wrapValue(v, value)).collect(Collectors.toList());
        return v.isMultiple() ? "java.util.Arrays.asList(" + String.join((CharSequence)", ", result) + ")" : (String)result.get(0);
    }

    private static FunctionRule functionRule(Valued v) {
        return v.rules().stream().filter(r -> r instanceof FunctionRule).findFirst().orElse(null);
    }

    private String wrapValue(Valued v, Object value) {
        String toAdd = value.toString();
        if (value instanceof File) {
            toAdd = ((File)value).getAbsolutePath().replace("\\", "/");
        }
        FrameBuilder builder = new FrameBuilder(new String[]{v.type().name(), "native"}).add("value", (Object)toAdd);
        Map<String, Formatter> formatters = Map.of("url", url -> url.toString().substring(this.resources.getAbsolutePath().length() + 1));
        return new ToNativeTransformerTemplate().render(builder.toFrame(), formatters);
    }

    private String transformMethodReference(URI source, FunctionRule rule, Primitive.MethodReference value, String fileName) {
        String parameters = rule == null ? "" : this.namesOf(new NativeExtractor(rule.signature()).parameters());
        String packageOf = this.packageOf(new File(source).getParent());
        return (String)(!packageOf.isEmpty() ? packageOf + "." : "") + Format.javaValidName().format((Object)FileSystemUtils.getNameWithoutExtension(fileName)).toString() + "." + value.target() + "(self" + (String)(parameters.isEmpty() ? "" : ", " + parameters) + ");";
    }

    private String packageOf(String path) {
        if (this.srcDirectory == null) {
            return "";
        }
        String replace = path.replace(this.srcDirectory.getAbsolutePath(), "");
        return replace.isEmpty() ? "" : replace.substring(1).replace(File.separator, ".");
    }

    private String namesOf(String parameters) {
        return Format.nativeParameterWithoutType().format((Object)parameters).toString();
    }

    private Set<PropertyDescription> findReactiveParameters(Parametrized parametrized) {
        Set<PropertyDescription> parameters = parametrized.parameters().stream().filter(p -> p.definition() != null && p.definition().annotations().contains(Annotation.Reactive) && !(p.values().get(0) instanceof Primitive.Expression) && !(p.values().get(0) instanceof Primitive.MethodReference)).collect(Collectors.toSet());
        if (parametrized instanceof Mogram) {
            ((Mogram)parametrized).mograms().forEach(n -> parameters.addAll(this.findReactiveParameters((Parametrized)n)));
        }
        return parameters;
    }

    private Set<Property> findReactiveProperties(ElementContainer container) {
        HashSet<Property> parameters = new HashSet<Property>();
        for (Mogram inner : container.mograms()) {
            parameters.addAll(NativeTransformationOperation.reactiveProperties(inner));
            parameters.addAll(this.findReactiveProperties((ElementContainer)inner));
        }
        return parameters;
    }

    private static List<Property> reactiveProperties(Mogram inner) {
        return inner.properties().stream().filter(v -> v.annotations().contains(Annotation.Reactive) && !v.values().isEmpty() && !(v.values().get(0) instanceof Primitive.Expression) && !(v.values().get(0) instanceof Primitive.MethodReference)).toList();
    }

    private Set<Valued> findMethodReferences(Mogram mogram) {
        HashSet<Valued> valued = new HashSet<Valued>();
        valued.addAll(mogram.properties().stream().filter(v -> !v.values().isEmpty() && v.values().get(0) instanceof Primitive.MethodReference).toList());
        valued.addAll(mogram.parameters().stream().filter(v -> !v.values().isEmpty() && v.values().get(0) instanceof Primitive.MethodReference).toList());
        for (Mogram inner : mogram.mograms()) {
            valued.addAll(this.findMethodReferences(inner));
        }
        return valued;
    }
}

