/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core;

import io.intino.builder.CompilerConfiguration;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.errorcollection.ErrorCollector;

public abstract class ProcessingUnit {
    protected int phase = 0;
    protected boolean phaseComplete;
    protected ErrorCollector errorCollector;
    protected CompilerConfiguration configuration;

    protected ProcessingUnit(CompilerConfiguration configuration, ErrorCollector er) {
        this.configuration = configuration == null ? new CompilerConfiguration() : configuration;
        this.errorCollector = er == null ? new ErrorCollector(this.configuration) : er;
    }

    public CompilerConfiguration configuration() {
        return this.configuration;
    }

    public void setConfiguration(CompilerConfiguration configuration) {
        this.configuration = configuration;
    }

    public ErrorCollector getErrorCollector() {
        return this.errorCollector;
    }

    public void gotoPhase(int phase) throws CompilationFailedException {
        if (!this.phaseComplete) {
            this.completePhase();
        }
        this.phase = phase;
        this.phaseComplete = false;
    }

    public void completePhase() throws CompilationFailedException {
        this.errorCollector.failIfErrors();
        this.phaseComplete = true;
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isPhaseComplete() {
        return this.phaseComplete;
    }

    public void nextPhase() throws CompilationFailedException {
        this.gotoPhase(this.phase + 1);
    }
}

