/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.codegeneration.language;

import io.intino.builder.CompilerConfiguration;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.tara.Language;
import io.intino.tara.builder.codegeneration.language.LanguageCreator;
import io.intino.tara.builder.codegeneration.language.POMTemplate;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.utils.FileSystemUtils;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.Context;
import io.intino.tara.processors.model.Model;
import io.intino.tara.processors.utils.JavaCompiler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class LanguageSerializer {
    private static final Logger LOG = Logger.getGlobal();
    private static final String JAVA = ".java";
    private static final String JAR = ".jar";
    private static final String TARA_LANG_PACKAGE = "io.intino.tara.language";
    private final CompilerConfiguration conf;
    private final Model model;
    private final Language language;

    public LanguageSerializer(Language language, CompilerConfiguration conf, Model model) throws TaraException {
        this.conf = conf;
        this.model = model;
        this.language = language;
    }

    public File serialize() throws TaraException {
        return this.serialize(new LanguageCreator(this.conf, this.model, this.language).create(), this.getDslDestination(), this.collectRules());
    }

    private List<File> collectRules() {
        HashSet<File> classes = new HashSet<File>();
        classes.addAll(this.filesOf(this.model));
        classes.addAll(this.collectLanguageRules());
        return new ArrayList<File>(classes);
    }

    private Collection<File> filesOf(Model model) {
        return model.rules().values();
    }

    private List<File> collectLanguageRules() {
        return this.language.catalog().values().stream().flatMap(context -> this.getRulesOfContext((Context)context).stream().map(LanguageSerializer::sourceOf).distinct()).collect(Collectors.toList());
    }

    private List<Class<?>> getRulesOfContext(Context context) {
        return context.constraints().stream().filter(c -> c instanceof Constraint.Property).flatMap(c -> ((Constraint.Property)c).rules().stream()).map(Object::getClass).filter(r -> !r.getName().startsWith(TARA_LANG_PACKAGE)).collect(Collectors.toList());
    }

    private static File sourceOf(Class<?> c) {
        return new File(c.getProtectionDomain().getCodeSource().getLocation().getPath());
    }

    private File getDslDestination() {
        File file = new File(this.conf.localRepository(), this.conf.groupId().replace(".", File.separator) + File.separator + StringFormatters.camelCase().format((Object)this.conf.dsl().outDsl()).toString().toLowerCase() + File.separator + (this.conf.version() == null ? "1.0.0" : this.conf.version()));
        file.mkdirs();
        return new File(file, String.valueOf(Format.reference().format(Format.firstUpperCase().format((Object)this.conf.dsl().outDsl()))) + JAVA);
    }

    private File serialize(String content, File javaFile, List<File> rules) throws TaraException {
        try {
            File dslDirectory = javaFile.getParentFile();
            if (dslDirectory.exists()) {
                FileSystemUtils.removeDir(dslDirectory);
            }
            dslDirectory.mkdirs();
            Files.writeString(javaFile.toPath(), (CharSequence)content, new OpenOption[0]);
            JavaCompiler.compile((File)javaFile, (String)String.join((CharSequence)File.pathSeparator, this.collectClassPath(rules)), (File)this.getDslDestination().getParentFile());
            this.serializeModel(dslDirectory);
            File pom = this.createPOM(dslDirectory);
            this.jar(dslDirectory, pom, rules.stream().filter(v -> !v.getName().startsWith(TARA_LANG_PACKAGE)).collect(Collectors.toList()));
            return this.jarFile(dslDirectory);
        }
        catch (Exception e) {
            throw new TaraException("Error serializing language: " + e.getMessage(), e);
        }
    }

    private void serializeModel(File dslDirectory) throws IOException {
        File file = new File(dslDirectory, StringFormatters.camelCase().format((Object)this.conf.groupId()).toString().replace(".", File.separator) + File.separator + this.conf.dsl().outDsl() + "-" + this.conf.version() + ".obj");
        ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(file));
        stream.writeObject(this.model);
        stream.close();
    }

    private File createPOM(File dslDirectory) throws IOException {
        String text = new POMTemplate().render(new FrameBuilder().add("POM").add("groupId", (Object)this.conf.groupId()).add("name", (Object)this.conf.dsl().outDsl()).add("version", (Object)this.conf.version()));
        File file = new File(this.jarFile(dslDirectory).getAbsolutePath().replace(JAR, ".pom"));
        Files.write(file.toPath(), text.getBytes(), new OpenOption[0]);
        return file;
    }

    private Collection<String> collectClassPath(Collection<File> values) throws IOException {
        HashSet<String> dependencies = new HashSet<String>();
        File languageLib = new File(Language.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        dependencies.add(languageLib.getAbsolutePath());
        try {
            dependencies.add(Paths.get(this.language.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).toFile().getCanonicalPath().replaceAll("%20", " "));
            dependencies.addAll(values.stream().filter(v -> !v.getName().startsWith(TARA_LANG_PACKAGE)).map(File::getPath).toList());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return dependencies;
    }

    private void jar(File dslDir, File pom, List<File> rules) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_VERSION, this.conf.version());
        manifest.getEntries().put("tara", this.createTaraProperties());
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(this.jarFile(dslDir)), manifest);
        File src = new File(dslDir, this.conf.groupId().split("\\.")[0]);
        src.mkdirs();
        this.add(dslDir, src, target);
        this.addPom(dslDir, pom, target);
        this.addRules(rules, target);
        this.addInheritedRules(target);
        target.close();
        FileSystemUtils.removeDir(new File(dslDir, "META-INF"));
        FileSystemUtils.removeDir(src);
    }

    private void addPom(File dslDir, File pom, JarOutputStream target) throws IOException {
        File dir = new File(dslDir, "META-INF/maven/" + this.conf.groupId().toLowerCase() + "/" + this.conf.artifactId().toLowerCase());
        dir.mkdirs();
        FileSystemUtils.copyFile(pom.getAbsolutePath(), new File(dir, "pom.xml").getAbsolutePath());
        Files.writeString(new File(dir, "pom.properties").toPath(), (CharSequence)this.pomProperties(), new OpenOption[0]);
        this.add(dslDir, new File(dslDir, "META-INF"), target);
    }

    private String pomProperties() {
        return MessageFormat.format("artifactId={0}\ngroupId={1}\nversion={2}\n", this.conf.artifactId(), this.conf.groupId(), this.conf.version());
    }

    private File jarFile(File dslDir) {
        return new File(dslDir, String.valueOf(StringFormatters.lowerCase().format((Object)this.conf.dsl().outDsl())) + "-" + this.conf.version() + JAR);
    }

    private Attributes createTaraProperties() {
        Attributes taraAttributes = new Attributes();
        taraAttributes.put(new Attributes.Name("groupId"), this.conf.groupId());
        taraAttributes.put(new Attributes.Name("artifactId"), this.conf.artifactId());
        taraAttributes.put(new Attributes.Name("version"), this.conf.version());
        taraAttributes.put(new Attributes.Name(this.normalize("dsl")), this.conf.dsl().groupId() + ":" + this.conf.dsl().artifactId() + ":" + this.conf.dsl().version());
        taraAttributes.put(new Attributes.Name(this.normalize("dsl.version")), this.conf.dsl().version());
        taraAttributes.put(new Attributes.Name(this.normalize("out.dsl")), this.conf.dsl().outDsl());
        taraAttributes.put(new Attributes.Name(this.normalize("builder.groupId")), this.conf.dsl().builder().groupId());
        taraAttributes.put(new Attributes.Name(this.normalize("builder.artifactId")), this.conf.dsl().builder().artifactId());
        taraAttributes.put(new Attributes.Name(this.normalize("builder.version")), this.conf.dsl().builder().version());
        taraAttributes.put(new Attributes.Name(this.normalize("runtime.groupId")), this.conf.dsl().runtime().groupId());
        taraAttributes.put(new Attributes.Name(this.normalize("runtime.artifactId")), this.conf.dsl().runtime().artifactId());
        taraAttributes.put(new Attributes.Name(this.normalize("runtime.version")), this.conf.dsl().runtime().version());
        taraAttributes.put(new Attributes.Name(this.normalize("generation.package")), this.conf.generationPackage());
        return taraAttributes;
    }

    private String normalize(String tag) {
        return tag.replace(".", "-");
    }

    private void addInheritedRules(JarOutputStream target) {
        File tempDirectory = this.conf.getTempDirectory();
        FileSystemUtils.removeDir(tempDirectory);
        FileSystemUtils.extractJar(this.language.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), tempDirectory);
        File[] languageDirectories = this.languageDirectory(tempDirectory);
        ArrayList<File> rules = new ArrayList<File>();
        for (File d : languageDirectories) {
            FileSystemUtils.getAllFiles(d, rules);
        }
        rules.stream().filter(f -> f.getName().endsWith(".class")).forEach(r -> {
            try {
                this.add(this.conf.getTempDirectory(), (File)r, target);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        });
    }

    private File[] languageDirectory(File tempDirectory) {
        return tempDirectory.listFiles(file -> file.isDirectory() && !file.getName().equals("META-INF") && !file.getName().equals("tara"));
    }

    private void addRules(List<File> rules, JarOutputStream target) throws IOException {
        HashMap<File, String> ruleFiles = new HashMap<File, String>();
        for (File file : rules) {
            ArrayList<File> files = new ArrayList<File>();
            FileSystemUtils.getAllFiles(file, files);
            for (File file2 : files) {
                ruleFiles.put(file2, file.getAbsolutePath());
            }
        }
        for (Map.Entry entry : ruleFiles.entrySet()) {
            this.add(new File((String)entry.getValue()), (File)entry.getKey(), target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(File base, File source, JarOutputStream target) throws IOException {
        try (BufferedInputStream in = null;){
            if (source.isDirectory()) {
                this.createDirectory(base, source, target);
                return;
            }
            JarEntry entry = new JarEntry(this.getRelativePath(base, source).replace("\\", "/"));
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            in = this.writeEntry(source, target);
            target.closeEntry();
        }
    }

    private BufferedInputStream writeEntry(File source, OutputStream target) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
        FileSystemUtils.writeBuffer(in, target);
        return in;
    }

    private void createDirectory(File base, File source, JarOutputStream target) throws IOException {
        String name = this.getRelativePath(base, source).replace("\\", "/");
        if (!name.isEmpty()) {
            this.createEntry(source, target, name);
        }
        for (File nestedFile : Objects.requireNonNull(source.listFiles())) {
            this.add(base, nestedFile, target);
        }
    }

    private void createEntry(File source, JarOutputStream target, String name) throws IOException {
        if (!((String)name).endsWith("/")) {
            name = (String)name + "/";
        }
        JarEntry entry = new JarEntry((String)name);
        entry.setTime(source.lastModified());
        target.putNextEntry(entry);
        target.closeEntry();
    }

    private String getRelativePath(File base, File source) {
        return source.getPath().replace(base.getAbsolutePath() + File.separator, "");
    }
}

