/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.codegeneration.language;

import io.intino.itrules.Adapter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.adapters.ExcludeAdapter;
import io.intino.tara.builder.codegeneration.TemplateTags;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Property;
import io.intino.tara.model.Rule;
import io.intino.tara.model.rules.property.FunctionRule;
import io.intino.tara.model.rules.property.PropertyCustomRule;
import java.util.Collections;

class LanguagePropAdapter
implements TemplateTags {
    private final String workingPackage;

    LanguagePropAdapter(String workingPackage) {
        this.workingPackage = workingPackage;
    }

    void addPropConstraint(FrameBuilder frame, String facet, int position, Property prop) {
        frame.add("constraint", (Object)this.property(position, facet, prop));
    }

    protected FrameBuilder ruleToFrame(Rule<?> rule) {
        if (rule == null) {
            return null;
        }
        FrameBuilder builder = new FrameBuilder();
        builder.put(Rule.class, (Adapter)new ExcludeAdapter(new String[]{"loadedClass"}));
        builder.append(rule);
        if (rule instanceof PropertyCustomRule) {
            FrameBuilder frameBuilder = new FrameBuilder(new String[]{"customRule"});
            frameBuilder.add("qn", (Object)LanguagePropAdapter.cleanQn(((PropertyCustomRule)rule).qualifiedName()));
            frameBuilder.add("aClass", (Object)LanguagePropAdapter.cleanQn(((PropertyCustomRule)rule).externalClass()));
            if (((PropertyCustomRule)rule).isMetric()) {
                frameBuilder.add("metric");
                frameBuilder.add("default", (Object)((PropertyCustomRule)rule).getDefaultUnit());
            }
            return frameBuilder;
        }
        return builder;
    }

    public static String cleanQn(String qualifiedName) {
        return qualifiedName.replace("anonymous@", "").replace("[", "").replace("]", "").replace(":", "").replace("$", ".");
    }

    private Frame property(int i, String facet, Property prop) {
        FrameBuilder ruleFrame;
        FrameBuilder builder = new FrameBuilder(new String[]{"constraint", "property"}).add("name", (Object)prop.name()).add("facet", (Object)facet).add("type", (Object)prop.type()).add("position", (Object)i).add("tags", (Object)this.annotations(prop)).add("scope", (Object)this.workingPackage).add("level", (Object)prop.container().level().name());
        Frame[] rules = (Frame[])prop.rules().stream().filter(r -> {
            PropertyCustomRule c;
            return !(r instanceof PropertyCustomRule) || (c = (PropertyCustomRule)r).loadedClass() != null;
        }).map(r -> this.ruleToFrame((Rule<?>)r).toFrame()).toArray(Frame[]::new);
        if (rules.length > 0) {
            builder.add("rule", (Object)rules);
        } else if (prop.annotations().contains(Annotation.Reactive) && (ruleFrame = this.ruleToFrame((Rule<?>)new FunctionRule("", "", Collections.emptyList()))) != null) {
            builder.add("rule", (Object)ruleFrame.toFrame());
        }
        return builder.toFrame();
    }

    private String[] annotations(Property variable) {
        return (String[])variable.annotations().stream().map(Enum::name).toArray(String[]::new);
    }
}

