/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.codegeneration.language;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.tara.Language;
import io.intino.tara.builder.codegeneration.TemplateTags;
import io.intino.tara.builder.codegeneration.language.LanguagePropAdapter;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.model.NamedReference;
import io.intino.tara.model.Property;
import io.intino.tara.model.Rule;
import io.intino.tara.model.rules.Size;
import io.intino.tara.model.rules.composition.ConstraintRule;
import io.intino.tara.processors.model.HasMogram;
import io.intino.tara.processors.model.Model;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class LanguageModelAdapter
implements TemplateTags {
    public static final int BLOCK_SIZE = 5;
    private final String workingPackage;
    private final Set<Mogram> processed = new HashSet<Mogram>();
    private final String outDSL;
    private final Language language;
    private final FrameBuilder root;
    private int rootNumber = 0;

    LanguageModelAdapter(String grouId, String outDSL, String version, Locale locale, Language language, String workingPackage) {
        this.outDSL = outDSL;
        this.language = language;
        this.workingPackage = workingPackage;
        this.root = new FrameBuilder().add("language").add("groupId", (Object)grouId).add("groupIdPath", (Object)grouId.replace(".", "/")).add("name", (Object)outDSL).add("version", (Object)version).add("metaLanguage", (Object)language.languageName()).add("locale", (Object)locale.getLanguage());
    }

    public Frame adapt(Model model) {
        this.createModelRuleFrame(model);
        this.buildRootMograms(model);
        return this.root.toFrame();
    }

    private void createModelRuleFrame(Model model) {
        FrameBuilder builder = new FrameBuilder().add("model").add("name", (Object)"");
        FrameBuilder cs = new FrameBuilder(new String[]{"constraints"});
        this.componentsConstraints((ElementContainer)model).forEach(frame -> cs.add("constraint", frame));
        this.languageComponentConstraints(this.language.model()).forEach(frame -> builder.add("constraint", frame));
        this.root.add("model", (Object)builder.add("constraints", (Object)cs).toFrame());
    }

    private void buildRootMograms(Model model) {
        List<Frame> frames = this.mogramFrames(model);
        for (int i = 0; i < frames.size(); i += 5) {
            FrameBuilder rootFrame = new FrameBuilder(new String[]{"split"}).add("number", (Object)(++this.rootNumber)).add("language", (Object)this.outDSL);
            frames.subList(i, Math.min(i + 5, frames.size())).forEach(f -> rootFrame.add("mogram", f));
            this.root.add("split", (Object)rootFrame.toFrame());
        }
        List<Frame> langFrames = this.languageMogramFrames(this.language.model());
        int length = frames.size() + langFrames.size();
        for (int i = frames.size(); i < length; i += 5) {
            FrameBuilder rootFrame = new FrameBuilder(new String[]{"split"}).add("number", (Object)(++this.rootNumber)).add("language", (Object)this.outDSL);
            langFrames.subList(i - frames.size(), Math.min(i + 5 - frames.size(), length - frames.size())).forEach(f -> rootFrame.add("mogram", f));
            this.root.add("split", (Object)rootFrame.toFrame());
        }
    }

    private List<Frame> languageMogramFrames(MogramRoot model) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        model.mograms().stream().filter(m -> m.level().equals((Object)Level.M2)).forEach(m -> this.map((Mogram)m, (List<Frame>)frames));
        return frames;
    }

    private List<Frame> mogramFrames(Model model) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        model.mograms().forEach(m -> this.map((Mogram)m, (List<Frame>)frames));
        return frames;
    }

    private void map(Mogram n, List<Frame> frames) {
        FrameBuilder rootFrame = new FrameBuilder(new String[]{"root"}).add("number", (Object)(++this.rootNumber)).add("language", (Object)this.outDSL);
        this.buildMogram(n, rootFrame);
        rootFrame.toFrame().frames("mogram").forEachRemaining(frames::add);
    }

    private void buildMogram(Mogram mogram, FrameBuilder root) {
        if (!this.processed.add(mogram)) {
            return;
        }
        if (mogram.level() != Level.M1 && !mogram.is(Annotation.Generalization) && !mogram.isAnonymous()) {
            root.add("mogram", (Object)this.createMogramRuleFrame(mogram).toFrame());
        }
        if (!mogram.isAnonymous()) {
            mogram.mograms().forEach(m -> this.buildMogram((Mogram)m, root));
        }
    }

    private FrameBuilder createMogramRuleFrame(Mogram mogram) {
        FrameBuilder frame = new FrameBuilder(new String[]{"mogram"}).add("name", (Object)this.name(mogram));
        frame.add("level", (Object)Level.values()[mogram.level().ordinal() - 1].name());
        this.addTypes(mogram, frame);
        this.addConstraints(mogram, frame);
        this.addAssumptions(mogram, frame);
        return frame;
    }

    private void addTypes(Mogram mogram, FrameBuilder builder) {
        if (mogram.types().isEmpty()) {
            return;
        }
        FrameBuilder typesFrameBuilder = new FrameBuilder(new String[]{"mogramType"});
        LinkedHashSet typeSet = new LinkedHashSet(mogram.types());
        List languageTypes = this.language.types((String)mogram.types().get(0));
        if (languageTypes != null) {
            typeSet.addAll(languageTypes);
        }
        for (String type : typeSet) {
            typesFrameBuilder.add("type", (Object)type);
        }
        if (typesFrameBuilder.slots() > 0) {
            builder.add("mogramType", (Object)typesFrameBuilder.toFrame());
        }
    }

    private void addConstraints(Mogram mogram, FrameBuilder builder) {
        FrameBuilder cs = new FrameBuilder(new String[]{"constraints"});
        this.componentsConstraints((ElementContainer)mogram).forEach(f -> cs.add("constraint", f));
        this.addParameterConstraints(this.allProperties(mogram), mogram.facetPrescription() != null ? mogram.name() : "", cs);
        this.addAllowedFacetConstraints(mogram, cs);
        builder.add("constraints", (Object)cs.toFrame());
    }

    private List<Property> allProperties(Mogram mogram) {
        ArrayList<Property> properties = new ArrayList<Property>(mogram.properties());
        NamedReference parent = mogram.parent();
        while (parent != null) {
            properties.addAll(0, ((Mogram)parent.get()).properties().stream().filter(p -> properties.stream().noneMatch(pr -> pr.name().equals(p.name()))).toList());
            parent = ((Mogram)parent.get()).parent();
        }
        return properties;
    }

    private void addParameterConstraints(List<Property> props, String facet, FrameBuilder constrainsFrame) {
        int privateProps = 0;
        for (int index = 0; index < props.size(); ++index) {
            Property prop = props.get(index);
            if (!(prop.annotations().contains(Annotation.Private) || prop.annotations().contains(Annotation.Final) && !prop.values().isEmpty())) {
                new LanguagePropAdapter(this.workingPackage).addPropConstraint(constrainsFrame, facet, index - privateProps, prop);
                continue;
            }
            ++privateProps;
        }
    }

    private void addAllowedFacetConstraints(Mogram mogram, FrameBuilder constraintsBuilder) {
        LanguageModelAdapter.allApplicableFacets(mogram).forEach(facetMogram -> {
            if (facetMogram.is(Annotation.Generalization)) {
                return;
            }
            FrameBuilder builder = new FrameBuilder(new String[]{"constraint", "facet"}).add("value", (Object)facetMogram.qualifiedName());
            if (facetMogram.facetConstraints() != null && !facetMogram.facetConstraints().isEmpty()) {
                for (Mogram.FacetConstraint constraint : facetMogram.facetConstraints()) {
                    builder.add("with", (Object)((Mogram)constraint.target().get()).qualifiedName());
                }
            }
            if (facetMogram.annotations().contains(Annotation.Required)) {
                builder.add("required", (Object)"true");
            }
            this.addParameterConstraints(this.allProperties((Mogram)facetMogram), facetMogram.name(), builder);
            this.componentsConstraints((ElementContainer)facetMogram).forEach(f -> builder.add("constraint", f));
            constraintsBuilder.add("constraint", (Object)builder.toFrame());
            if (facetMogram.level() == Level.M3) {
                constraintsBuilder.add("constraint", (Object)new FrameBuilder(new String[]{"facetInstantiation"}).add("type", (Object)this.typesOf((Mogram)facetMogram)));
            }
        });
    }

    private String[] typesOf(Mogram mogram) {
        ArrayList<String> types = new ArrayList<String>(List.of(mogram.qualifiedName()));
        mogram.children().forEach(c -> types.add(c.qualifiedName()));
        return types.toArray(new String[0]);
    }

    private static List<Mogram> allApplicableFacets(Mogram mogram) {
        ArrayList<Mogram> facets = new ArrayList<Mogram>(mogram.applicableFacets().stream().map(NamedReference::get).toList());
        NamedReference parent = mogram.parent();
        while (parent != null) {
            facets.addAll(0, ((Mogram)parent.get()).applicableFacets().stream().map(NamedReference::get).filter(p -> facets.stream().noneMatch(f -> f.name().equals(p.name()))).toList());
            parent = ((Mogram)parent.get()).parent();
        }
        return facets;
    }

    private void addAssumptions(Mogram mogram, FrameBuilder frame) {
        FrameBuilder assumptions = this.buildAssumptions(mogram);
        if (assumptions.slots() != 0) {
            frame.add("assumptions", (Object)assumptions.toFrame());
        }
    }

    private FrameBuilder buildAssumptions(Mogram mogram) {
        FrameBuilder assumptions = new FrameBuilder(new String[]{"assumptions"});
        this.addAnnotationAssumptions(mogram, assumptions);
        return assumptions;
    }

    private void addAnnotationAssumptions(Mogram mogram, FrameBuilder assumptions) {
        mogram.annotations().stream().filter(tag -> tag.equals((Object)Annotation.Feature) || tag.equals((Object)Annotation.Component)).forEach(tag -> assumptions.add("assumption", tag));
    }

    private List<Frame> languageComponentConstraints(MogramRoot model) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        model.mograms().stream().filter(m -> m.level().equals((Object)Level.M2)).filter(c -> this.componentCompliant((ElementContainer)model, (Mogram)c)).filter(c -> !c.isSub() || c.container() instanceof Model).forEach(c -> this.createComponentConstraint((List<Frame>)frames, (Mogram)c));
        return frames;
    }

    private List<Frame> componentsConstraints(ElementContainer container) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        this.allComponents(container).stream().filter(c -> this.componentCompliant(container, (Mogram)c)).filter(c -> !c.isSub() || c.container() instanceof Model).forEach(c -> this.createComponentConstraint((List<Frame>)frames, (Mogram)c));
        this.allReferences(container).forEach(c -> this.createComponentConstraint((List<Frame>)frames, (HasMogram)c));
        return frames;
    }

    private void createComponentConstraint(List<Frame> frames, Mogram mogram) {
        List<Mogram> candidates = this.collectCandidates(mogram);
        Size size = mogram.container().sizeOf((Element)mogram);
        List<Rule<?>> allRules = mogram.container().rulesOf((Element)mogram).stream().distinct().collect(Collectors.toList());
        if ((size.isSingle() || size.isRequired()) && candidates.size() > 1) {
            FrameBuilder oneOfBuilder = this.createOneOf(candidates, allRules);
            if (!mogram.is(Annotation.Generalization) && !candidates.contains(mogram)) {
                oneOfBuilder.add("constraint", (Object)this.createComponentConstraint(mogram, allRules));
            }
            if (!mogram.isSub()) {
                frames.add(oneOfBuilder.toFrame());
            }
        } else {
            frames.addAll(candidates.stream().filter(c -> this.componentCompliant(c.container(), (Mogram)c)).map(c -> this.createComponentConstraint((Mogram)c, allRules)).toList());
        }
    }

    private void createComponentConstraint(List<Frame> frames, HasMogram mogram) {
        Mogram target = (Mogram)mogram.target().get();
        List<Mogram> candidates = this.collectCandidates(target);
        Size size = mogram.container().sizeOf((Element)mogram);
        List<Rule<?>> allRules = mogram.container().rulesOf((Element)mogram).stream().distinct().collect(Collectors.toList());
        if ((size.isSingle() || size.isRequired()) && candidates.size() > 1) {
            FrameBuilder oneOfBuilder = this.createOneOf(candidates, allRules);
            if (!target.is(Annotation.Generalization) && !candidates.contains(target)) {
                oneOfBuilder.add("constraint", (Object)this.createComponentConstraint(target, allRules));
            }
            if (!target.isSub()) {
                frames.add(oneOfBuilder.toFrame());
            }
        } else {
            frames.addAll(candidates.stream().filter(c -> this.componentCompliant((ElementContainer)mogram.container(), (Mogram)c)).map(c -> this.createComponentConstraint((Mogram)c, allRules)).toList());
        }
    }

    private Frame createComponentConstraint(Mogram component, List<Rule<?>> rules) {
        FrameBuilder builder = new FrameBuilder(new String[]{"constraint", "component"}).add("type", (Object)this.name(component));
        builder.add("rule", (Object)this.createRulesFrames(rules));
        this.addAnnotations(component, builder);
        return builder.toFrame();
    }

    private FrameBuilder createOneOf(Collection<Mogram> candidates, List<Rule<?>> rules) {
        FrameBuilder builder = new FrameBuilder(new String[]{"oneOf", "constraint"});
        builder.add("rule", (Object)this.createRulesFrames(rules));
        for (Mogram candidate : candidates) {
            builder.add("constraint", (Object)this.createComponentConstraint(candidate, candidate.container().rulesOf((Element)candidate)));
        }
        return builder;
    }

    private List<Mogram> allComponents(ElementContainer container) {
        NamedReference parent;
        ArrayList<Mogram> components = new ArrayList<Mogram>(container.components());
        if (container instanceof Mogram) {
            Mogram m = (Mogram)container;
            v0 = m.parent();
        } else {
            v0 = parent = null;
        }
        while (parent != null) {
            components.addAll(0, ((Mogram)parent.get()).components().stream().filter(p -> components.stream().noneMatch(pr -> pr.name().equals(p.name()))).toList());
            parent = ((Mogram)parent.get()).parent();
        }
        return components;
    }

    private List<HasMogram> allReferences(ElementContainer container) {
        NamedReference parent;
        ArrayList<HasMogram> references = new ArrayList<HasMogram>(container.referenceComponents().stream().map(m -> (HasMogram)m).toList());
        if (container instanceof Mogram) {
            Mogram m2 = (Mogram)container;
            v0 = m2.parent();
        } else {
            v0 = parent = null;
        }
        while (parent != null) {
            references.addAll(0, ((Mogram)parent.get()).referenceComponents().stream().filter(has -> references.stream().noneMatch(c -> ((Mogram)c.target().get()).qualifiedName().equals(((Mogram)has.target().referent()).qualifiedName()))).map(m -> (HasMogram)m).toList());
            parent = ((Mogram)parent.get()).parent();
        }
        return references;
    }

    private boolean componentCompliant(ElementContainer container, Mogram mogram) {
        return mogram.facetPrescription() == null && !this.isFacetInstantiation(mogram) && (!(container instanceof MogramRoot) || this.rootCompliant(mogram));
    }

    private boolean isFacetInstantiation(Mogram mogram) {
        return mogram.metaMograms().stream().anyMatch(m -> m.facetPrescription() != null);
    }

    private boolean rootCompliant(Mogram c) {
        return !c.is(Annotation.Component) && !c.is(Annotation.Feature);
    }

    private String name(Mogram mogram) {
        return mogram.qualifiedName();
    }

    private Frame[] createRulesFrames(List<Rule<?>> rules) {
        return (Frame[])rules.stream().map(rule -> rule instanceof ConstraintRule ? this.buildCustomRuleFrame((ConstraintRule)rule) : new FrameBuilder().append(rule).toFrame()).filter(Objects::nonNull).toArray(Frame[]::new);
    }

    private Frame buildCustomRuleFrame(ConstraintRule rule) {
        return new FrameBuilder(new String[]{"rule", "customRule"}).add("qn", (Object)rule.reference().reference()).toFrame();
    }

    private void addAnnotations(Mogram mogram, FrameBuilder frame) {
        String[] tags = (String[])mogram.annotations().stream().filter(a -> !Annotation.Component.equals(a) && !Annotation.Decorable.equals(a) && !Annotation.Required.equals(a)).map(Enum::name).distinct().toArray(String[]::new);
        frame.add("tags", (Object)tags);
    }

    private List<Mogram> collectCandidates(Mogram mogram) {
        LinkedHashSet<Mogram> mograms = new LinkedHashSet<Mogram>();
        if (mogram.isAnonymous()) {
            return new ArrayList<Mogram>();
        }
        if (!mogram.is(Annotation.Generalization)) {
            mograms.add(mogram);
        }
        this.getNonAbstractChildren(mogram, mograms);
        return new ArrayList<Mogram>(mograms);
    }

    private void getNonAbstractChildren(Mogram mogram, Set<Mogram> mograms) {
        for (Mogram child : mogram.children()) {
            if (!child.is(Annotation.Generalization)) {
                mograms.add(child);
            }
            this.getNonAbstractChildren(child, mograms);
        }
    }
}

