/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder;

import io.intino.builder.CompilerMessage;
import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.SourceUnit;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.errorcollection.ErrorCollector;
import io.intino.tara.builder.core.errorcollection.MultipleCompilationErrorsException;
import io.intino.tara.builder.core.errorcollection.TaraRuntimeException;
import io.intino.tara.builder.core.errorcollection.message.DependencyErrorMessage;
import io.intino.tara.builder.core.errorcollection.message.ExceptionMessage;
import io.intino.tara.builder.core.errorcollection.message.Message;
import io.intino.tara.builder.core.errorcollection.message.SemanticErrorMessage;
import io.intino.tara.builder.core.errorcollection.message.SimpleMessage;
import io.intino.tara.builder.core.errorcollection.message.SyntaxErrorMessage;
import io.intino.tara.builder.core.errorcollection.message.WarningMessage;
import io.intino.tara.language.grammar.SyntaxException;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.model.Element;
import io.intino.tara.processors.dependencyresolution.DependencyException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TaraCompiler {
    private static final String LINE_AT = " @ line ";
    private final List<CompilerMessage> collector;

    public TaraCompiler(List<CompilerMessage> collector) {
        this.collector = collector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OutputItem> compile(CompilationUnit unit) {
        ArrayList<OutputItem> compiledFiles = new ArrayList<OutputItem>();
        try {
            unit.compile();
            this.addCompiledFiles(unit, compiledFiles);
        }
        catch (CompilationFailedException e) {
            this.processCompilationException(e);
        }
        catch (TaraRuntimeException e) {
            this.processException(e);
        }
        finally {
            this.addWarnings(unit.getErrorCollector(), this.collector);
        }
        return compiledFiles;
    }

    private void addCompiledFiles(CompilationUnit compilationUnit, List<OutputItem> compiledFiles) {
        for (Map.Entry<String, List<String>> entry : compilationUnit.getOutputItems().entrySet()) {
            compiledFiles.addAll(entry.getValue().stream().map(outFile -> new OutputItem((String)entry.getKey(), (String)outFile)).toList());
        }
    }

    private void addWarnings(ErrorCollector errorCollector, List<CompilerMessage> collector) {
        for (int i = 0; i < errorCollector.getWarningCount(); ++i) {
            WarningMessage warning = errorCollector.getWarning(i);
            collector.add(new CompilerMessage("warning", warning.getMessage(), ((SourceUnit)warning.getOwner()).uri().getPath(), warning.line(), warning.column()));
        }
    }

    private void processCompilationException(Exception exception) {
        if (exception instanceof MultipleCompilationErrorsException) {
            MultipleCompilationErrorsException errorsException = (MultipleCompilationErrorsException)exception;
            ErrorCollector errorCollector = errorsException.getErrorCollector();
            for (int i = 0; i < errorCollector.getErrorCount(); ++i) {
                this.processException(errorCollector.getError(i));
            }
        } else {
            this.processException(exception);
        }
    }

    private void processException(Message message) {
        if (message instanceof SyntaxErrorMessage) {
            this.addErrorMessage(((SyntaxErrorMessage)message).getCause());
        } else if (message instanceof SemanticErrorMessage) {
            this.addErrorMessage(((SemanticErrorMessage)message).getCause());
        } else if (message instanceof DependencyErrorMessage) {
            this.addErrorMessage(((DependencyErrorMessage)message).getCause());
        } else if (message instanceof ExceptionMessage) {
            this.processException(((ExceptionMessage)message).getCause());
        } else if (message instanceof SimpleMessage) {
            this.addErrorMessage((SimpleMessage)message, this.collector);
        } else {
            this.addMessageWithoutLocation(this.collector, "An unknown error occurred: " + String.valueOf(message), true);
        }
    }

    private void processException(Throwable e) {
        if (e instanceof TaraRuntimeException) {
            this.addErrorMessage((TaraRuntimeException)e);
            return;
        }
        this.addMessageWithoutLocation(this.collector, e.getMessage(), true);
    }

    private void addMessageWithoutLocation(List<CompilerMessage> collector, String message, boolean error) {
        collector.add(new CompilerMessage(error ? "error" : "warning", message, null, -1, -1));
    }

    private void addErrorMessage(SyntaxException exception) {
        String message = exception.getMessage();
        String justMessage = message.substring(0, message.lastIndexOf(LINE_AT));
        this.collector.add(new CompilerMessage("error", justMessage, exception.getUri().getPath(), exception.getLine(), exception.getStartColumn()));
    }

    private void addErrorMessage(SemanticException ex) {
        if (ex.getIssue().origin() != null) {
            Element[] origins;
            String message = ex.getMessage().contains(LINE_AT) ? ex.getMessage().substring(0, ex.getMessage().lastIndexOf(LINE_AT)) : ex.getMessage();
            for (Element element : origins = ex.getIssue().origin()) {
                this.collector.add(new CompilerMessage("error", message, element.source().getPath(), element.line(), element.textRange().startColumn()));
            }
        } else {
            this.collector.add(new CompilerMessage("error", ex.getMessage(), null, -1, -1));
        }
    }

    private void addErrorMessage(DependencyException exception) {
        String message = exception.getMessage();
        String justMessage = message.substring(0, message.lastIndexOf(LINE_AT));
        this.collector.add(new CompilerMessage("error", justMessage, exception.getElement().source().getPath(), exception.getLine(), 1));
    }

    private void addErrorMessage(TaraRuntimeException exception) {
        Element element = exception.getElement();
        this.collector.add(element != null ? new CompilerMessage("error", exception.getMessageWithoutLocationText(), element.source().getPath(), element.line(), element.textRange().startColumn()) : new CompilerMessage("error", exception.getMessageWithoutLocationText(), "null", -1, -1));
    }

    private void addErrorMessage(SimpleMessage message, List collector) {
        this.addMessageWithoutLocation(collector, message.getMessage(), true);
    }

    public static class OutputItem {
        private final String myOutputPath;
        private final String mySourceFileName;

        OutputItem(String sourceFileName, String outputFilePath) {
            this.myOutputPath = outputFilePath;
            this.mySourceFileName = sourceFileName;
        }

        public String getOutputPath() {
            return this.myOutputPath;
        }

        public String getSourceFile() {
            return this.mySourceFileName;
        }
    }
}

