/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder;

import io.intino.tara.Source;
import io.intino.tara.builder.SourceProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileSourceProvider
implements SourceProvider {
    private final List<Source> sources;

    public FileSourceProvider(Map<URI, Boolean> sources) {
        this.sources = FileSourceProvider.mapSources(sources);
    }

    @Override
    public Stream<Source> all() {
        return this.sources.stream();
    }

    @Override
    public Source get(URI uri) {
        return this.sources.stream().filter(u -> u.uri().equals(uri)).findFirst().orElse(null);
    }

    private static List<Source> mapSources(Map<URI, Boolean> sources) {
        return sources.entrySet().stream().map(e -> new Source((Map.Entry)e){
            final /* synthetic */ Map.Entry val$e;
            {
                this.val$e = entry;
            }

            public URI uri() {
                return (URI)this.val$e.getKey();
            }

            public Charset charset() {
                return Charset.defaultCharset();
            }

            public InputStream content() throws IOException {
                return ((URI)this.val$e.getKey()).toURL().openStream();
            }

            public boolean dirty() {
                return (Boolean)this.val$e.getValue();
            }
        }).collect(Collectors.toList());
    }
}

