/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.semantic;

import io.intino.tara.Language;
import io.intino.tara.Tara;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.utils.Format;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Logger;

public class LanguageLoader {
    private static final Logger LOG = Logger.getGlobal();
    private static final String LANGUAGE_PACKAGE = "tara.dsl";

    private LanguageLoader() {
    }

    public static Language load(String name, String version, String languagesDirectory) throws TaraException {
        String[] errorMessage = new String[]{"Impossible to create a language instance based in " + name};
        Language language = LanguageLoader.load(name, version, languagesDirectory, errorMessage);
        if (language == null) {
            throw new TaraException(errorMessage[0]);
        }
        return language;
    }

    private static Language load(String name, String version, String languagesDirectory, String[] errorMessage) {
        try {
            File jar = LanguageLoader.getLanguagePath(name, version, languagesDirectory);
            if (!jar.exists()) {
                errorMessage[0] = "Language file not found: " + jar.getPath();
            }
            URLClassLoader cl = new URLClassLoader(new URL[]{jar.toURI().toURL()}, Tara.class.getClassLoader());
            Class<?> cls = cl.loadClass("tara.dsl." + Format.toCamelCase().format((Object)name));
            return (Language)cls.getConstructors()[0].newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException | MalformedURLException e1) {
            LOG.severe(e1.getMessage());
            return null;
        }
    }

    public static File getLanguagePath(String name, String version, String languagesDirectory) {
        String effectiveVersion = version.equals("LATEST") ? LanguageLoader.findLatestVersion(new File(languagesDirectory + File.separator + LanguageLoader.languageGroupId().toLowerCase() + name.toLowerCase())) : version;
        return new File(languagesDirectory + File.separator + LanguageLoader.languageGroupId().toLowerCase() + name.toLowerCase() + File.separator + effectiveVersion, name + "-" + effectiveVersion + ".jar");
    }

    private static String languageGroupId() {
        return "tara" + File.separator + "dsl" + File.separator;
    }

    private static String findLatestVersion(File languageDirectory) {
        File[] files = languageDirectory.listFiles(File::isDirectory);
        if (files == null || files.length == 0) {
            return "1.0.0";
        }
        return files[files.length - 1].getName();
    }
}

