/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.parser.antlr;

import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.core.SourceReader;
import io.intino.tara.builder.core.errorcollection.SyntaxException;
import io.intino.tara.builder.model.FacetImpl;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.builder.model.MogramReference;
import io.intino.tara.builder.model.VariableImpl;
import io.intino.tara.builder.model.VariableReference;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.language.grammar.TaraGrammarBaseListener;
import io.intino.tara.language.model.Element;
import io.intino.tara.language.model.EmptyMogram;
import io.intino.tara.language.model.Facet;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Parametrized;
import io.intino.tara.language.model.Primitive;
import io.intino.tara.language.model.Rule;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.model.rules.composition.MogramCustomRule;
import io.intino.tara.language.model.rules.variable.DoubleRule;
import io.intino.tara.language.model.rules.variable.FileRule;
import io.intino.tara.language.model.rules.variable.IntegerRule;
import io.intino.tara.language.model.rules.variable.NativeObjectRule;
import io.intino.tara.language.model.rules.variable.NativeRule;
import io.intino.tara.language.model.rules.variable.StringRule;
import io.intino.tara.language.model.rules.variable.VariableCustomRule;
import io.intino.tara.language.model.rules.variable.VariableRule;
import io.intino.tara.language.model.rules.variable.WordRule;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ModelGenerator
extends TaraGrammarBaseListener {
    private final SourceReader reader;
    private final String outDsl;
    private final Deque<Mogram> deque = new ArrayDeque<Mogram>();
    private final Set<String> uses = new HashSet<String>();
    private final Model model;
    private final CompilerConfiguration.Language language;
    private final List<SyntaxException> errors = new ArrayList<SyntaxException>();
    private final String fileContent;

    public ModelGenerator(SourceReader reader, CompilerConfiguration.Language language, String outDsl) {
        this.reader = reader;
        this.language = language;
        this.outDsl = outDsl;
        this.model = new Model(reader.getSource().uri());
        this.deque.add((Mogram)this.model);
        try {
            this.fileContent = reader.content();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void enterAnImport(TaraGrammar.AnImportContext ctx) {
        this.uses.add(ctx.headerReference().getText());
    }

    @Override
    public void enterDslDeclaration(TaraGrammar.DslDeclarationContext ctx) {
        if (ctx.headerReference() != null) {
            String langName = ctx.headerReference().getText();
            this.model.setLanguage(this.language.get());
            if (this.model.languageName().isEmpty()) {
                this.addError("Language " + langName + " not found", ctx);
            }
        } else {
            this.addError("Language not found", ctx);
        }
    }

    @Override
    public void enterMogram(TaraGrammar.MogramContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        MogramImpl node = new MogramImpl(this.fileContent.substring(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex() + 1));
        node.languageName(this.model.languageName());
        node.setSub(ctx.signature().SUB() != null);
        String hashCodeName = this.calculateName(ctx);
        if (ctx.signature().IDENTIFIER() != null) {
            node.name(ctx.signature().IDENTIFIER().getText());
        } else {
            node.name(hashCodeName);
        }
        node.setHashCode(hashCodeName);
        Mogram container = this.resolveContainer(node);
        node.type(node.isSub() ? this.deque.peek().type() : ctx.signature().metaidentifier().getText());
        this.resolveParent(ctx, node);
        List rules = this.createCompositionRule(this.compositionRules(ctx.signature().mogramConstraint()));
        if (rules == null && node.isSub()) {
            rules = container.rulesOf(node.parent());
        } else if (rules == null) {
            rules = Collections.singletonList(Size.MULTIPLE());
        }
        container.add((Mogram)node, rules);
        node.container(container);
        this.addTags(ctx.signature().tags(), node);
        this.addHeaderInformation(ctx, (Element)node);
        node.addUses(new ArrayList<String>(this.uses));
        this.deque.push(node);
    }

    private String calculateName(TaraGrammar.MogramContext ctx) {
        int hashCode = ctx.getText().replace(" ", "").hashCode();
        String name = new File(this.reader.getSource().uri()).getName();
        return name.substring(0, name.indexOf(".")) + "_" + ctx.getStart().getLine() + "_" + ctx.getStart().getCharPositionInLine() + "_" + (hashCode > 0 ? "0" + hashCode : "1" + Math.abs(hashCode));
    }

    private List<TaraGrammar.MogramConstraintContext> compositionRules(List<TaraGrammar.MogramConstraintContext> container) {
        ArrayList<TaraGrammar.MogramConstraintContext> contexts = new ArrayList<TaraGrammar.MogramConstraintContext>();
        if (container.isEmpty()) {
            return Collections.emptyList();
        }
        if (container.size() == 1) {
            if (this.isInto(container.get(0))) {
                contexts.add(null);
            }
        } else {
            return container;
        }
        contexts.add(container.get(0));
        return contexts;
    }

    private boolean isInto(TaraGrammar.MogramConstraintContext mogramConstraint) {
        List children = ((ParserRuleContext)mogramConstraint.parent).children;
        ParseTree node = (ParseTree)children.get(children.indexOf((Object)mogramConstraint) - 1);
        return !(node instanceof TaraGrammar.MetaidentifierContext || node instanceof TerminalNode && node.getText().equals("sub") || node instanceof TerminalNode && node.getText().equals("has"));
    }

    private List<Rule> createCompositionRule(List<TaraGrammar.MogramConstraintContext> mogramConstraint) {
        if (mogramConstraint == null || mogramConstraint.isEmpty()) {
            return Collections.singletonList(Size.MULTIPLE());
        }
        return mogramConstraint.stream().map(context -> this.createRule(context.ruleValue())).collect(Collectors.toList());
    }

    private Rule createRule(TaraGrammar.RuleValueContext rule) {
        return this.isCustom(rule) ? new MogramCustomRule(rule.getText()) : this.processLambdaRule(rule);
    }

    private boolean isCustom(TaraGrammar.RuleValueContext isRule) {
        return isRule != null && isRule.LEFT_CURLY() == null;
    }

    private void addTags(TaraGrammar.TagsContext ctx, Mogram mogram) {
        if (ctx == null) {
            return;
        }
        if (ctx.flags() != null) {
            mogram.addFlags(this.resolveTags(ctx.flags()).toArray(new Tag[0]));
        }
        if (ctx.annotations() != null) {
            mogram.addAnnotations(this.resolveTags(ctx.annotations()));
        }
    }

    private Mogram resolveContainer(Mogram mogram) {
        Mogram context = this.deque.peek();
        if (mogram.isSub()) {
            return context.container();
        }
        return context;
    }

    private void resolveParent(TaraGrammar.MogramContext ctx, MogramImpl node) {
        if (node.isSub()) {
            Mogram peek = this.deque.peek();
            if (!peek.isAbstract() && !peek.flags().contains(Tag.Abstract)) {
                peek.addFlags(new Tag[]{Tag.Abstract});
            }
            node.setParent(peek);
            peek.addChild((Mogram)node);
            node.setParentName(peek.name());
        } else {
            node.setParentName(this.getParent(ctx));
        }
    }

    private String getParent(TaraGrammar.MogramContext ctx) {
        if (ctx.signature().parent() == null) {
            return null;
        }
        TaraGrammar.IdentifierReferenceContext identifierReference = ctx.signature().parent().identifierReference();
        return identifierReference != null ? identifierReference.getText() : null;
    }

    private void addHeaderInformation(ParserRuleContext ctx, Element element) {
        element.languageName(this.model.languageName());
        element.line(ctx.getStart().getLine());
        element.column(ctx.getStart().getCharPositionInLine());
        element.file(new File(this.reader.getSource().uri()).getAbsolutePath());
    }

    @Override
    public void exitMogram(TaraGrammar.MogramContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        this.deque.pop();
    }

    @Override
    public void enterWith(TaraGrammar.WithContext ctx) {
        if (this.deque.peek() == null) {
            this.addError("Unavailable constraint 'with' in context " + this.deque.peek().getClass().getInterfaces()[0].getSimpleName(), ctx);
            return;
        }
        MogramImpl peek = (MogramImpl)this.deque.peek();
        peek.facetConstraints(this.collectConstrains(ctx.identifierReference()));
        super.enterWith(ctx);
    }

    private List<String> collectConstrains(List<TaraGrammar.IdentifierReferenceContext> contexts) {
        return contexts.stream().map(RuleContext::getText).collect(Collectors.toList());
    }

    @Override
    public void enterFacet(TaraGrammar.FacetContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        FacetImpl facet = new FacetImpl(ctx.metaidentifier().getText());
        this.addHeaderInformation(ctx, (Element)facet);
        if (this.deque.peek() == null) {
            this.addError("Unavailable component facet apply in context " + this.deque.peek().getClass().getInterfaces()[0].getSimpleName(), ctx);
            return;
        }
        Mogram current = this.deque.peek();
        current.applyFacets(new Facet[]{facet});
        facet.container(current);
    }

    @Override
    public void enterDoc(TaraGrammar.DocContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (TerminalNode doc : ctx.DOC()) {
            builder.append(doc.getText().substring(2));
        }
        String trim = builder.toString().trim();
        this.deque.peek().doc(trim);
    }

    @Override
    public void enterSignatureProperty(TaraGrammar.SignaturePropertyContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        int position = ((TaraGrammar.SignaturePropertiesContext)ctx.getParent()).signatureProperty().indexOf((Object)ctx);
        String metric = ctx.value().measureUnit() != null ? ctx.value().measureUnit().getText() : null;
        this.addParameter(ctx.IDENTIFIER() != null ? ctx.IDENTIFIER().getText() : "", this.facetOf(ctx), position, metric, this.resolveValue(ctx.value()), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine());
    }

    private String facetOf(TaraGrammar.SignaturePropertyContext ctx) {
        return ctx.getParent().getParent() instanceof TaraGrammar.FacetContext ? ((TaraGrammar.FacetContext)ctx.getParent().getParent()).metaidentifier().getText() : "";
    }

    private void addParameter(String name, String facet, int position, String measureValue, List<Object> values, int line, int column) {
        Parametrized object = (Parametrized)this.deque.peek();
        object.addParameter(name, facet, position, measureValue, line, column, values);
    }

    @Override
    public void enterMogramReference(TaraGrammar.MogramReferenceContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        Mogram container = this.deque.peek();
        MogramReference nodeReference = new MogramReference(ctx.identifierReference().getText());
        nodeReference.addUses(new ArrayList<String>(this.uses));
        this.addHeaderInformation(ctx, (Element)nodeReference);
        nodeReference.setHas(true);
        this.addTags(ctx.tags(), nodeReference);
        nodeReference.container(container);
        List<Rule> rules = this.createCompositionRule(ctx.mogramConstraint() != null ? this.compositionRules(ctx.mogramConstraint()) : Collections.emptyList());
        container.add((Mogram)nodeReference, rules);
    }

    private Tag[] resolveTags(TaraGrammar.AnnotationsContext annotations) {
        if (annotations == null) {
            return new Tag[0];
        }
        return (Tag[])annotations.annotation().stream().map(a -> Tag.valueOf((String)Format.capitalize(a.getText()))).toArray(Tag[]::new);
    }

    private List<Tag> resolveTags(TaraGrammar.FlagsContext flags) {
        if (flags == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Tag>(flags.flag().stream().map(f -> Tag.valueOf((String)Format.capitalize(f.getText()))).collect(Collectors.toList()));
    }

    @Override
    public void enterProperty(TaraGrammar.PropertyContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        Mogram container = this.deque.peek();
        Variable variable = this.createVariable(ctx, container);
        this.addHeaderInformation(ctx, (Element)variable);
        this.addValue(variable, ctx);
        Size size = this.createSize(ctx);
        if (!variable.values().isEmpty()) {
            size = new Size(0, size.max(), size.into());
        }
        variable.size(size);
        variable.rule(ctx.mogramConstraint() != null ? this.createRule(variable, ctx.mogramConstraint().ruleValue()) : variable.type().defaultRule());
        List<Tag> tags = this.resolveTags(ctx.flags());
        variable.addFlags(tags.toArray(new Tag[0]));
        container.add(new Variable[]{variable});
    }

    private Size createSize(TaraGrammar.PropertyContext context) {
        TaraGrammar.SizeContext sizeContext = context.size();
        if (sizeContext == null) {
            return Size.SINGLE_REQUIRED();
        }
        TaraGrammar.SizeRangeContext rangeContext = sizeContext.sizeRange();
        if (rangeContext == null) {
            return new Size(1, Integer.MAX_VALUE);
        }
        TaraGrammar.ListRangeContext listRange = rangeContext.listRange();
        if (listRange != null) {
            return new Size(Integer.parseInt(((ParseTree)listRange.children.get(0)).getText()), Integer.parseInt(((ParseTree)listRange.children.get(listRange.children.size() - 1)).getText()));
        }
        int minMax = Integer.parseInt(rangeContext.getText());
        return new Size(minMax, minMax);
    }

    private VariableRule createRule(Variable variable, TaraGrammar.RuleValueContext rule) {
        if (this.isCustom(rule)) {
            if (Primitive.FUNCTION.equals((Object)variable.type())) {
                return new NativeRule(rule.getText());
            }
            if (Primitive.OBJECT.equals((Object)variable.type())) {
                return new NativeObjectRule(rule.getText());
            }
            return this.isBundledRule(rule.identifierReference().getText()) ? this.createDefault(rule.identifierReference().getText()) : new VariableCustomRule(rule.getText());
        }
        return this.processLambdaRule(variable, rule);
    }

    private boolean isBundledRule(String text) {
        try {
            Class.forName("tara.lang.model.rules.custom." + Format.firstUpperCase().format((Object)text));
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private VariableRule createDefault(String rule) {
        try {
            return (VariableRule)Class.forName("tara.lang.model.rules.custom." + Format.firstUpperCase().format((Object)rule)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private VariableRule processLambdaRule(Variable var, TaraGrammar.RuleValueContext rule) {
        List<ParseTree> params = rule.children.subList(1, rule.children.size() - 1);
        if (Primitive.DOUBLE.equals((Object)var.type())) {
            return new DoubleRule(this.minOf(params), this.maxOf(params), this.metric(params));
        }
        if (Primitive.INTEGER.equals((Object)var.type())) {
            return new IntegerRule(this.minOf(params).intValue(), this.maxOf(params).intValue(), this.metric(params));
        }
        if (Primitive.STRING.equals((Object)var.type())) {
            this.createStringVariable(var, params);
        } else {
            if (Primitive.RESOURCE.equals((Object)var.type())) {
                return new FileRule(this.valuesOf(params));
            }
            if (Primitive.FUNCTION.equals((Object)var.type())) {
                return new NativeRule(params.get(0).getText());
            }
            if (Primitive.WORD.equals((Object)var.type())) {
                return new WordRule(this.valuesOf(params));
            }
            if (Primitive.OBJECT.equals((Object)var.type())) {
                return new NativeObjectRule(this.classFrom(params.get(0).getText()));
            }
        }
        return null;
    }

    private String classFrom(String text) {
        return text.startsWith("\"") ? text.substring(1, text.length() - 1) : text;
    }

    private Rule processLambdaRule(TaraGrammar.RuleValueContext isRule) {
        return isRule == null ? null : this.createNodeRule(isRule);
    }

    private Size createNodeRule(TaraGrammar.RuleValueContext rule) {
        List<ParseTree> params = rule.children.subList(1, rule.children.size() - 1);
        if (this.isNamedSize(params)) {
            return this.createNamedSize(params);
        }
        int min = this.minOf(params).intValue();
        if (min < 0) {
            this.addError("Array size cannot be negative", rule);
        }
        return new Size(min, this.maxOf(params).intValue(), null);
    }

    private Size createNamedSize(List<ParseTree> params) {
        int min = 0;
        int max = Integer.MAX_VALUE;
        for (ParseTree param : params) {
            if (param.getText().equalsIgnoreCase("single")) {
                max = 1;
                continue;
            }
            if (!param.getText().equalsIgnoreCase("required")) continue;
            min = 1;
        }
        return new Size(min, max);
    }

    private boolean isNamedSize(List<ParseTree> params) {
        for (ParseTree param : params) {
            if (param.getText().equalsIgnoreCase("single") || param.getText().equalsIgnoreCase("required")) continue;
            return false;
        }
        return true;
    }

    private void createStringVariable(Variable variable, List<ParseTree> parameters) {
        String value = this.valueOf(parameters, TaraGrammar.StringValueContext.class);
        if (value.isEmpty()) {
            this.addError("Expected pattern rule", (ParserRuleContext)parameters.get(0).getParent());
            return;
        }
        variable.rule((VariableRule)new StringRule(value.substring(1, value.length() - 1)));
    }

    private String metric(List<ParseTree> parameters) {
        for (ParseTree parameter : parameters) {
            if (!(parameter instanceof TerminalNode) && !(parameter instanceof TaraGrammar.MeasureUnitContext)) continue;
            return parameter.getText();
        }
        return "";
    }

    private List<String> valuesOf(List<ParseTree> parameters) {
        return parameters.stream().map(ParseTree::getText).collect(Collectors.toList());
    }

    private String valueOf(List<ParseTree> parameters, Class<? extends ParserRuleContext> aClass) {
        ParseTree value = parameters.stream().filter(aClass::isInstance).findFirst().orElse(null);
        return value == null ? "" : value.getText();
    }

    private Double minOf(List<ParseTree> parameters) {
        TaraGrammar.RangeContext range = parameters.stream().filter(TaraGrammar.RangeContext.class::isInstance).findFirst().orElse(null);
        if (range == null) {
            return Double.NEGATIVE_INFINITY;
        }
        String min = ((ParseTree)range.children.get(0)).getText();
        return min.equals("*") ? Double.NEGATIVE_INFINITY : Double.parseDouble(min);
    }

    private Double maxOf(List<ParseTree> parameters) {
        TaraGrammar.RangeContext range = parameters.stream().filter(TaraGrammar.RangeContext.class::isInstance).findFirst().orElse(null);
        if (range == null) {
            return Double.POSITIVE_INFINITY;
        }
        String max = ((ParseTree)range.children.get(range.children.size() - 1)).getText();
        return max.equals("*") ? Double.POSITIVE_INFINITY : Double.parseDouble(max);
    }

    private Variable createVariable(TaraGrammar.PropertyContext ctx, Mogram container) {
        TaraGrammar.PropertyTypeContext variableType = ctx.propertyType();
        return variableType.identifierReference() != null ? new VariableReference(container, variableType.getText(), ctx.IDENTIFIER().getText(), this.outDsl) : new VariableImpl(container, Primitive.value((String)variableType.getText()), ctx.IDENTIFIER().getText(), this.outDsl);
    }

    private void addValue(Variable variable, TaraGrammar.PropertyContext ctx) {
        List<Object> values;
        if (ctx.value() == null && ctx.bodyValue() == null) {
            return;
        }
        List<Object> list = values = ctx.bodyValue() != null ? this.resolveValue(ctx.bodyValue()) : this.resolveValue(ctx.value());
        if (variable.type().equals((Object)Primitive.DOUBLE) && !values.isEmpty() && values.get(0) instanceof Integer) {
            values = values.stream().map(v -> (double)((Integer)v)).collect(Collectors.toList());
        }
        variable.values(values);
        if (ctx.value() != null && ctx.value().measureUnit() != null) {
            variable.defaultMetric(ctx.value().measureUnit().getText());
        }
    }

    @Override
    public void enterPropertyInit(TaraGrammar.PropertyInitContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        String extension = ctx.value() != null && ctx.value().measureUnit() != null ? ctx.value().measureUnit().getText() : null;
        this.addParameter(ctx.IDENTIFIER().getText(), "", -1, extension, ctx.bodyValue() != null ? this.resolveValue(ctx.bodyValue()) : this.resolveValue(ctx.value()), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine());
    }

    private List<Object> resolveValue(TaraGrammar.ValueContext ctx) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (!ctx.booleanValue().isEmpty()) {
            values.addAll(ctx.booleanValue().stream().map(context -> Primitive.BOOLEAN.convert(new String[]{context.getText()}).get(0)).toList());
        } else if (!ctx.integerValue().isEmpty()) {
            values.addAll(ctx.integerValue().stream().map(context -> {
                try {
                    return Primitive.INTEGER.convert(new String[]{context.getText()}).get(0);
                }
                catch (NumberFormatException e) {
                    return Primitive.LONG.convert(new String[]{context.getText()}).get(0);
                }
            }).toList());
        } else if (!ctx.doubleValue().isEmpty()) {
            values.addAll(ctx.doubleValue().stream().map(context -> Primitive.DOUBLE.convert(new String[]{context.getText()}).get(0)).toList());
        } else if (!ctx.tupleValue().isEmpty()) {
            values.addAll(ctx.tupleValue().stream().map(context -> new AbstractMap.SimpleEntry(context.stringValue().getText(), Primitive.DOUBLE.convert(new String[]{context.doubleValue().getText()}).get(0))).collect(Collectors.toList()));
        } else if (!ctx.stringValue().isEmpty()) {
            values.addAll(ctx.stringValue().stream().map(context -> this.formatString(context.getText())).toList());
        } else if (!ctx.identifierReference().isEmpty()) {
            values.addAll(ctx.identifierReference().stream().map(context -> new Primitive.Reference(context.getText())).toList());
        } else if (!ctx.methodReference().isEmpty()) {
            values.addAll(ctx.methodReference().stream().map(context -> new Primitive.MethodReference(context.getText().substring(1))).toList());
        } else if (!ctx.expression().isEmpty()) {
            values.addAll(ctx.expression().stream().map(context -> new Primitive.Expression(this.formatExpression(context.getText()).trim())).toList());
        } else if (ctx.EMPTY() != null) {
            values.add(new EmptyMogram());
        }
        return values;
    }

    private List<Object> resolveValue(TaraGrammar.BodyValueContext ctx) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (ctx.stringValue() != null) {
            values.add(this.formatString(ctx.stringValue().getText()));
        } else if (ctx.expression() != null) {
            values.add(new Primitive.Expression(this.formatExpression(ctx.expression().getText()).trim()));
        }
        return values;
    }

    private String formatExpression(String value) {
        if (!value.trim().startsWith("--")) {
            return value.substring(1, value.length() - 1).replace("\\\"", "\"");
        }
        return this.format(value.trim().replaceAll("--(-*)\\n", "").replaceAll("--(-*)", ""));
    }

    private String formatString(String text) {
        String value = text.replace("\r", "");
        if (!value.trim().startsWith("==")) {
            return value.substring(1, value.length() - 1).replace("\\\"", "\"");
        }
        return this.format(value.trim().replaceAll("==(=*)\\n", "").replaceAll("==(=*)", "")).replace("\\=", "=");
    }

    private String format(String text) {
        String pattern = this.pattern(text);
        StringBuilder result = new StringBuilder();
        for (String line : text.split("\\n")) {
            result.append(line.replaceFirst(pattern, "")).append("\n");
        }
        while (result.toString().endsWith("\n")) {
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        return result.toString();
    }

    private String pattern(String text) {
        if (!text.contains("\n")) {
            return text;
        }
        String replace = text.substring(0, text.indexOf("\n"));
        return replace.replace(replace.trim(), "");
    }

    public Model getModel() {
        this.model.setUses(new ArrayList<String>(this.uses));
        return this.model;
    }

    public List<SyntaxException> getErrors() {
        return this.errors;
    }

    private void addError(String message, ParserRuleContext ctx) {
        this.errors.add(new SyntaxException(message, ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), ""));
    }
}

