/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.parser;

import io.intino.tara.Language;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.core.SourceUnit;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.language.model.Mogram;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ASTMerger {
    private final Collection<SourceUnit> sources;
    private final CompilerConfiguration conf;

    public ASTMerger(Collection<SourceUnit> sources, CompilerConfiguration conf) {
        this.sources = sources;
        this.conf = conf;
    }

    public Map<Language, Model> doMerge() {
        Map<Language, List<SourceUnit>> languageListMap = this.groupByLanguage();
        HashMap<Language, Model> models = new HashMap<Language, Model>();
        for (Language language : languageListMap.keySet()) {
            models.put(language, this.processByLanguage(language, languageListMap.get(language)));
        }
        return models;
    }

    private Model processByLanguage(Language language, List<SourceUnit> sourceUnits) {
        Model model = new Model(this.uri());
        model.setLanguage(language);
        model.setResourcesRoot(this.conf.resourcesDirectory());
        model.level(this.conf.model().level());
        for (SourceUnit unit : sourceUnits) {
            List<Mogram> components = unit.getModel().components();
            components.forEach(c -> {
                model.add((Mogram)c, unit.getModel().rulesOf((Mogram)c));
                ((MogramImpl)c).setDirty(unit.isDirty());
            });
            if (components.isEmpty()) continue;
            model.languageName(components.get(0).languageName());
        }
        for (Mogram mogram : model.components()) {
            mogram.container((Mogram)model);
        }
        return model;
    }

    private Map<Language, List<SourceUnit>> groupByLanguage() {
        HashMap<Language, List<SourceUnit>> list = new HashMap<Language, List<SourceUnit>>();
        for (SourceUnit source : this.sources) {
            if (source.getModel().components().isEmpty()) continue;
            if (!list.containsKey(source.getModel().language())) {
                list.put(source.getModel().language(), new ArrayList());
            }
            ((List)list.get(source.getModel().language())).add(source);
        }
        return list;
    }

    private URI uri() {
        return URI.create((String)(this.conf.getProject() != null ? this.conf.getProject() + "." + this.conf.model().outDsl() : this.getPresentableName()));
    }

    private String getPresentableName() {
        String name = new File(this.sources.iterator().next().getPath()).getName();
        return name.substring(0, name.lastIndexOf("."));
    }
}

