/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.model;

import io.intino.tara.Language;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramRoot;
import io.intino.tara.language.model.Rule;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Model
implements MogramRoot {
    private URI uri;
    private Language language;
    private CompilerConfiguration.Level level;
    private List<String> uses;
    private File resourcesRoot;
    private List<Mogram> facets;
    private final Map<Mogram, List<Rule>> components = new LinkedHashMap<Mogram, List<Rule>>();
    private final Map<String, File> rules = new HashMap<String, File>();

    public Model(URI uri) {
        this.uri = uri;
    }

    public String file() {
        try {
            return new File(this.uri).getAbsolutePath();
        }
        catch (Exception e) {
            return this.uri.toString();
        }
    }

    public void file(String file) {
        this.uri = new File(file).toURI();
    }

    public List<String> uses() {
        return this.uses;
    }

    public CompilerConfiguration.Level level() {
        return this.level;
    }

    public void level(CompilerConfiguration.Level level) {
        this.level = level;
    }

    public boolean contains(Mogram mogramContainer) {
        return this.components.containsKey(mogramContainer);
    }

    public void remove(Mogram mogram) {
        if (mogram != null) {
            this.components.remove(mogram);
        }
    }

    public String doc() {
        return "";
    }

    public List<Mogram> components() {
        return Collections.unmodifiableList(new ArrayList<Mogram>(this.components.keySet()));
    }

    public String type() {
        return "";
    }

    public void add(Mogram mogram, List<Rule> rule) {
        this.components.put(mogram, new ArrayList<Rule>(rule));
    }

    public List<Rule> rulesOf(Mogram component) {
        return this.components.get(component);
    }

    public Language language() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String languageName() {
        return this.language != null ? this.language.languageName() : "";
    }

    public List<Mogram> allFacets() {
        if (this.facets == null) {
            this.collectFacets();
        }
        return this.facets;
    }

    private void collectFacets() {
        this.facets = new ArrayList<Mogram>();
        for (Mogram mogram : this.components.keySet()) {
            if (mogram.isFacet()) {
                this.facets.add(mogram);
            }
            this.facets(mogram);
        }
    }

    private List<Mogram> facets(Mogram mogram) {
        ArrayList<Mogram> list = new ArrayList<Mogram>();
        mogram.components().forEach(n -> {
            if (n.isReference()) {
                return;
            }
            if (n.isFacet()) {
                list.add((Mogram)n);
            }
            list.addAll(this.facets((Mogram)n));
        });
        return list;
    }

    public void setUses(List<String> uses) {
        this.uses = uses;
    }

    public void addRule(String name, File rule) {
        this.rules.put(name, rule);
    }

    public Map<String, File> rules() {
        return this.rules;
    }

    public void setResourcesRoot(File resourceRoot) {
        this.resourcesRoot = resourceRoot;
    }

    public File resourcesRoot() {
        return this.resourcesRoot;
    }

    public boolean isMetaFacet() {
        return false;
    }

    public void stashNodeName(String name) {
    }
}

