/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.dependencyresolution;

import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.builder.model.MogramReference;
import io.intino.tara.builder.model.VariableReference;
import io.intino.tara.builder.utils.FileSystemUtils;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramContainer;
import io.intino.tara.language.model.Primitive;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ReferenceManager {
    private final Model model;

    ReferenceManager(Model model) {
        this.model = model;
    }

    public MogramImpl resolve(MogramReference reference) {
        return (MogramImpl)this.resolve(reference.getReference(), reference.container());
    }

    MogramImpl resolve(VariableReference variable, Mogram container) {
        Mogram result = this.resolve(variable.targetName(), container);
        return result instanceof MogramReference ? ((MogramReference)result).destination() : (MogramImpl)result;
    }

    Mogram resolveParameterReference(Primitive.Reference value, Mogram mogram) {
        String[] path = value.get().split("\\.");
        List<Mogram> roots = this.findRoots(mogram, path).stream().filter(n -> !n.equals((Object)mogram)).collect(Collectors.toList());
        return this.selectFromOptions(mogram, path, roots);
    }

    Mogram resolve(String reference, Mogram mogram) {
        String[] path = reference.split("\\.");
        Collection<Mogram> roots = this.findRoots(mogram, path);
        return this.selectFromOptions(mogram, path, roots);
    }

    Mogram resolveParent(String reference, Mogram mogram) {
        return this.resolve(reference.split("\\."), this.searchPossibleRoots(mogram, reference.split("\\.")[0], true));
    }

    private Mogram selectFromOptions(Mogram mogram, String[] path, Collection<Mogram> roots) {
        return this.resolve(path, this.sortRootsByFile(roots, mogram.file()));
    }

    private Collection<Mogram> sortRootsByFile(Collection<Mogram> roots, String file) {
        List<Mogram> mograms = roots.stream().filter(node -> node.file().equals(file)).collect(Collectors.toList());
        roots.stream().filter(root -> !mograms.contains(root)).forEach(mograms::add);
        return mograms;
    }

    private Collection<Mogram> findRoots(Mogram mogram, String[] path) {
        Collection<Mogram> roots = this.searchPossibleRoots(mogram, path[0], false);
        if (!roots.isEmpty()) {
            return roots;
        }
        for (Mogram root : this.model.components()) {
            if (!FileSystemUtils.getNameWithoutExtension(new File(root.file()).getName()).equals(path[0]) || path.length == 1) continue;
            roots = this.searchPossibleRoots(root, path[1], false);
            break;
        }
        return roots;
    }

    private Mogram resolve(String[] path, Collection<Mogram> roots) {
        if (roots.isEmpty()) {
            return null;
        }
        if (roots.size() == 1 && path.length == 1) {
            return roots.iterator().next();
        }
        for (Mogram root : roots) {
            Mogram candidate = this.resolvePathInNode(path, root);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private Mogram resolvePathInNode(String[] path, Mogram mogram) {
        Mogram reference = null;
        for (String name : path) {
            if (reference == null) {
                reference = this.areNamesake(mogram, name) ? mogram : null;
                continue;
            }
            List components = reference.component(name);
            if (components.isEmpty() && reference.parent() != null) {
                reference = (Mogram)reference.parent().component(name).get(0);
            } else {
                Mogram mogram2 = reference = components.isEmpty() ? null : (Mogram)components.get(0);
            }
            if (reference != null) continue;
            return null;
        }
        return reference;
    }

    private Collection<Mogram> searchPossibleRoots(Mogram mogram, String name, boolean parent) {
        LinkedHashSet<Mogram> set = new LinkedHashSet<Mogram>();
        this.namesake(name, set, (MogramContainer)mogram);
        this.addInContext(name, set, mogram, parent);
        this.addNodeSiblings(name, mogram, set);
        this.addRoots(name, set);
        return set;
    }

    private void addRoots(String name, Set<Mogram> set) {
        set.addAll(this.model.components().stream().filter(node -> this.areNamesake((Mogram)node, name)).collect(Collectors.toList()));
    }

    private void addNodeSiblings(String identifier, Mogram container, Set<Mogram> set) {
        if (container == null) {
            return;
        }
        set.addAll(container.components().stream().filter(node -> this.areNamesake((Mogram)node, identifier)).collect(Collectors.toList()));
    }

    private void addInContext(String name, Set<Mogram> set, Mogram mogram, boolean parent) {
        this.checkSiblings(name, set, mogram);
        for (Mogram container = mogram.container(); container != null; container = container.container()) {
            Mogram parentMogram;
            this.namesake(name, set, (MogramContainer)container);
            this.checkSiblings(name, set, container);
            if (!parent || (parentMogram = mogram.parent()) == null) continue;
            this.collectParentComponents(name, set, container, parentMogram);
        }
    }

    private void checkSiblings(String name, Set<Mogram> set, Mogram container) {
        for (Mogram sibling : container.siblings()) {
            this.namesake(name, set, (MogramContainer)sibling);
        }
    }

    private void collectParentComponents(String identifier, Set<Mogram> set, Mogram container, Mogram parent) {
        set.addAll(parent.components().stream().filter(sibling -> this.areNamesake((Mogram)sibling, identifier) && !sibling.equals((Object)container)).collect(Collectors.toList()));
    }

    private void namesake(String name, Set<Mogram> set, MogramContainer container) {
        if (container instanceof MogramImpl && this.areNamesake((Mogram)container, name)) {
            set.add((Mogram)container);
        }
    }

    private boolean areNamesake(Mogram mogram, String name) {
        return name.equals(mogram.name());
    }
}

