/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core;

import io.intino.tara.builder.SourceProvider;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.core.ProcessingUnit;
import io.intino.tara.builder.core.SourceReader;
import io.intino.tara.builder.core.errorcollection.ErrorCollector;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.parser.Parser;
import java.io.File;
import java.io.IOException;

public class SourceUnit
extends ProcessingUnit {
    private final SourceProvider.Source source;
    private Model model;
    private final SourceReader reader;
    private Parser parser;

    public SourceUnit(SourceProvider.Source source, CompilerConfiguration configuration, ErrorCollector er) {
        super(configuration, er);
        this.source = source;
        this.configuration = configuration;
        this.errorCollector = er;
        this.reader = new SourceReader(source, configuration.sourceEncoding());
    }

    public String getPath() {
        return new File(this.source.uri()).getAbsolutePath();
    }

    public Model getModel() {
        return this.model;
    }

    public void parse() throws TaraException {
        if (this.parser == null) {
            try {
                this.parser = new Parser(this.reader, this.configuration.model().language(), this.configuration.model().outDsl());
                this.parser.parse();
            }
            catch (IOException e) {
                throw new TaraException("Error opening source " + this.reader.getSource().uri(), e);
            }
        }
    }

    public void importData() throws TaraException {
        this.model = this.parser.convert();
    }

    public boolean isDirty() {
        return this.source.dirty();
    }
}

