/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.codegeneration.language;

import io.intino.itrules.Adapter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.itrules.adapters.ExcludeAdapter;
import io.intino.tara.Language;
import io.intino.tara.builder.codegeneration.TemplateTags;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramReference;
import io.intino.tara.language.model.Metric;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramContainer;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.Parametrized;
import io.intino.tara.language.model.Primitive;
import io.intino.tara.language.model.Rule;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.model.rules.variable.ReferenceRule;
import io.intino.tara.language.model.rules.variable.VariableCustomRule;
import io.intino.tara.language.semantics.Assumption;
import io.intino.tara.language.semantics.Constraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

class TerminalConstraintManager
implements TemplateTags {
    private final Language language;
    private final MogramContainer scope;

    TerminalConstraintManager(Language language, Model model) {
        this.language = language;
        this.scope = model;
    }

    TerminalConstraintManager(Language language, MogramContainer scope) {
        this.language = language;
        this.scope = scope;
    }

    private static boolean isInstance(List<Tag> annotations) {
        return annotations.contains(Tag.Instance);
    }

    void addConstraints(List<Constraint> constraints, FrameBuilderContext constraintsFrame) {
        for (Constraint c : constraints) {
            if (c instanceof Constraint.Name) {
                this.addName(constraintsFrame, "constraint");
                continue;
            }
            if (c instanceof Constraint.Component) {
                this.asComponent(constraintsFrame, (Constraint.Component)c);
                continue;
            }
            if (c instanceof Constraint.Parameter) {
                this.addParameter(constraintsFrame, (Constraint.Parameter)c);
                continue;
            }
            if (!(c instanceof Constraint.Facet)) continue;
            this.addFacet(constraintsFrame, (Constraint.Facet)c);
        }
    }

    private void asComponent(FrameBuilderContext constraintsBuilder, Constraint.Component component) {
        if (TerminalConstraintManager.isInstance(component.annotations())) {
            this.addComponent(constraintsBuilder, component);
        } else {
            ArrayList<Mogram> mograms = new ArrayList<Mogram>();
            this.findInstancesOf(component.type(), mograms);
            mograms.forEach(n -> this.addComponent(constraintsBuilder, (Mogram)n));
        }
    }

    private void addName(FrameBuilderContext constraints, String relation) {
        constraints.add(relation, (Object)"name");
    }

    private void addFacet(FrameBuilderContext constraints, Constraint.Facet facet) {
        FrameBuilder builder = new FrameBuilder(new String[]{"constraint", "facet"});
        builder.add("value", (Object)facet.type());
        if (facet.terminal()) {
            builder.add("terminal", (Object)"true");
        }
        builder.add("with", (Object)facet.with());
        this.addConstraints(facet.constraints(), (FrameBuilderContext)builder);
        constraints.add("constraint", (Object)builder.toFrame());
    }

    private void addParameter(FrameBuilderContext constraints, Constraint.Parameter constraint) {
        Object[] parameters = new Object[]{constraint.name(), constraint.type(), this.sizeOfTerminal(constraint), constraint.facet(), constraint.position(), constraint.scope(), this.ruleToFrame((Rule)constraint.rule()), constraint.flags().stream().map(Enum::name).toArray(String[]::new)};
        FrameBuilder primitiveFrameBuilder = new FrameBuilder();
        if (Primitive.REFERENCE.equals((Object)constraint.type())) {
            this.fillAllowedReferences(constraint);
            primitiveFrameBuilder.add("reference");
        }
        this.renderPrimitive(primitiveFrameBuilder, parameters, "constraint");
        constraints.add("constraint", (Object)primitiveFrameBuilder.toFrame());
    }

    private void fillAllowedReferences(Constraint.Parameter constraint) {
        if (constraint.rule() instanceof ReferenceRule) {
            this.fillAllowedReferences((ReferenceRule)constraint.rule());
        }
    }

    private void fillAllowedReferences(ReferenceRule rule) {
        if (!this.allowedValuesAreTerminal(rule.allowedReferences())) {
            rule.setAllowedReferences(Arrays.asList(this.instancesOfNonTerminalReference(rule)));
        }
    }

    private void renderPrimitive(FrameBuilder builder, Object[] parameters, String relation) {
        builder.add(relation).add("parameter");
        this.fillParameterFrame(parameters, builder);
    }

    private void fillParameterFrame(Object[] parameters, FrameBuilder builder) {
        builder.add("name", parameters[0]).add("type", parameters[1]).add("size", parameters[2]).add("facet", parameters[3]).add("position", parameters[4]).add("scope", parameters[5]);
        if (parameters[6] != null) {
            builder.add("rule", parameters[6]);
        }
        builder.add("tags", parameters[7]);
    }

    private Frame ruleToFrame(Rule rule) {
        FrameBuilder builder;
        if (rule == null) {
            return null;
        }
        FrameBuilder frameBuilder = new FrameBuilder();
        frameBuilder.put(Rule.class, (Adapter)new ExcludeAdapter(new String[]{"loadedClass"}));
        FrameBuilder frameBuilder2 = builder = rule.getClass().isEnum() ? new FrameBuilder(new String[]{"customrule", "rule"}) : frameBuilder.append((Object)rule);
        if (rule instanceof VariableCustomRule) {
            this.fillCustomRule((VariableCustomRule)rule, builder);
        } else if (rule.getClass().isEnum()) {
            this.fillInheritedCustomRule(rule, builder);
        }
        return builder.toFrame();
    }

    private String[] instancesOfNonTerminalReference(ReferenceRule rule) {
        ArrayList instances = new ArrayList();
        rule.allowedReferences().forEach(type -> this.findInstancesOf((String)type, instances));
        return instances.stream().map(Mogram::qualifiedName).collect(Collectors.toList()).toArray(new String[instances.size()]);
    }

    private void findInstancesOf(String type, List<Mogram> instances) {
        this.findInstancesOf(this.scope, type, instances);
    }

    private void findInstancesOf(MogramContainer node, String type, List<Mogram> result) {
        for (Mogram component : node.components()) {
            if (component.type().equals(type)) {
                result.add(component);
            }
            if (component instanceof MogramReference) continue;
            this.findInstancesOf((MogramContainer)component, type, result);
        }
    }

    private boolean allowedValuesAreTerminal(List<String> references) {
        for (String node : references) {
            if (this.isTerminal(node)) continue;
            return false;
        }
        return true;
    }

    private boolean isTerminal(String node) {
        if (this.language.assumptions(node) == null) {
            return false;
        }
        for (Assumption assumption : this.language.assumptions(node)) {
            if (assumption instanceof Assumption.Terminal) continue;
            return true;
        }
        return false;
    }

    private void fillCustomRule(VariableCustomRule rule, FrameBuilder builder) {
        builder.add("qn", (Object)rule.loadedClass().getName());
        if (rule.isMetric()) {
            builder.add("metric");
            builder.add("default", (Object)rule.getDefaultUnit());
        }
    }

    private void fillInheritedCustomRule(Rule rule, FrameBuilder builder) {
        builder.add("qn", (Object)rule.getClass().getName());
        if (rule instanceof Metric) {
            builder.add("metric");
            builder.add("default", (Object)((Enum)rule).name());
        }
    }

    private void addComponent(FrameBuilderContext builderContext, Constraint.Component component) {
        FrameBuilder constraintBuilder = new FrameBuilder(new String[]{"constraint", component instanceof Constraint.OneOf ? "oneOf" : "component"});
        constraintBuilder.add("type", (Object)component.type());
        Frame sizeOfTerminal = this.sizeOfTerminal(component);
        if (sizeOfTerminal == null) {
            return;
        }
        constraintBuilder.add("size", (Object)sizeOfTerminal);
        constraintBuilder.add("tags", component.annotations().stream().map(Enum::name).toArray(Object[]::new));
        if (component instanceof Constraint.OneOf) {
            ((Constraint.OneOf)component).components().forEach(c -> this.addComponent((FrameBuilderContext)constraintBuilder, (Constraint.Component)c));
        }
        builderContext.add("constraint", (Object)constraintBuilder.toFrame());
    }

    private void addComponent(FrameBuilderContext frame, Mogram component) {
        if (component.name() == null) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"constraint", "component"});
        builder.add("type", (Object)component.name());
        Size size = component.container().sizeOf(component);
        if (size.min() == 0 && size.max() == 0) {
            return;
        }
        builder.add("size", (Object)new FrameBuilder().append((Object)size).toFrame());
        builder.add("tags", component.flags().stream().filter(f -> !Tag.Required.equals(f)).map(Enum::name).toArray(Object[]::new));
        frame.add("constraint", (Object)builder.toFrame());
    }

    private Frame sizeOfTerminal(Constraint.Component constraint) {
        Size size;
        if (constraint == null) {
            return new FrameBuilder().add("value", (Object)"null").toFrame();
        }
        FrameBuilder builder = new FrameBuilder();
        Size rule = (Size)constraint.rules().stream().filter(r -> r instanceof Size).findFirst().orElse((Rule)Size.MULTIPLE());
        Size size2 = size = rule.into() != null ? this.obtainRule(constraint, rule.into()) : rule;
        if (size == null) {
            return null;
        }
        return builder.append((Object)size).toFrame();
    }

    private Size obtainRule(Constraint.Component constraint, Size rule) {
        boolean existsComponent = this.existsComponent(constraint.type());
        if (existsComponent) {
            return rule.isSingle() ? null : new Size(0, rule.max());
        }
        return rule;
    }

    private Frame sizeOfTerminal(Constraint.Parameter constraint) {
        if (constraint == null) {
            return new FrameBuilder().add("value", (Object)"null").toFrame();
        }
        boolean isFilled = this.isParameterFilled(constraint.name());
        FrameBuilder builder = new FrameBuilder();
        Size size = constraint.size();
        if (isFilled) {
            return builder.append((Object)size).toFrame();
        }
        return builder.append((Object)(size.into() != null ? size.into() : size)).toFrame();
    }

    private boolean isParameterFilled(String name) {
        if (this.scope instanceof Parametrized) {
            for (Parameter parameter : ((Parametrized)this.scope).parameters()) {
                if (!name.equals(parameter.name())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean existsComponent(String type) {
        if (this.scope instanceof Mogram) {
            for (Mogram mogram : this.scope.components()) {
                if (!type.equals(mogram.type())) continue;
                return true;
            }
        }
        return false;
    }
}

