/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder;

import io.intino.builder.CompilerMessage;
import io.intino.tara.builder.CompilationInfoExtractor;
import io.intino.tara.builder.TaraCompiler;
import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.core.SourceUnit;
import io.intino.tara.builder.core.operation.Operation;
import io.intino.tara.builder.utils.FileSystemUtils;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaraCompilerRunner {
    private final boolean verbose;
    private final List<Class<? extends Operation>> codeGenerationOperations;
    private PrintStream out = System.out;

    public TaraCompilerRunner(boolean verbose, List<Class<? extends Operation>> codeGenerationOperations) {
        this.verbose = verbose;
        this.codeGenerationOperations = codeGenerationOperations;
    }

    public TaraCompilerRunner(boolean verbose) {
        this(verbose, List.of());
    }

    public void run(File argsFile) {
        CompilerConfiguration config = new CompilerConfiguration();
        LinkedHashMap<File, Boolean> sources = new LinkedHashMap<File, Boolean>();
        CompilationInfoExtractor.getInfoFromArgsFile(argsFile, config, sources);
        config.setVerbose(this.verbose);
        config.out(System.out);
        this.out = config.out();
        if (sources.isEmpty()) {
            return;
        }
        if (this.verbose) {
            this.out.println("@#$%@# Presentable:Tarac: loading sources...");
        }
        this.runCompiler(config, sources);
    }

    public void run(CompilerConfiguration config, Map<File, Boolean> sources) {
        config.setVerbose(this.verbose);
        this.out = config.out();
        if (sources.isEmpty()) {
            return;
        }
        if (this.verbose) {
            this.out.println("@#$%@# Presentable:Tarac: loading sources...");
        }
        this.runCompiler(config, sources);
    }

    private void runCompiler(CompilerConfiguration config, Map<File, Boolean> sources) {
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>();
        List<TaraCompiler.OutputItem> compiled = this.compile(config, sources, messages);
        if (this.verbose) {
            this.report(sources, compiled);
        }
        this.processErrors(messages);
        FileSystemUtils.removeDir(config.getTempDirectory());
    }

    private List<TaraCompiler.OutputItem> compile(CompilerConfiguration config, Map<File, Boolean> sources, List<CompilerMessage> messages) {
        ArrayList<TaraCompiler.OutputItem> compiled = new ArrayList<TaraCompiler.OutputItem>();
        if (!config.isTest()) {
            compiled.addAll(this.compileSources(config, sources, messages));
        } else {
            compiled.addAll(this.compileTests(config, sources, messages));
        }
        return compiled;
    }

    private List<TaraCompiler.OutputItem> compileSources(CompilerConfiguration config, Map<File, Boolean> sources, List<CompilerMessage> messages) {
        if (this.verbose) {
            this.out.println("@#$%@# Presentable:Tarac: Compiling model...");
        }
        this.out.println();
        CompilationUnit unit = new CompilationUnit(config);
        this.addCodeGenerationOperations(unit);
        this.addSources(sources, unit);
        return new TaraCompiler(messages).compile(unit);
    }

    private void addCodeGenerationOperations(CompilationUnit unit) {
        for (Class<? extends Operation> codeGenerationOperation : this.codeGenerationOperations) {
            try {
                unit.addPhaseOperation((Operation)codeGenerationOperation.getDeclaredConstructors()[0].newInstance(unit), 8);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                Logger.getGlobal().log(Level.SEVERE, e.getMessage() == null ? e.getStackTrace()[0].toString() : e.getMessage());
            }
        }
    }

    private void report(Map<File, Boolean> srcFiles, List<TaraCompiler.OutputItem> compiled) {
        if (compiled.isEmpty()) {
            this.reportNotCompiledItems(srcFiles);
        } else {
            this.reportCompiledItems(compiled);
        }
        this.out.println();
    }

    private List<TaraCompiler.OutputItem> compileTests(CompilerConfiguration config, Map<File, Boolean> testFiles, List<CompilerMessage> compilerMessages) {
        if (testFiles.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.verbose) {
            this.out.println("@#$%@# Presentable:Tarac: compiling tests...");
        }
        this.out.println();
        CompilerConfiguration testConf = config.clone();
        testConf.setTest(true);
        testConf.workingPackage(testConf.workingPackage() + ".test");
        if (config.model().outDsl() != null) {
            testConf.language(config.model().outDsl(), config.version());
        }
        if (config.model().level() != null) {
            testConf.model().level(CompilerConfiguration.Level.values()[config.model().level().ordinal() == 0 ? 0 : config.model().level().ordinal() - 1]);
        }
        ArrayList<TaraCompiler.OutputItem> outputs = new ArrayList<TaraCompiler.OutputItem>();
        for (File file : testFiles.keySet()) {
            testConf.model().outDsl(file.getName());
            CompilationUnit unit = new CompilationUnit(testConf);
            this.addSources(Collections.singletonMap(file, true), unit);
            outputs.addAll(new TaraCompiler(compilerMessages).compile(unit));
        }
        return outputs;
    }

    private void processErrors(List<CompilerMessage> compilerMessages) {
        int errorCount = 0;
        for (CompilerMessage message : compilerMessages) {
            if (message.category().equals("error")) {
                if (errorCount > 100) continue;
                ++errorCount;
            }
            this.printMessage(message);
        }
    }

    private void addSources(Map<File, Boolean> srcFiles, CompilationUnit unit) {
        srcFiles.forEach((key, value) -> unit.addSource(new SourceUnit((File)key, unit.configuration(), unit.getErrorCollector(), (boolean)value)));
    }

    private void printMessage(CompilerMessage message) {
        this.out.print("%%m");
        this.out.print(message.category());
        this.out.print("#%%#%%%#%%%%%%%%%#");
        this.out.print(message.message());
        this.out.print("#%%#%%%#%%%%%%%%%#");
        this.out.print(message.url());
        this.out.print("#%%#%%%#%%%%%%%%%#");
        this.out.print(message.lineNum());
        this.out.print("#%%#%%%#%%%%%%%%%#");
        this.out.print(message.columnNum());
        this.out.print("#%%#%%%#%%%%%%%%%#");
        this.out.print("/%m");
        this.out.println();
    }

    private void reportCompiledItems(List<TaraCompiler.OutputItem> compiledFiles) {
        for (TaraCompiler.OutputItem compiledFile : compiledFiles) {
            this.out.print("%%c");
            this.out.print(compiledFile.getOutputPath());
            this.out.print("#%%#%%%#%%%%%%%%%#");
            this.out.print(compiledFile.getSourceFile());
            this.out.print("/%c");
            this.out.println();
        }
    }

    private void reportNotCompiledItems(Map<File, Boolean> toRecompile) {
        for (File file : toRecompile.keySet()) {
            this.out.print("%%rc");
            this.out.print(file.getAbsolutePath());
            this.out.print("/%rc");
            this.out.println();
        }
    }
}

