/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.model;

import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramReference;
import io.intino.tara.builder.model.ParameterImpl;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.language.model.Facet;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.Rule;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class MogramImpl
implements Mogram {
    private String file;
    private int line;
    private Mogram container;
    private String type;
    private String doc;
    private boolean sub;
    private String name;
    private String parentName;
    private Mogram parent;
    private boolean anonymous = true;
    private boolean dirty;
    private boolean virtual;
    private String hashCode;
    private String language;
    private String uid;
    private final String text;
    private final List<String> uses = new ArrayList<String>();
    private final Map<Mogram, List<Rule>> components = new LinkedHashMap<Mogram, List<Rule>>();
    private final List<Tag> flags = new ArrayList<Tag>();
    private final List<Tag> annotations = new ArrayList<Tag>();
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final List<Variable> variables = new ArrayList<Variable>();
    private final List<Facet> facets = new ArrayList<Facet>();
    private final List<Mogram> children = new ArrayList<Mogram>();
    private List<FacetConstraint> facetConstraints;
    private List<String> context = new ArrayList<String>();

    public MogramImpl(String text) {
        this.text = text;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
        this.anonymous = false;
    }

    public String file() {
        return this.file;
    }

    public void file(String file) {
        this.file = file;
    }

    public String languageName() {
        return this.language;
    }

    public void languageName(String language) {
        this.language = language;
    }

    public int line() {
        return this.line;
    }

    public void line(int line) {
        this.line = line;
    }

    public String doc() {
        return this.doc;
    }

    public void doc(String doc) {
        this.doc = this.doc == null ? doc : this.doc + "\\n" + doc.trim();
    }

    public boolean isSub() {
        return this.sub;
    }

    public void setSub(boolean sub) {
        this.sub = sub;
    }

    public List<Mogram> subs() {
        ArrayList mograms = new ArrayList();
        this.children().stream().filter(Mogram::isSub).forEach(c -> {
            mograms.add(c);
            mograms.addAll(c.subs());
        });
        return Collections.unmodifiableList(mograms);
    }

    public Mogram container() {
        return this.container;
    }

    public List<String> uses() {
        return this.uses;
    }

    public void container(Mogram container) {
        this.container = container;
    }

    public boolean isTerminal() {
        return this.flags.contains(Tag.Terminal);
    }

    public boolean isAbstract() {
        return this.flags.contains(Tag.Abstract) || this.children().stream().anyMatch(Mogram::isSub);
    }

    public boolean isFacet() {
        return "Facet".equals(this.type()) || this.is(Tag.Facet);
    }

    public boolean isMetaFacet() {
        return "MetaFacet".equals(this.type());
    }

    public void facetConstraints(List<String> constraints) {
        this.facetConstraints = constraints.stream().map(FacetConstraint::new).collect(Collectors.toList());
    }

    public boolean is(Tag tag) {
        return this.flags.contains(tag);
    }

    public boolean into(Tag tag) {
        return this.annotations.contains(tag);
    }

    public List<Tag> annotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public List<Tag> flags() {
        return Collections.unmodifiableList(this.flags);
    }

    public void addAnnotations(Tag ... annotations) {
        Collections.addAll(this.annotations, annotations);
    }

    public void addFlags(Tag ... flags) {
        Collections.addAll(this.flags, flags);
    }

    public void addUses(List<String> imports) {
        this.uses.addAll(imports);
    }

    public Mogram parent() {
        return this.parent;
    }

    public void setParent(Mogram parent) {
        this.parent = parent;
    }

    public String parentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public MogramImpl isAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
        return this;
    }

    public String qualifiedName() {
        String containerQN = this.container.qualifiedName();
        String name = this.is(Tag.Instance) || this.isAnonymous() ? this.name() : Format.firstUpperCase().format((Object)this.name()).toString();
        return (String)(containerQN.isEmpty() ? "" : containerQN + ".") + (String)(name == null ? "[anonymous@" + this.shortType() + "]" : name);
    }

    public String layerQualifiedName() {
        String containerQn = this.container instanceof Model ? "" : ((MogramImpl)this.container).layerQualifiedName();
        String name = this.is(Tag.Instance) || this.isAnonymous() ? this.name() : Format.firstUpperCase().format((Object)this.name()).toString();
        return (String)(containerQn.isEmpty() ? "" : containerQn + "$") + (name == null ? this.newUUID() : name);
    }

    public String layerQn() {
        Object name;
        String containerQn = this.container instanceof Model ? "" : ((MogramImpl)this.container).layerQn();
        Object object = name = this.is(Tag.Instance) || this.isAnonymous() ? this.name() : Format.firstUpperCase().format((Object)this.name()).toString();
        if (name != null && this.is(Tag.Decorable)) {
            name = "Abstract" + (String)name;
        }
        return (String)(containerQn.isEmpty() ? "" : containerQn + "$") + (String)(name == null ? this.newUUID() : name);
    }

    private String shortType() {
        return this.type.contains(".") ? this.type.substring(this.type.lastIndexOf(".") + 1) : this.type;
    }

    public String type() {
        return this.type;
    }

    public List<String> types() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(this.type());
        types.addAll(this.secondaryTypes());
        return Collections.unmodifiableList(types);
    }

    public List<String> secondaryTypes() {
        Set types = this.appliedFacets().stream().map(Facet::type).collect(Collectors.toSet());
        if (this.parent != null) {
            types.addAll(this.parent.types());
        }
        return List.copyOf(types);
    }

    public void type(String type) {
        this.type = type;
    }

    public void stashNodeName(String name) {
    }

    public List<String> metaTypes() {
        return this.context;
    }

    public void metaTypes(List<String> context) {
        this.context = new ArrayList<String>(context);
    }

    public Mogram resolve() {
        return this;
    }

    public boolean isReference() {
        return false;
    }

    public List<Parameter> parameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public void addParameter(String name, String facet, int position, String extension, int line, int column, List<Object> values) {
        ParameterImpl parameter = new ParameterImpl(name, position, extension, values);
        parameter.facet(facet);
        parameter.file(this.file);
        parameter.line(line);
        parameter.column(column);
        parameter.owner(this);
        this.parameters.add(parameter);
    }

    public void add(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public List<Mogram> siblings() {
        ArrayList siblings = new ArrayList(this.container().components());
        siblings.remove(this);
        return Collections.unmodifiableList(siblings);
    }

    public List<Mogram> components() {
        return Collections.unmodifiableList(new ArrayList<Mogram>(this.components.keySet()));
    }

    public void add(Mogram mogram, List<Rule> rules) {
        this.components.put(mogram, rules == null ? new ArrayList() : new ArrayList<Rule>(rules));
    }

    public List<Rule> rulesOf(Mogram component) {
        return this.components.get(component);
    }

    public boolean contains(Mogram mogramContainer) {
        return mogramContainer != null && this.components.containsKey(mogramContainer);
    }

    public void remove(Mogram mogram) {
        if (mogram != null) {
            this.components.remove(mogram);
        }
    }

    public List<Variable> variables() {
        return Collections.unmodifiableList(this.variables);
    }

    public void add(Variable ... variables) {
        Collections.addAll(this.variables, variables);
    }

    public void add(int pos, Variable ... variables) {
        this.variables.addAll(pos, Arrays.asList(variables));
    }

    public List<Mogram> referenceComponents() {
        return this.components.keySet().stream().filter(include -> include instanceof MogramReference).map(include -> (MogramReference)include).collect(Collectors.toUnmodifiableList());
    }

    public Mogram targetOfReference() {
        return this;
    }

    public List<Mogram> children() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(Mogram mogram) {
        this.children.add(mogram);
    }

    public List<Facet> appliedFacets() {
        return Collections.unmodifiableList(this.facets);
    }

    public void applyFacets(Facet ... facets) {
        Collections.addAll(this.facets, facets);
    }

    public String toString() {
        return this.type + " " + this.qualifiedName();
    }

    public String text() {
        return this.text;
    }

    private String newUUID() {
        if (this.uid == null) {
            this.uid = UUID.randomUUID().toString();
        }
        return this.is(Tag.Instance) ? this.uid : Format.firstUpperCase().format((Object)this.uid).toString();
    }

    public void absorb(MogramImpl node) {
        this.components.putAll(node.components);
        this.variables.addAll(node.variables);
        this.children.addAll(node.children);
        for (Mogram child : node.children) {
            ((MogramImpl)child).setParent(this);
        }
        this.annotations.addAll(node.annotations);
        this.flags.addAll(node.flags.stream().filter(t -> !t.equals((Object)Tag.Abstract)).collect(Collectors.toList()));
        this.facets.addAll(node.facets);
        this.flags.remove(Tag.Abstract);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    public String getHashCode() {
        return this.hashCode;
    }

    private static class FacetConstraint
    implements Mogram.FacetConstraint,
    Cloneable {
        private Mogram mogram;
        private boolean negated = false;
        private String name;

        FacetConstraint(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public Mogram node() {
            return this.mogram;
        }

        public void node(Mogram mogram) {
            this.mogram = mogram;
        }

        public FacetConstraint clone() throws CloneNotSupportedException {
            return (FacetConstraint)super.clone();
        }

        public String toString() {
            return "with " + this.node().qualifiedName();
        }
    }
}

