/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.codegeneration.language;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.tara.Language;
import io.intino.tara.builder.codegeneration.TemplateTags;
import io.intino.tara.builder.codegeneration.language.TerminalConstraintManager;
import io.intino.tara.builder.model.Model;
import io.intino.tara.language.semantics.Assumption;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.Context;
import java.util.List;

class LanguageInheritanceManager
implements TemplateTags {
    private final FrameBuilderContext root;
    private final List<String> instanceConstraints;
    private final Language language;
    private final TerminalConstraintManager manager;

    LanguageInheritanceManager(FrameBuilderContext root, List<String> instanceConstraints, Language language, Model model) {
        this.root = root;
        this.instanceConstraints = instanceConstraints;
        this.language = language;
        this.manager = new TerminalConstraintManager(language, model);
    }

    void fill() {
        if (this.instanceConstraints == null || this.root == null) {
            return;
        }
        for (String instance : this.instanceConstraints) {
            FrameBuilder nodeFrame = new FrameBuilder(new String[]{"node"});
            this.fillRuleInfo(nodeFrame, instance);
            this.addConstraints(nodeFrame, this.language.constraints(instance));
            this.addAssumptions(nodeFrame, this.language.assumptions(instance));
            this.root.add("node", (Object)nodeFrame.toFrame());
        }
    }

    private void addConstraints(FrameBuilder builder, List<Constraint> constraints) {
        FrameBuilder constraintsBuilder = new FrameBuilder(new String[]{"constraints"});
        this.manager.addConstraints(constraints, (FrameBuilderContext)constraintsBuilder);
        builder.add("constraints", (Object)constraintsBuilder.toFrame());
    }

    private void fillRuleInfo(FrameBuilder frame, String instance) {
        Context rules = (Context)this.language.catalog().get(instance);
        frame.add("name", (Object)instance);
        this.addTypes(rules.types(), frame);
    }

    private void addTypes(String[] types, FrameBuilder frame) {
        if (types == null) {
            return;
        }
        FrameBuilder typesBuilder = new FrameBuilder(new String[]{"nodeType"});
        for (String type : types) {
            typesBuilder.add("type", (Object)type);
        }
        if (typesBuilder.slots() != 0) {
            frame.add("nodeType", (Object)typesBuilder.toFrame());
        }
    }

    private void addAssumptions(FrameBuilder frame, List<Assumption> assumptions) {
        FrameBuilder builder = new FrameBuilder(new String[]{"assumptions"});
        for (Assumption assumption : assumptions) {
            builder.add("assumption", this.getAssumptionValue(assumption));
        }
        if (builder.slots() != 0) {
            frame.add("assumptions", (Object)builder.toFrame());
        }
    }

    private Object getAssumptionValue(Assumption assumption) {
        String name = assumption.getClass().getInterfaces()[0].getName().substring(assumption.getClass().getInterfaces()[0].getName().lastIndexOf("$") + 1);
        if (assumption instanceof Assumption.StashNodeName) {
            return new FrameBuilder().add("stashNodeName").add("value", (Object)((Assumption.StashNodeName)assumption).stashNodeName());
        }
        return name;
    }
}

