/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder;

import io.intino.builder.BuildConstants;
import io.intino.tara.builder.core.CompilerConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class CompilationInfoExtractor {
    private static final Logger LOG = Logger.getGlobal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getInfoFromArgsFile(File argsFile, CompilerConfiguration configuration, Map<File, Boolean> srcFiles) {
        BufferedReader reader = null;
        configuration.setWarningLevel(3);
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(argsFile)));
            CompilationInfoExtractor.processArgs(configuration, reader, CompilationInfoExtractor.readSrc(srcFiles, reader));
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error getting Args IO: " + e.getMessage(), e);
        }
        finally {
            try {
                assert (reader != null);
                reader.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Error getting Args IO2: " + e.getMessage(), e);
            }
        }
    }

    private static String readSrc(Map<File, Boolean> srcFiles, BufferedReader reader) throws IOException {
        String line;
        while (!"".equals(line = reader.readLine())) {
            if ("def.file".equals(line)) continue;
            String[] split = line.split("#");
            File file = new File(split[0]);
            srcFiles.put(file, Boolean.valueOf(split[1]));
        }
        return line;
    }

    private static void processArgs(CompilerConfiguration configuration, BufferedReader reader, String line) throws IOException {
        String aLine = line;
        while (aLine != null) {
            CompilationInfoExtractor.processLine(configuration, reader, aLine);
            aLine = reader.readLine();
        }
    }

    private static void processLine(CompilerConfiguration configuration, BufferedReader reader, String aLine) throws IOException {
        switch (aLine) {
            case "encoding": {
                configuration.sourceEncoding(reader.readLine());
                break;
            }
            case "outputpath": {
                configuration.setOutDirectory(new File(reader.readLine()));
                break;
            }
            case "project": {
                configuration.setProject(reader.readLine());
                break;
            }
            case "res.path": {
                configuration.setResourcesDirectory(new File(reader.readLine()));
                break;
            }
            case "module": {
                configuration.setModule(reader.readLine());
                break;
            }
            case "level": {
                configuration.model().level(CompilerConfiguration.Level.valueOf(reader.readLine()));
                break;
            }
            case "excluded_phases": {
                configuration.setExcludedPhases(CompilationInfoExtractor.parseToInt(reader.readLine().split(" ")));
                break;
            }
            case "out.dsl": {
                configuration.model().outDsl(reader.readLine());
                break;
            }
            case "compilation.mode": {
                configuration.mode(BuildConstants.Mode.valueOf((String)reader.readLine()));
                break;
            }
            case "groupId": {
                configuration.groupId(reader.readLine());
                break;
            }
            case "artifactId": {
                configuration.artifactId(reader.readLine());
                break;
            }
            case "version": {
                configuration.version(reader.readLine());
                break;
            }
            case "out.dsl.builder.groupId": {
                configuration.dslBuilder().setGroupId(reader.readLine());
                break;
            }
            case "out.dsl.builder.artifactId": {
                configuration.dslBuilder().setArtifactId(reader.readLine());
                break;
            }
            case "out.dsl.builder.version": {
                configuration.dslBuilder().setVersion(reader.readLine());
                break;
            }
            case "out.dsl.runtime.groupId": {
                configuration.runtime().setGroupId(reader.readLine());
                break;
            }
            case "out.dsl.runtime.artifactId": {
                configuration.runtime().setArtifactId(reader.readLine());
                break;
            }
            case "out.dsl.runtime.version": {
                configuration.runtime().setVersion(reader.readLine());
                break;
            }
            case "test.module": {
                configuration.setTest(Boolean.parseBoolean(reader.readLine()));
                break;
            }
            case "intino.project.path": {
                configuration.setWorkspaceDirectory(new File(reader.readLine()));
                break;
            }
            case "generation.package": {
                configuration.workingPackage(reader.readLine());
                break;
            }
            case "src.path": {
                CompilationInfoExtractor.readSrcPaths(configuration.sourceDirectories(), reader);
                break;
            }
            case "repository": {
                configuration.languagesRepository(new File(reader.readLine()));
                break;
            }
            case "dsl": {
                String[] dsl = reader.readLine().trim().split(":");
                configuration.language(dsl[0], dsl[1]);
                break;
            }
        }
    }

    private static void readSrcPaths(List<File> srcPaths, BufferedReader reader) throws IOException {
        String line;
        while (!"".equals(line = reader.readLine())) {
            srcPaths.add(new File(line));
        }
    }

    static List<Integer> parseToInt(String[] phases) {
        return Arrays.stream(phases).map(Integer::parseInt).collect(Collectors.toList());
    }
}

