package io.intino.tara.builder.model;

import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Primitive;
import io.intino.tara.language.model.Variable;

public class VariableReference extends VariableImpl {
	private Mogram target;
	private final String targetName;
	private boolean typeReference = false;

	public VariableReference(Mogram container, String type, String name, String scope) {
		super(container, Primitive.REFERENCE, name, scope);
		this.targetName = type;
	}

	public Mogram getTarget() {
		return target;
	}

	public String targetName() {
		return targetName;
	}

	public void setTarget(Mogram target) {
		this.target = target;
	}

	public boolean isTypeReference() {
		return typeReference;
	}

	public void setTypeReference() {
		this.typeReference = true;
	}

	@Override
	public Mogram targetOfReference() {
		return getTarget();
	}

	@Override
	public boolean isReference() {
		return true;
	}

	@Override
	public Variable cloneIt(Mogram container) {
		VariableReference variable = new VariableReference(container, targetName(), name(), scope());
		variable.size(this.size());
		variable.defaultMetric(defaultMetric());
		variable.rule(rule());
		flags().forEach(variable::addFlags);
		variable.values(this.values());
		variable.setTarget(target);
		variable.setInherited(true);
		variable.file(file());
		variable.line(line());
		variable.column(column());
		return variable;
	}
}
