package io.intino.tara.builder.model;

import io.intino.tara.Language;
import io.intino.tara.builder.core.CompilerConfiguration.Level;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramRoot;
import io.intino.tara.language.model.Rule;

import java.io.File;
import java.util.*;


public class Model implements MogramRoot {
	private String file;
	private Language language;
	private Level level;
	private List<String> uses;
	private File resourcesRoot;
	private List<Mogram> facets;
	private final Map<Mogram, List<Rule>> components = new LinkedHashMap<>();
	private final Map<String, File> rules = new HashMap<>();

	public Model(String file) {
		this.file = file;
	}

	@Override
	public String file() {
		return file;
	}

	@Override
	public void file(String file) {
		this.file = file;
	}

	@Override
	public List<String> uses() {
		return uses;
	}

	public Level level() {
		return level;
	}

	public void level(Level level) {
		this.level = level;
	}

	@Override
	public boolean contains(Mogram mogramContainer) {
		return components.containsKey(mogramContainer);
	}

	@Override
	public void remove(Mogram mogram) {
		if (mogram != null) components.remove(mogram);
	}

	@Override
	public String doc() {
		return "";
	}

	@Override
	public List<Mogram> components() {
		return Collections.unmodifiableList(new ArrayList<>(components.keySet()));
	}

	@Override
	public String type() {
		return "";
	}

	@Override
	public void add(Mogram mogram, List<Rule> rule) {
		this.components.put(mogram, new ArrayList<>(rule));
	}

	@Override
	public List<Rule> rulesOf(Mogram component) {
		return this.components.get(component);
	}

	public Language language() {
		return language;
	}

	public void setLanguage(Language language) {
		this.language = language;
	}

	@Override
	public String languageName() {
		return language != null ? language.languageName() : "";
	}

	public List<Mogram> allFacets() {
		if (this.facets == null) collectFacets();
		return facets;
	}

	private void collectFacets() {
		this.facets = new ArrayList<>();
		for (Mogram mogram : components.keySet()) {
			if (mogram.isFacet()) facets.add(mogram);
			facets(mogram);
		}
	}

	private List<Mogram> facets(Mogram mogram) {
		List<Mogram> list = new ArrayList<>();
		mogram.components().forEach(n -> {
			if (n.isReference()) return;
			if (n.isFacet()) list.add(n);
			list.addAll(facets(n));
		});
		return list;
	}

	public void setUses(List<String> uses) {
		this.uses = uses;
	}

	public void addRule(String name, File rule) {
		this.rules.put(name, rule);
	}

	public Map<String, File> rules() {
		return rules;
	}

	public void setResourcesRoot(File resourceRoot) {
		this.resourcesRoot = resourceRoot;
	}

	public File resourcesRoot() {
		return resourcesRoot;
	}

	@Override
	public boolean isMetaFacet() {
		return false;
	}

	@Override
	public void stashNodeName(String name) {

	}
}
