package io.intino.tara.builder.dependencyresolution;

import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramReference;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Tag;

import static io.intino.tara.builder.core.CompilerConfiguration.Level.MetaModel;


public class TerminalResolver {

	private final Model model;
	private final CompilerConfiguration.Level level;

	public TerminalResolver(Model model, CompilerConfiguration.Level level) {
		this.model = model;
		this.level = level;
	}

	public void resolve() {
		resolveTerminals(model);
	}

	private void resolveTerminals(Mogram mogram) {
		for (Mogram component : mogram.components()) {
			if (component instanceof MogramReference) continue;
			if (component.isTerminal()) propagateTerminalToInside(component);
			else if (MetaModel.compareLevelWith(level) > 0) resolveTerminals(component);
			else if (level.equals(MetaModel)) {
				component.addFlags(Tag.Terminal);
				propagateTerminalToInside(component);
			}
		}
	}

	private void propagateTerminalToInside(Mogram mogram) {
		for (Mogram component : mogram.components()) {
			if (component instanceof MogramReference) continue;
			if (!component.isTerminal()) component.addFlags(Tag.Terminal);
			propagateTerminalToInside(component);
		}
		propagateTerminalToVariables(mogram);
	}

	private void propagateTerminalToVariables(Mogram mogram) {
		mogram.variables().stream().
				filter(variable -> !variable.isTerminal()).
				forEach(variable -> variable.addFlags(Tag.Terminal));
	}
}
