package io.intino.tara.builder.dependencyresolution;

import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramReference;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Tag;

public class InstanceMarker {
	private final Model model;

	public InstanceMarker(Model model) {
		this.model = model;
	}


	public void all() {
		asInstance(model);
	}

	private void asInstance(Mogram mogram) {
		for (Mogram component : mogram.components()) {
			if (component instanceof MogramReference) continue;
			if (!component.is(Tag.Instance)) component.addFlags(Tag.Instance);
			asInstance(component);
		}
	}
}
