package io.intino.tara.builder.core.operation.model;

import io.intino.tara.builder.codegeneration.language.LanguageSerializer;
import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.CompilerConfiguration.Level;
import io.intino.tara.builder.core.Phases;
import io.intino.tara.builder.core.errorcollection.CompilationFailedException;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.model.Model;

import java.util.Collection;
import java.util.logging.Logger;

import static io.intino.builder.BuildConstants.PRESENTABLE_MESSAGE;
import static java.util.logging.Level.SEVERE;

public class GenerateLanguageOperation extends ModelCollectionOperation {
	private static final Logger LOG = Logger.getGlobal();

	public GenerateLanguageOperation(CompilationUnit unit) {
		super(unit);
	}

	@Override
	public void call(Collection<Model> models) {
		try {
			if (models.isEmpty() || compilationUnit.configuration().model().level().equals(Level.Model)) return;
			if (compilationUnit.configuration().isVerbose())
				compilationUnit.configuration().out().println(PRESENTABLE_MESSAGE + "[" + compilationUnit.configuration().getModule() + " - " + compilationUnit.configuration().model().outDsl() + "] Generating language...");
			new LanguageSerializer(compilationUnit.configuration(), models).serialize();
			compilationUnit.getErrorCollector().failIfErrors();
		} catch (TaraException e) {
			LOG.log(SEVERE, "Error during language generation: " + e.getMessage() + "\n", e);
			throw new CompilationFailedException(Phases.LANGUAGE_GENERATION, compilationUnit, e);
		}
	}
}