package io.intino.tara.builder.core;

import io.intino.tara.builder.core.CompilerConfiguration.Level;
import io.intino.tara.builder.core.operation.model.ModelOperation;
import io.intino.tara.builder.dependencyresolution.InstanceMarker;
import io.intino.tara.builder.model.Model;

class ModelResolutionOperation extends ModelOperation {

	public ModelResolutionOperation(CompilationUnit unit) {
		super(unit);
	}

	@Override
	public void call(Model model) {
		if (model.level() == Level.Model) new InstanceMarker(model).all();
	}
}
