package io.intino.tara.builder;

import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.core.CompilerConfiguration.Level;
import io.intino.tara.builder.core.errorcollection.message.WarningMessage;

import java.io.*;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

import static io.intino.builder.BuildConstants.*;

public class CompilationInfoExtractor {
	private static final Logger LOG = Logger.getGlobal();

	public static void getInfoFromArgsFile(File argsFile, CompilerConfiguration configuration, Map<File, Boolean> srcFiles) {
		BufferedReader reader = null;
		configuration.setWarningLevel(WarningMessage.PARANOIA);
		try {
			reader = new BufferedReader(new InputStreamReader(new FileInputStream(argsFile)));
			processArgs(configuration, reader, readSrc(srcFiles, reader));
		} catch (IOException e) {
			LOG.log(java.util.logging.Level.SEVERE, "Error getting Args IO: " + e.getMessage(), e);
		} finally {
			try {
				assert reader != null;
				reader.close();
			} catch (IOException e) {
				LOG.log(java.util.logging.Level.SEVERE, "Error getting Args IO2: " + e.getMessage(), e);
			}
		}
	}

	private static String readSrc(Map<File, Boolean> srcFiles, BufferedReader reader) throws IOException {
		String line;
		while (!"".equals(line = reader.readLine())) {
			if (SRC_FILE.equals(line)) continue;
			final String[] split = line.split("#");
			final File file = new File(split[0]);
			srcFiles.put(file, Boolean.valueOf(split[1]));
		}
		return line;
	}

	private static void processArgs(CompilerConfiguration configuration, BufferedReader reader, String line) throws IOException {
		String aLine = line;
		while (aLine != null) {
			processLine(configuration, reader, aLine);
			aLine = reader.readLine();
		}
	}

	private static void processLine(CompilerConfiguration configuration, BufferedReader reader, String aLine) throws IOException {
		switch (aLine) {
			case ENCODING -> configuration.sourceEncoding(reader.readLine());
			case OUTPUTPATH -> configuration.setOutDirectory(new File(reader.readLine()));
			case PROJECT -> configuration.setProject(reader.readLine());
			case RES_PATH -> configuration.setResourcesDirectory(new File(reader.readLine()));
			case MODULE -> configuration.setModule(reader.readLine());
			case LEVEL -> configuration.model().level(Level.valueOf(reader.readLine()));
			case EXCLUDED_PHASES -> configuration.setExcludedPhases(parseToInt(reader.readLine().split(" ")));
			case OUT_DSL -> configuration.model().outDsl(reader.readLine());
			case GROUP_ID -> configuration.groupId(reader.readLine());
			case ARTIFACT_ID -> configuration.artifactId(reader.readLine());
			case VERSION -> configuration.version(reader.readLine());
			case OUT_DSL + "." + BUILDER_GROUP_ID -> configuration.dslBuilder().setGroupId(reader.readLine());
			case OUT_DSL + "." + BUILDER_ARTIFACT_ID -> configuration.dslBuilder().setArtifactId(reader.readLine());
			case OUT_DSL + "." + BUILDER_VERSION -> configuration.dslBuilder().setVersion(reader.readLine());
			case OUT_DSL + "." + RUNTIME_GROUP_ID -> configuration.runtime().setGroupId(reader.readLine());
			case OUT_DSL + "." + RUNTIME_ARTIFACT_ID -> configuration.runtime().setArtifactId(reader.readLine());
			case OUT_DSL + "." + RUNTIME_VERSION -> configuration.runtime().setVersion(reader.readLine());
			case TEST -> configuration.setTest(Boolean.parseBoolean(reader.readLine()));
			case INTINO_PROJECT_PATH -> configuration.setWorkspaceDirectory(new File(reader.readLine()));
			case GENERATION_PACKAGE -> configuration.workingPackage(reader.readLine());
			case SRC_PATH -> readSrcPaths(configuration.sourceDirectories(), reader);
			case REPOSITORY -> configuration.languagesRepository(new File(reader.readLine()));
			case DSL -> {
				final String[] dsl = reader.readLine().trim().split(":");
				configuration.language(dsl[0], dsl[1]);
			}
			default -> {
			}
		}
	}

	private static void readSrcPaths(List<File> srcPaths, BufferedReader reader) throws IOException {
		String line;
		while (!"".equals(line = reader.readLine())) srcPaths.add(new File(line));
	}

	static List<Integer> parseToInt(String[] phases) {
		return Arrays.stream(phases)
				.map(Integer::parseInt)
				.collect(Collectors.toList());
	}
}
