/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.dependencyresolution;

import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.core.errorcollection.DependencyException;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.builder.model.MogramReference;
import io.intino.tara.language.model.Element;
import io.intino.tara.language.model.Facet;
import io.intino.tara.language.model.Flags;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramContainer;
import io.intino.tara.language.model.Rule;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.model.rules.composition.MogramCustomRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class InheritanceResolver {
    private final Model model;

    public InheritanceResolver(Model model) {
        this.model = model;
    }

    public void resolve() throws DependencyException {
        this.mergeFragmentNodes();
        ArrayList<Mogram> mograms = new ArrayList<Mogram>(this.collectNodes(this.model, node -> !node.children().isEmpty()));
        this.sort(mograms);
        for (Mogram mogram : mograms) {
            this.resolve(mogram);
        }
    }

    private void resolve(Mogram mogram) throws DependencyException {
        List<Mogram> children = this.getChildrenSorted(mogram);
        if (!(mogram.isAbstract() || mogram.subs().isEmpty() || mogram.flags().contains(Tag.Abstract))) {
            mogram.addFlags(new Tag[]{Tag.Abstract});
        }
        for (Mogram child : children) {
            this.resolve(mogram, child);
        }
    }

    private void resolve(Mogram mogram, Mogram child) throws DependencyException {
        this.resolveComponents(mogram, child);
        this.resolveVariables(mogram, child);
        this.resolveFlags(mogram, child);
        this.resolveAnnotations(mogram, child);
        this.resolveAllowedFacets(mogram, child);
        this.resolveAppliedFacets(mogram, child);
        this.resolveNodeRules(mogram, child);
        this.resolve(child);
    }

    private void mergeFragmentNodes() throws DependencyException {
        if (this.model.level() == CompilerConfiguration.Level.Model) {
            return;
        }
        for (List<Mogram> mograms : this.fragmentNodes().values()) {
            this.merge(mograms);
        }
    }

    private void merge(List<Mogram> mograms) throws DependencyException {
        if (mograms.size() <= 1) {
            return;
        }
        if (!this.correctParent(mograms)) {
            throw new DependencyException("Error merging extension elements. Parents are not homogeneous.", (Element)mograms.get(0), new String[0]);
        }
        Mogram destination = mograms.get(0);
        if (destination == null) {
            return;
        }
        mograms.remove(destination);
        for (Mogram mogram : mograms) {
            ((MogramImpl)destination).absorb((MogramImpl)mogram);
            this.model.remove(mogram);
        }
    }

    private boolean correctParent(List<Mogram> mograms) {
        String parent = mograms.get(0).parentName() == null ? "" : mograms.get(0).parentName();
        for (Mogram mogram : mograms) {
            if (parent.equals(mogram.parentName() == null ? "" : mogram.parentName())) continue;
            return false;
        }
        return true;
    }

    private Map<String, List<Mogram>> fragmentNodes() {
        LinkedHashMap<String, List<Mogram>> toMerge = new LinkedHashMap<String, List<Mogram>>();
        for (Mogram mogram : this.model.components()) {
            if (mogram.isAnonymous()) continue;
            if (!toMerge.containsKey(this.name(mogram))) {
                toMerge.put(this.name(mogram), new ArrayList());
            }
            ((List)toMerge.get(this.name(mogram))).add(mogram);
        }
        return toMerge;
    }

    private String name(Mogram mogram) {
        return mogram.name() + (mogram.isFacet() ? "Facet" : "");
    }

    private void resolveNodeRules(Mogram parent, Mogram child) {
        List parentRules = parent.container().rulesOf(parent);
        List childRules = child.container().rulesOf(child);
        Size size = child.container().sizeOf(child);
        for (Rule rule : parentRules) {
            if (!(rule instanceof Size)) {
                if (this.alreadyAdded(childRules, rule)) continue;
                childRules.add(rule);
                continue;
            }
            if (!this.isMoreRestrictiveThan((Size)rule, size)) continue;
            childRules.remove(size);
            childRules.add(rule);
        }
    }

    private boolean alreadyAdded(List<Rule> childRules, Rule<?> rule) {
        if (rule instanceof MogramCustomRule) {
            MogramCustomRule nr = (MogramCustomRule)rule;
            return childRules.stream().filter(r -> r instanceof MogramCustomRule).anyMatch(r -> ((MogramCustomRule)r).externalClass().equals(nr.externalClass()));
        }
        return false;
    }

    private boolean isMoreRestrictiveThan(Size parent, Size child) {
        return parent.min() > child.min() || parent.max() < child.max();
    }

    private void resolveAllowedFacets(Mogram parent, Mogram child) {
    }

    private void resolveAppliedFacets(Mogram parent, Mogram child) {
        parent.appliedFacets().stream().filter(facet -> !this.isOverridden(child, (Facet)facet)).forEach(xva$0 -> child.applyFacets(new Facet[]{xva$0}));
    }

    private boolean isOverridden(Mogram child, Facet facet) {
        for (Facet childFacet : child.appliedFacets()) {
            if (!childFacet.type().equals(facet.type())) continue;
            return true;
        }
        return false;
    }

    private Collection<Mogram> collectNodes(Model model, Predicate<Mogram> condition) {
        HashSet<Mogram> collection = new HashSet<Mogram>();
        for (Mogram mogram : model.components()) {
            if (condition.test(mogram)) {
                collection.add(mogram);
            }
            this.collect(mogram, collection, condition);
        }
        return collection;
    }

    private void collect(Mogram mogram, Set<Mogram> collection, Predicate<Mogram> condition) {
        if (!(mogram instanceof MogramImpl)) {
            return;
        }
        if (condition.test(mogram)) {
            collection.add(mogram);
        }
        for (Mogram component : mogram.components()) {
            this.collect(component, collection, condition);
        }
    }

    private void resolveComponents(Mogram parent, Mogram child) {
        LinkedHashMap<MogramReference, List> nodes = new LinkedHashMap<MogramReference, List>();
        for (Mogram mogram : parent.components()) {
            if (this.isOverridden((MogramContainer)child, mogram)) continue;
            MogramReference reference = mogram.isReference() ? new MogramReference(((MogramReference)mogram).destination()) : new MogramReference((MogramImpl)mogram);
            this.addTags(mogram, reference);
            reference.setHas(false);
            reference.file(child.file());
            reference.line(child.line());
            reference.container(child);
            nodes.put(reference, mogram.container().rulesOf(mogram));
        }
        for (Map.Entry entry : nodes.entrySet()) {
            child.add((Mogram)entry.getKey(), (List)entry.getValue());
        }
    }

    private void addTags(Mogram component, MogramReference reference) {
        component.flags().stream().filter(tag -> !reference.flags().contains(tag) && Flags.forReference().contains(tag)).forEach(xva$0 -> reference.addFlags((Tag)xva$0));
        component.annotations().stream().filter(tag -> !reference.annotations().contains(tag)).forEach(xva$0 -> reference.addAnnotations((Tag)xva$0));
    }

    private void resolveFlags(Mogram parent, Mogram child) {
        parent.flags().stream().filter(tag -> !tag.equals((Object)Tag.Abstract) && !child.flags().contains(tag)).forEach(xva$0 -> child.addFlags(new Tag[]{xva$0}));
    }

    private void resolveAnnotations(Mogram parent, Mogram child) {
        parent.annotations().stream().filter(tag -> !tag.equals((Object)Tag.Abstract) && !child.annotations().contains(tag)).forEach(xva$0 -> child.addAnnotations(new Tag[]{xva$0}));
    }

    private void resolveVariables(Mogram parent, Mogram child) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Variable variable : parent.variables()) {
            if (this.isOverridden(child, variable)) {
                Variable overridenVariable = this.findVariable(child, variable.name());
                if (overridenVariable == null) continue;
                overridenVariable.addFlags(variable.flags().toArray(new Tag[0]));
                overridenVariable.overriden(true);
                continue;
            }
            variables.add(variable.cloneIt(child));
        }
        child.add(0, variables.toArray(new Variable[0]));
    }

    private Variable findVariable(Mogram child, String name) {
        for (Variable variable : child.variables()) {
            if (!variable.name().equals(name)) continue;
            return variable;
        }
        return null;
    }

    private boolean isOverridden(MogramContainer child, Mogram mogram) {
        for (Mogram c : child.components()) {
            if (this.isHasReference(c) || !this.areNamesake(mogram, c) || !c.type().equals(mogram.type())) continue;
            if (c instanceof MogramImpl && c.parent() == null) {
                ((MogramImpl)c).setParent(mogram);
            }
            return true;
        }
        return false;
    }

    private boolean areNamesake(Mogram mogram, Mogram c) {
        return c.name() != null && c.name().equals(mogram.name());
    }

    private boolean isHasReference(Mogram component) {
        return component instanceof MogramReference && ((MogramReference)component).isHas();
    }

    private boolean isOverridden(Mogram child, Variable variable) {
        return child.variables().stream().anyMatch(childVar -> childVar.name().equals(variable.name()) && childVar.type().equals((Object)variable.type()));
    }

    private List<Mogram> getChildrenSorted(Mogram parent) {
        ArrayList<Mogram> children = new ArrayList<Mogram>(parent.children());
        this.sort(children);
        return children;
    }

    private void sort(List<Mogram> mograms) {
        if (mograms.isEmpty()) {
            return;
        }
        mograms.sort(this.inheritanceComparator());
        Collections.reverse(mograms);
    }

    private Comparator<Mogram> inheritanceComparator() {
        return new Comparator<Mogram>(){

            @Override
            public int compare(Mogram o1, Mogram o2) {
                return this.maxLevel(o1) - this.maxLevel(o2);
            }

            private int maxLevel(Mogram mogram) {
                ArrayList<Integer> levels = new ArrayList<Integer>(Collections.singletonList(0));
                levels.addAll(mogram.children().stream().map(this::maxLevel).toList());
                levels.sort(Collections.reverseOrder());
                return 1 + (Integer)levels.get(0);
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
    }
}

