/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.utils;

import io.intino.tara.builder.core.errorcollection.TaraException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class JavaCompiler {
    public static void compile(File file, String classPath, File destination) throws TaraException {
        javax.tools.JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromStrings(Collections.singletonList(file.getAbsolutePath()));
        ArrayList<String> options = new ArrayList<String>();
        options.add("-source");
        options.add("11");
        options.add("-target");
        options.add("11");
        options.add("-d");
        options.add(destination.getAbsolutePath());
        options.add("-cp");
        options.add(classPath);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits);
        if (!task.call().booleanValue()) {
            StringBuilder message = new StringBuilder();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                message.append(diagnostic.getMessage(Locale.ENGLISH)).append(" in ").append(diagnostic.getLineNumber()).append(":").append(diagnostic.getColumnNumber()).append("\n");
            }
            throw new TaraException(message.toString());
        }
        try {
            fileManager.close();
        }
        catch (IOException e) {
            throw new TaraException("Error compiling language. " + e.getMessage());
        }
    }
}

