/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.utils;

import io.intino.tara.builder.model.MogramImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

public class DifferentialCache {
    private final File directory;
    private List<String> hashCodes;

    public DifferentialCache(File directory) {
        this.directory = directory;
        directory.mkdirs();
        this.loadCache();
    }

    private void loadCache() {
        File file = this.cacheFile();
        try {
            this.hashCodes = !file.exists() ? new ArrayList() : Files.readAllLines(file.toPath());
        }
        catch (IOException e) {
            new ArrayList();
        }
    }

    private File cacheFile() {
        return new File(this.directory, ".cache");
    }

    public void saveCache(List<String> codes) {
        try {
            Files.writeString(this.cacheFile().toPath(), (CharSequence)String.join((CharSequence)"\n", codes), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isModified(MogramImpl node) {
        return !this.hashCodes.contains(node.getHashCode());
    }
}

