/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.codegeneration.language;

import io.intino.itrules.Adapter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.tara.Language;
import io.intino.tara.builder.codegeneration.TemplateTags;
import io.intino.tara.builder.codegeneration.language.LanguageInheritanceManager;
import io.intino.tara.builder.codegeneration.language.LanguageParameterAdapter;
import io.intino.tara.builder.codegeneration.language.TerminalConstraintManager;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.builder.model.MogramReference;
import io.intino.tara.builder.model.VariableReference;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramContainer;
import io.intino.tara.language.model.MogramRoot;
import io.intino.tara.language.model.Rule;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.model.rules.composition.MogramCustomRule;
import io.intino.tara.language.semantics.Assumption;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.Context;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class LanguageModelAdapter
implements Adapter<Model>,
TemplateTags {
    private static final String FacetSeparator = ":";
    private final CompilerConfiguration.Level level;
    private final String workingPackage;
    private final Set<Mogram> processed = new HashSet<Mogram>();
    private final String outDSL;
    private final Locale locale;
    private final Language language;
    private int rootNumber = 0;

    LanguageModelAdapter(String outDSL, Locale locale, Language language, CompilerConfiguration.Level level, String workingPackage) {
        this.outDSL = outDSL;
        this.locale = locale;
        this.language = language;
        this.level = level;
        this.workingPackage = workingPackage;
    }

    public void adapt(Model model, FrameBuilderContext context) {
        this.initRoot(context);
        this.buildRootMograms(model, context);
        this.addInheritedRules(model, context);
    }

    private void initRoot(FrameBuilderContext root) {
        root.add("name", (Object)this.outDSL);
        root.add("terminal", (Object)this.level.equals((Object)CompilerConfiguration.Level.MetaModel));
        root.add("metaLanguage", (Object)this.language.languageName());
        root.add("locale", (Object)this.locale.getLanguage());
    }

    private void buildRootMograms(Model model, FrameBuilderContext root) {
        FrameBuilder builder = new FrameBuilder(new String[]{"node"});
        this.createRuleFrame((Mogram)model, builder, root);
        model.components().forEach(n -> {
            FrameBuilder rootNodeFrame = new FrameBuilder(new String[]{"root"});
            rootNodeFrame.add("number", (Object)(++this.rootNumber));
            rootNodeFrame.add("language", (Object)this.outDSL);
            root.add("root", (Object)rootNodeFrame.toFrame());
            this.buildMogram((Mogram)n, rootNodeFrame);
        });
    }

    private void buildMogram(Mogram mogram, FrameBuilder root) {
        if (this.alreadyProcessed(mogram)) {
            return;
        }
        FrameBuilder frame = new FrameBuilder(new String[]{"node"});
        if (!(mogram.isAbstract() || mogram.isAnonymous() || mogram.is(Tag.Instance))) {
            this.createRuleFrame(mogram, frame, (FrameBuilderContext)root);
        } else if (mogram.is(Tag.Instance) && !mogram.isAnonymous()) {
            root.add("node", (Object)this.createInstanceFrame(mogram));
        }
        if (!mogram.isAnonymous()) {
            mogram.components().stream().filter(inner -> !(inner instanceof MogramReference)).forEach(n -> this.buildMogram((Mogram)n, root));
        }
    }

    private void createRuleFrame(Mogram mogram, FrameBuilder builder, FrameBuilderContext root) {
        builder.add("name", (Object)this.name(mogram));
        this.addTypes(mogram, builder);
        this.addConstraints(mogram, builder);
        this.addAssumptions(mogram, builder);
        this.addDoc(mogram, builder);
        root.add("node", (Object)builder.toFrame());
    }

    private Frame createInstanceFrame(Mogram mogram) {
        FrameBuilder builder = new FrameBuilder(new String[]{"instance"}).add("qn", (Object)this.name(mogram));
        this.addTypes(mogram, builder);
        builder.add("path", (Object)this.outDSL);
        return builder.toFrame();
    }

    private void addInheritedRules(Model model, FrameBuilderContext root) {
        new LanguageInheritanceManager(root, this.instanceConstraints(), this.language, model).fill();
    }

    private List<String> instanceConstraints() {
        return this.language.catalog().entrySet().stream().filter(entry -> this.isInstance((Context)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private boolean isInstance(Context context) {
        return context.assumptions().stream().anyMatch(a -> a instanceof Assumption.Instance);
    }

    private void addDoc(Mogram mogram, FrameBuilder frame) {
        frame.add("doc", (Object)new FrameBuilder(new String[]{"doc"}).add("Layer", (Object)this.findLayer(mogram)).add("file", (Object)new File(mogram.file()).getName().replace("\\", "\\\\")).add("line", (Object)mogram.line()).add("doc", (Object)(mogram.doc() != null ? this.format(mogram.doc()) : this.format(this.text(mogram)))).toFrame());
    }

    private String text(Mogram mogram) {
        return mogram instanceof MogramImpl ? ((MogramImpl)mogram).text() : mogram.toString();
    }

    private String findLayer(Mogram mogram) {
        return mogram instanceof Model ? "" : LanguageModelAdapter.getQn(mogram, this.workingPackage);
    }

    private String format(String doc) {
        return doc.replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "");
    }

    private void addTypes(Mogram mogram, FrameBuilder builder) {
        if (mogram.type() == null) {
            return;
        }
        FrameBuilder typesFrameBuilder = new FrameBuilder(new String[]{"nodeType"});
        LinkedHashSet<String> typeSet = new LinkedHashSet<String>();
        typeSet.add(mogram.type());
        Collection<String> languageTypes = this.getLanguageTypes(mogram);
        if (languageTypes != null) {
            typeSet.addAll(languageTypes);
        }
        for (String type : typeSet) {
            typesFrameBuilder.add("type", (Object)type);
        }
        if (typesFrameBuilder.slots() > 0) {
            builder.add("nodeType", (Object)typesFrameBuilder.toFrame());
        }
    }

    private Collection<String> getLanguageTypes(Mogram mogram) {
        return this.language.types(mogram.type());
    }

    private boolean alreadyProcessed(Mogram mogram) {
        return !this.processed.add(mogram);
    }

    private void addConstraints(Mogram mogram, FrameBuilder builder) {
        FrameBuilder constraints = this.buildComponentConstraints(mogram);
        this.addTerminalConstrains(mogram, constraints);
        this.addContextConstraints(mogram, constraints);
        builder.add("constraints", (Object)constraints.toFrame());
    }

    private void addContextConstraints(Mogram mogram, FrameBuilder constraints) {
        if (mogram instanceof MogramImpl) {
            if (!mogram.isTerminal()) {
                this.addRequiredVariableRedefines(constraints, mogram);
            }
            this.addParameterConstraints(mogram.variables(), mogram.type().startsWith("Facet") ? mogram.name() : "", constraints, LanguageParameterAdapter.terminalParameters(this.language, mogram) + this.terminalParameterIndex(constraints.toFrame()));
        }
        this.addMetaFacetConstraints(mogram, constraints);
        this.addFacetConstraints(mogram, constraints);
    }

    private int terminalParameterIndex(Frame constraints) {
        Iterator iterator = constraints.frames("constraint");
        int index = 0;
        while (iterator.hasNext()) {
            if (!((Frame)iterator.next()).is("parameter")) continue;
            ++index;
        }
        return index;
    }

    private void addParameterConstraints(List<Variable> variables, String facet, FrameBuilder constrainsFrame, int parentIndex) {
        int privateVariables = 0;
        for (int index = 0; index < variables.size(); ++index) {
            Variable variable = variables.get(index);
            if (!variable.isPrivate() && !this.finalWithValues(variable)) {
                new LanguageParameterAdapter(this.language, this.workingPackage, this.level).addParameterConstraint(constrainsFrame, facet, parentIndex + index - privateVariables, variable, "constraint");
                continue;
            }
            ++privateVariables;
        }
    }

    private boolean finalWithValues(Variable variable) {
        return variable.isFinal() && !variable.values().isEmpty();
    }

    private void addMetaFacetConstraints(Mogram mogram, FrameBuilder constraints) {
        mogram.components().stream().filter(Mogram::isMetaFacet).forEach(facetMogram -> {
            List with = facetMogram.facetConstraints();
            FrameBuilder builder = new FrameBuilder(new String[]{"constraint", "metaFacet"}).add("value", (Object)facetMogram.qualifiedName());
            if (with != null && !with.isEmpty()) {
                builder.add("with", with.stream().map(c -> c.node().qualifiedName()).toArray(Object[]::new));
            }
            constraints.add("constraint", (Object)builder.toFrame());
        });
    }

    private void addFacetConstraints(Mogram mogram, FrameBuilder constraintsBuilder) {
        mogram.components().stream().filter(Mogram::isFacet).forEach(facetMogram -> {
            if (facetMogram.isAbstract()) {
                return;
            }
            if (facetMogram.isReference()) {
                facetMogram = facetMogram.targetOfReference();
            }
            FrameBuilder builder = new FrameBuilder(new String[]{"constraint", "facet"}).add("value", (Object)facetMogram.qualifiedName());
            builder.add("terminal", (Object)String.valueOf(facetMogram.isTerminal()));
            if (facetMogram.facetConstraints() != null && !facetMogram.facetConstraints().isEmpty()) {
                for (Mogram.FacetConstraint constraint : facetMogram.facetConstraints()) {
                    builder.add("with", (Object)constraint.node().name());
                }
            }
            if (facetMogram.flags().contains(Tag.Required)) {
                builder.add("required", (Object)"true");
            }
            this.addParameterConstraints(facetMogram.variables(), facetMogram.name(), builder, 0);
            this.addComponentsConstraints(builder, (Mogram)facetMogram);
            this.addTerminalConstrains((Mogram)facetMogram, builder);
            constraintsBuilder.add("constraint", (Object)builder.toFrame());
        });
        this.addTerminalFacets(mogram, constraintsBuilder);
    }

    private void addTerminalFacets(Mogram mogram, FrameBuilder context) {
        List<Constraint> facetAllows = this.language.constraints(mogram.type()).stream().filter(allow -> allow instanceof Constraint.Facet && ((Constraint.Facet)allow).terminal()).collect(Collectors.toList());
        new TerminalConstraintManager(this.language, (MogramContainer)mogram).addConstraints(facetAllows, (FrameBuilderContext)context);
    }

    private void addTerminalConstrains(Mogram container, FrameBuilder frame) {
        List constraints = this.language.constraints(container.type());
        List<Constraint> terminalConstraints = constraints.stream().filter(c -> this.validComponent(container, (Constraint)c) || this.validParameter(container, (Constraint)c)).collect(Collectors.toList());
        new TerminalConstraintManager(this.language, (MogramContainer)container).addConstraints(terminalConstraints, (FrameBuilderContext)frame);
    }

    private boolean validParameter(Mogram container, Constraint c) {
        if (!(c instanceof Constraint.Parameter)) {
            return false;
        }
        return ((Constraint.Parameter)c).flags().contains(Tag.Terminal) && !this.isRedefined((Constraint.Parameter)c, container.variables());
    }

    private boolean validComponent(Mogram container, Constraint c) {
        if (!(c instanceof Constraint.Component)) {
            return false;
        }
        return this.is(this.annotations(c), Tag.Instance) && !this.sizeComplete((MogramContainer)container, this.typeOf(c));
    }

    private boolean isRedefined(Constraint.Parameter allow, List<? extends Variable> variables) {
        for (Variable variable : variables) {
            if (!variable.name().equals(allow.name())) continue;
            return true;
        }
        return false;
    }

    private String typeOf(Constraint constraint) {
        return ((Constraint.Component)constraint).type();
    }

    private boolean sizeComplete(MogramContainer container, String type) {
        List components = container.components().stream().filter(node -> node.type().equals(type)).collect(Collectors.toList());
        return !components.isEmpty() && container.sizeOf((Mogram)components.get(0)).max() == components.size();
    }

    private void addRequiredVariableRedefines(FrameBuilder constraints, Mogram mogram) {
        mogram.variables().stream().filter(variable -> variable.isTerminal() && variable instanceof VariableReference && !((VariableReference)variable).getTarget().isTerminal()).forEach(variable -> constraints.add("constraint", (Object)new FrameBuilder(new String[]{"redefine", "constraint"}).add("name", (Object)variable.name()).add("supertype", (Object)variable.type()).toFrame()));
    }

    private void addAssumptions(Mogram mogram, FrameBuilder frame) {
        FrameBuilder assumptions = this.buildAssumptions(mogram);
        if (assumptions.slots() != 0) {
            frame.add("assumptions", (Object)assumptions.toFrame());
        }
    }

    private FrameBuilder buildAssumptions(Mogram mogram) {
        FrameBuilder assumptions = new FrameBuilder(new String[]{"assumptions"});
        assumptions.add("assumption", (Object)new FrameBuilder(new String[]{"stashNodeName"}).add("value", (Object)LanguageModelAdapter.name(mogram, this.workingPackage)));
        this.addAnnotationAssumptions(mogram, assumptions);
        return assumptions;
    }

    public static String name(Mogram owner, String workingPackage) {
        return owner instanceof Model ? "" : Format.withDollar().format(Format.noPackage().format((Object)LanguageModelAdapter.getQn(owner, workingPackage))).toString();
    }

    public static String getQn(Mogram mogram, String workingPackage) {
        return workingPackage.toLowerCase() + "." + Format.qualifiedName().format((Object)LanguageModelAdapter.layerQn(mogram)).toString();
    }

    private static String layerQn(Mogram mogram) {
        return mogram instanceof MogramReference ? ((MogramReference)mogram).layerQualifiedName() : ((MogramImpl)mogram).layerQualifiedName();
    }

    private void addAnnotationAssumptions(Mogram mogram, FrameBuilder assumptions) {
        mogram.annotations().forEach(tag -> assumptions.add("assumption", (Object)tag.name().toLowerCase()));
        for (Tag tag2 : mogram.flags()) {
            if (tag2.equals((Object)Tag.Terminal)) {
                assumptions.add("assumption", (Object)Tag.Instance.name());
                continue;
            }
            if (tag2.equals((Object)Tag.Feature)) {
                assumptions.add("assumption", (Object)Tag.Feature.name());
                continue;
            }
            if (tag2.equals((Object)Tag.Component)) {
                assumptions.add("assumption", (Object)Format.capitalize(Tag.Component.name()));
                continue;
            }
            if (!tag2.equals((Object)Tag.Volatile)) continue;
            assumptions.add("assumption", (Object)Format.capitalize(Tag.Volatile.name()));
        }
        if (mogram.type().startsWith("MetaFacet")) {
            assumptions.add("assumption", (Object)Tag.Facet.name());
        }
        if (mogram.isFacet()) {
            assumptions.add("assumption", (Object)Tag.Terminal);
        }
    }

    private FrameBuilder buildComponentConstraints(Mogram container) {
        FrameBuilder constraints = new FrameBuilder(new String[]{"constraints"});
        this.addComponentsConstraints(constraints, container);
        return constraints;
    }

    private void addComponentsConstraints(FrameBuilder constraints, Mogram container) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        this.createComponentsConstraints(container, frames);
        frames.forEach(frame -> constraints.add("constraint", frame));
    }

    private void createComponentsConstraints(Mogram mogram, List<Frame> frames) {
        mogram.components().stream().filter(c -> this.componentCompliant(mogram, (Mogram)c)).forEach(c -> {
            if (c.isMetaFacet()) {
                this.createMetaFacetComponentConstraint(frames, (Mogram)c);
            } else if (!c.isSub() || c.container() instanceof Model) {
                this.createComponentConstraint(frames, (Mogram)c);
            }
        });
    }

    private boolean componentCompliant(Mogram container, Mogram mogram) {
        return !mogram.isFacet() && (!(container instanceof MogramRoot) || this.rootCompliant(mogram));
    }

    private boolean rootCompliant(Mogram c) {
        return !c.is(Tag.Component) && !c.is(Tag.Feature) && (!c.isTerminal() || !c.into(Tag.Component) && !c.into(Tag.Feature));
    }

    private void createMetaFacetComponentConstraint(List<Frame> frames, Mogram mogram) {
        if (!mogram.isMetaFacet() || mogram.isAbstract()) {
            return;
        }
        Mogram target = mogram.container();
        if (target.isAbstract()) {
            for (Mogram child : target.children()) {
                FrameBuilder builder = new FrameBuilder(new String[]{"constraint", "component"}).add("type", (Object)(mogram.name() + FacetSeparator + child.qualifiedName()));
                builder.add("size", (Object)(mogram.isTerminal() && CompilerConfiguration.Level.MetaModel.compareLevelWith(this.level) > 0 ? this.transformSizeRuleOfTerminalNode(mogram) : this.createRulesFrames(mogram.container().rulesOf(mogram))));
                this.addTags(mogram, builder);
                frames.add(builder.toFrame());
            }
        } else {
            this.createComponentConstraint(frames, mogram);
        }
    }

    private void createComponentConstraint(List<Frame> frames, Mogram mogram) {
        List<Mogram> candidates = this.collectCandidates(mogram);
        Size size = mogram.container().sizeOf(mogram);
        List<Rule> allRules = mogram.container().rulesOf(mogram).stream().distinct().collect(Collectors.toList());
        if ((size.isSingle() || size.isRequired() || mogram.isReference()) && candidates.size() > 1) {
            FrameBuilder oneOfBuilder = this.createOneOf(candidates, allRules);
            if (!mogram.isAbstract() && !candidates.contains(mogram)) {
                oneOfBuilder.add("constraint", (Object)this.createComponentConstraint(mogram, allRules));
            }
            if (!mogram.isSub()) {
                frames.add(oneOfBuilder.toFrame());
            }
        } else {
            frames.addAll(candidates.stream().filter(c -> this.componentCompliant(c.container(), (Mogram)c)).map(c -> this.createComponentConstraint((Mogram)c, allRules)).toList());
        }
    }

    private Frame createComponentConstraint(Mogram component, List<Rule> rules) {
        FrameBuilder builder = new FrameBuilder(new String[]{"constraint", "component"}).add("type", (Object)this.name(component));
        if (this.isTerminal(component)) {
            builder.add("size", (Object)this.transformSizeRuleOfTerminalNode(component));
        } else {
            builder.add("size", (Object)this.createRulesFrames(rules));
        }
        this.addTags(component, builder);
        return builder.toFrame();
    }

    private boolean isTerminal(Mogram component) {
        return component.isTerminal() && !this.isInTerminal(component) && CompilerConfiguration.Level.MetaModel.compareLevelWith(this.level) > 0;
    }

    private String name(Mogram mogram) {
        return mogram instanceof MogramReference ? ((MogramReference)mogram).destination().qualifiedName() : mogram.qualifiedName();
    }

    private FrameBuilder createOneOf(Collection<Mogram> candidates, List<Rule> rules) {
        FrameBuilder builder = new FrameBuilder(new String[]{"oneOf", "constraint"});
        builder.add("rule", (Object)this.createRulesFrames(rules));
        for (Mogram candidate : candidates) {
            builder.add("constraint", (Object)this.createComponentConstraint(candidate, candidate.container().rulesOf(candidate)));
        }
        return builder;
    }

    private Frame[] createRulesFrames(List<Rule> rules) {
        return (Frame[])rules.stream().map(rule -> rule instanceof MogramCustomRule ? this.buildCustomRuleFrame((MogramCustomRule)rule) : new FrameBuilder().append(rule).toFrame()).filter(Objects::nonNull).toArray(Frame[]::new);
    }

    private Frame buildCustomRuleFrame(MogramCustomRule rule) {
        if (rule.loadedClass() == null) {
            return null;
        }
        return new FrameBuilder(new String[]{"rule", "customRule"}).add("qn", (Object)rule.loadedClass().getName()).toFrame();
    }

    private boolean isInTerminal(Mogram component) {
        return component.container().isTerminal();
    }

    private Frame transformSizeRuleOfTerminalNode(Mogram component) {
        Size rule = component.container().sizeOf(component);
        Size size = new Size(0, rule.max(), rule);
        return new FrameBuilder().append((Object)size).toFrame();
    }

    private void addTags(Mogram mogram, FrameBuilder frame) {
        Set tags = mogram.annotations().stream().map(Enum::name).collect(Collectors.toCollection(LinkedHashSet::new));
        mogram.flags().stream().filter(f -> !f.equals((Object)Tag.Decorable) && !Tag.Required.equals(f)).forEach(tag -> tags.add(this.convertTag((Tag)tag)));
        frame.add("tags", (Object)tags.toArray(new Object[0]));
    }

    private List<Mogram> collectCandidates(Mogram mogram) {
        LinkedHashSet<Mogram> mograms = new LinkedHashSet<Mogram>();
        if (mogram.isAnonymous() || mogram.is(Tag.Instance)) {
            return new ArrayList<Mogram>(mograms);
        }
        if (!mogram.isAbstract()) {
            mograms.add(mogram);
        }
        this.getNonAbstractChildren(mogram, mograms);
        return new ArrayList<Mogram>(mograms);
    }

    private void getNonAbstractChildren(Mogram mogram, Set<Mogram> mograms) {
        for (Mogram child : mogram.children()) {
            if (child.isAbstract()) {
                this.getNonAbstractChildren(child, mograms);
                continue;
            }
            if (!child.container().equals((Object)mogram.container()) && !mogram.isReference()) continue;
            mograms.add(child);
        }
    }

    private String convertTag(Tag tag) {
        if (tag.equals((Object)Tag.Terminal)) {
            return Tag.Instance.name();
        }
        return tag.name();
    }

    private List<Tag> annotations(Constraint constraint) {
        return ((Constraint.Component)constraint).annotations();
    }

    private boolean is(List<Tag> annotations, Tag tag) {
        return annotations.contains(tag);
    }
}

