/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.parser.antlr;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;

public class TaraErrorStrategy
extends DefaultErrorStrategy {
    private static final Logger LOG = Logger.getGlobal();
    private static Token currentError;

    public Token recoverInline(Parser recognizer) throws RecognitionException {
        this.reportError(recognizer, (RecognitionException)new InputMismatchException(recognizer));
        return null;
    }

    public void reportError(Parser recognizer, RecognitionException e) {
        this.printParameters(recognizer);
        throw new InputMismatchException(recognizer);
    }

    private void printParameters(Parser recognizer) {
        Token token = recognizer.getCurrentToken();
        if (currentError == token) {
            return;
        }
        currentError = token;
        String[] nameList = recognizer.getTokenNames();
        LOG.info("Line: " + token.getLine() + "\nColumn: " + token.getCharPositionInLine() + "\nText Length: " + token.getText().length() + "\n" + (token.getType() > 0 ? "Token type: " + nameList[token.getType()] + "\n" : "") + "Expected tokens: " + recognizer.getExpectedTokens().toString(recognizer.getTokenNames()) + "Text: " + token.getText().replace("\n", "\\n"));
    }

    static {
        LOG.setLevel(Level.WARNING);
    }
}

