/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.parser;

import io.intino.tara.Language;
import io.intino.tara.compiler.core.CompilerConfiguration;
import io.intino.tara.compiler.core.SourceUnit;
import io.intino.tara.compiler.core.errorcollection.MergeException;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.lang.model.Node;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ASTMerger {
    private final Collection<SourceUnit> sources;
    private final CompilerConfiguration conf;

    public ASTMerger(Collection<SourceUnit> sources, CompilerConfiguration conf) {
        this.sources = sources;
        this.conf = conf;
    }

    public Map<Language, Model> doMerge() throws MergeException {
        Map<Language, List<SourceUnit>> languageListMap = this.groupByLanguage();
        HashMap<Language, Model> models = new HashMap<Language, Model>();
        for (Language language : languageListMap.keySet()) {
            models.put(language, this.processByLanguage(language, languageListMap.get(language)));
        }
        return models;
    }

    private Model processByLanguage(Language language, List<SourceUnit> sourceUnits) {
        Model model = new Model(this.getName());
        model.setLanguage(language);
        model.setResourcesRoot(this.conf.resourcesDirectory());
        model.setLevel(this.conf.level());
        for (SourceUnit unit : sourceUnits) {
            List<Node> components = unit.getModel().components();
            components.forEach(c -> {
                model.add((Node)c, unit.getModel().rulesOf((Node)c));
                ((NodeImpl)c).setDirty(unit.isDirty());
            });
            if (components.isEmpty()) continue;
            model.language(components.get(0).language());
        }
        for (Node node : model.components()) {
            node.container((Node)model);
        }
        if (this.conf.isVerbose()) {
            System.out.println("@#$%@# Presentable:Tarac: Merging fragments...");
        }
        return model;
    }

    private Map<Language, List<SourceUnit>> groupByLanguage() {
        HashMap<Language, List<SourceUnit>> list = new HashMap<Language, List<SourceUnit>>();
        for (SourceUnit source : this.sources) {
            if (!list.containsKey(source.getModel().getLanguage())) {
                list.put(source.getModel().getLanguage(), new ArrayList());
            }
            ((List)list.get(source.getModel().getLanguage())).add(source);
        }
        return list;
    }

    private String getName() {
        return this.conf.getProject() != null ? this.conf.getProject() + "." + this.conf.outDSL() : this.getPresentableName();
    }

    private String getPresentableName() {
        String name = new File(this.sources.iterator().next().getName()).getName();
        return name.substring(0, name.lastIndexOf("."));
    }
}

