/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.model;

import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.lang.model.Facet;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Parameter;
import io.intino.tara.lang.model.Rule;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NodeReference
implements Node {
    private Node container;
    private NodeImpl destiny;
    private String reference;
    private String file;
    private int line;
    private String doc;
    private List<Tag> flags = new ArrayList<Tag>();
    private List<Tag> annotations = new ArrayList<Tag>();
    private Set<String> allowedFacets = new HashSet<String>();
    private List<String> uses = new ArrayList<String>();
    private boolean has;
    private String language;

    public NodeReference(String reference) {
        this.reference = reference;
    }

    public NodeReference(NodeImpl destiny) {
        this.destiny = destiny;
        this.reference = destiny.qualifiedName();
    }

    public String getReference() {
        return this.reference;
    }

    public NodeImpl getDestiny() {
        return this.destiny;
    }

    public void setDestiny(NodeImpl destiny) {
        this.destiny = destiny;
    }

    public String name() {
        return this.destiny != null ? this.destiny.name() : "";
    }

    public void name(String name) {
    }

    public String file() {
        return this.file;
    }

    public void file(String file) {
        this.file = file;
    }

    public String language() {
        return this.language;
    }

    public void language(String language) {
        this.language = language;
    }

    public int line() {
        return this.line;
    }

    public void line(int line) {
        this.line = line;
    }

    public String doc() {
        return this.doc;
    }

    public void doc(String doc) {
        this.doc = doc;
    }

    public boolean isSub() {
        return false;
    }

    public boolean isHas() {
        return this.has;
    }

    public void setHas(boolean has) {
        this.has = has;
    }

    public List<Node> subs() {
        return Collections.unmodifiableList(this.destiny.subs());
    }

    public Node container() {
        return this.container;
    }

    public List<String> uses() {
        return this.uses;
    }

    public void container(Node container) {
        this.container = container;
    }

    public boolean isTerminal() {
        return this.is(Tag.Terminal);
    }

    public boolean isAbstract() {
        return this.is(Tag.Abstract);
    }

    public boolean isFacet() {
        return this.destiny.isFacet();
    }

    public boolean is(Tag tag) {
        return this.destiny.is(tag) || this.flags().contains(tag);
    }

    public boolean into(Tag tag) {
        return this.destiny.into(tag) || this.annotations().contains(tag);
    }

    public List<Tag> annotations() {
        ArrayList<Tag> tags = new ArrayList<Tag>(this.destiny.annotations());
        this.annotations.stream().filter(flag -> !tags.contains(flag)).forEach(tags::add);
        return Collections.unmodifiableList(tags);
    }

    public List<Tag> flags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        this.flags.stream().filter(flag -> !tags.contains(flag)).forEach(tags::add);
        if (this.isHas()) {
            tags.addAll(this.destiny.flags());
        }
        return Collections.unmodifiableList(tags);
    }

    public void addAnnotations(Tag ... annotations) {
        Collections.addAll(this.annotations, annotations);
    }

    public void addFlags(List<Tag> flags) {
        this.flags.addAll(flags);
    }

    public void addFlag(Tag flag) {
        this.flags.add(flag);
    }

    public void addUses(List<String> uses) {
        this.uses.addAll(uses);
    }

    public Node parent() {
        return null;
    }

    public String parentName() {
        return null;
    }

    public boolean isAnonymous() {
        return this.destiny.isAnonymous();
    }

    public String qualifiedName() {
        return this.getContainerQualifiedName() + "." + this.destiny.name();
    }

    public String cleanQn() {
        return this.getContainerQualifiedNameCleaned() + "$" + this.destiny.name();
    }

    private String getContainerQualifiedName() {
        return this.container.qualifiedName();
    }

    private String getContainerQualifiedNameCleaned() {
        return this.container.cleanQn();
    }

    public String type() {
        return this.destiny.type();
    }

    public List<String> types() {
        return this.destiny.types();
    }

    public List<String> secondaryTypes() {
        return this.destiny.secondaryTypes();
    }

    public void type(String type) {
    }

    public Node resolve() {
        return this;
    }

    public boolean isReference() {
        return true;
    }

    public List<Parameter> parameters() {
        return Collections.emptyList();
    }

    public List<Node> siblings() {
        ArrayList components = new ArrayList(this.container.components());
        components.remove(this);
        return Collections.unmodifiableList(components);
    }

    public List<Node> components() {
        return Collections.unmodifiableList(this.destiny.components());
    }

    public List<Rule> rulesOf(Node component) {
        return this.destiny.rulesOf(component);
    }

    public boolean contains(Node nodeContainer) {
        return false;
    }

    public List<Variable> variables() {
        return Collections.unmodifiableList(this.destiny.variables());
    }

    public List<Node> referenceComponents() {
        return Collections.unmodifiableList(this.destiny.referenceComponents());
    }

    public Node destinyOfReference() {
        return this.destiny;
    }

    public List<Node> children() {
        return Collections.unmodifiableList(this.destiny.children());
    }

    public List<Facet> facets() {
        return Collections.unmodifiableList(this.destiny.facets());
    }

    public List<String> allowedFacets() {
        return Collections.unmodifiableList(new ArrayList<String>(this.allowedFacets));
    }

    public void addAllowedFacets(String ... facet) {
        Collections.addAll(this.allowedFacets, facet);
    }

    public FacetTarget facetTarget() {
        return this.destiny.facetTarget();
    }

    public String toString() {
        return this.destiny != null ? this.qualifiedName() : this.reference;
    }
}

