/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.model;

import io.intino.tara.Language;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.NodeRoot;
import io.intino.tara.lang.model.Rule;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Model
implements NodeRoot {
    private String file;
    private Language language;
    private Configuration.Level level;
    private Map<Node, List<Rule>> components = new LinkedHashMap<Node, List<Rule>>();
    private List<String> uses;
    private Map<String, Class<?>> rules;
    private File resourcesRoot;

    public Model(String file) {
        this.file = file;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String file() {
        return this.file;
    }

    public void file(String file) {
        this.file = file;
    }

    public List<String> uses() {
        return this.uses;
    }

    public Configuration.Level level() {
        return this.level;
    }

    public void setLevel(Configuration.Level level) {
        this.level = level;
    }

    public boolean contains(Node nodeContainer) {
        return this.components.keySet().contains(nodeContainer);
    }

    public void remove(Node node) {
        if (node != null) {
            this.components.remove(node);
        }
    }

    public String doc() {
        return "";
    }

    public List<Node> components() {
        return Collections.unmodifiableList(new ArrayList<Node>(this.components.keySet()));
    }

    public String type() {
        return "";
    }

    public void add(Node node, List<Rule> rule) {
        this.components.put(node, new ArrayList<Rule>(rule));
    }

    public List<Rule> rulesOf(Node component) {
        return this.components.get(component);
    }

    public Language getLanguage() {
        return this.language;
    }

    public String language() {
        return this.language != null ? this.language.languageName() : "";
    }

    public void setUses(List<String> uses) {
        this.uses = uses;
    }

    public void setRules(Map<String, Class<?>> rules) {
        this.rules = rules;
    }

    public Map<String, Class<?>> getRules() {
        return this.rules;
    }

    public void setResourcesRoot(File resourceRoot) {
        this.resourcesRoot = resourceRoot;
    }

    public File resourcesRoot() {
        return this.resourcesRoot;
    }
}

