/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.model;

import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import java.util.ArrayList;
import java.util.List;

public class FacetTargetImpl
implements FacetTarget,
Cloneable {
    private String file;
    private int line;
    private List<FacetTarget.Constraint> constraints = new ArrayList<FacetTarget.Constraint>();
    private String target;
    private Node targetNode;
    private Node owner;
    private String language;
    private Node parent;
    private boolean inherited;

    public String target() {
        return this.target;
    }

    public void target(String target) {
        this.target = target;
    }

    public List<FacetTarget.Constraint> constraints() {
        return this.constraints;
    }

    public void constraints(List<String> constraintNames) {
        this.constraints.clear();
        constraintNames.forEach(c -> this.constraints().add(new FacetConstraint((String)c)));
    }

    public void setConstraints(List<FacetTarget.Constraint> constraints) {
        this.constraints = new ArrayList<FacetTarget.Constraint>(constraints);
    }

    public Node targetNode() {
        return this.targetNode;
    }

    public Node parent() {
        return this.parent;
    }

    public boolean inherited() {
        return this.inherited;
    }

    public void inherited(boolean inherited) {
        this.inherited = inherited;
    }

    public void parent(Node node) {
        this.parent = node;
    }

    public void targetNode(Node destiny) {
        this.targetNode = destiny;
    }

    public Node owner() {
        return this.owner;
    }

    public void owner(Node node) {
        this.owner = node;
    }

    public String file() {
        return this.file;
    }

    public void file(String file) {
        this.file = file;
    }

    public int line() {
        return this.line;
    }

    public void line(int line) {
        this.line = line;
    }

    public String toString() {
        return "on " + this.target;
    }

    public String language() {
        return this.language;
    }

    public void language(String language) {
        this.language = language;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public FacetTargetImpl clone() throws CloneNotSupportedException {
        super.clone();
        FacetTargetImpl facetTarget = new FacetTargetImpl();
        facetTarget.file(this.file());
        facetTarget.line(this.line());
        facetTarget.target(this.target);
        facetTarget.parent(this.parent);
        facetTarget.targetNode(this.targetNode);
        ArrayList<FacetTarget.Constraint> cloned = new ArrayList<FacetTarget.Constraint>();
        for (FacetTarget.Constraint constraint : this.constraints) {
            cloned.add(constraint.clone());
        }
        facetTarget.setConstraints(cloned);
        return facetTarget;
    }

    private static class FacetConstraint
    implements FacetTarget.Constraint,
    Cloneable {
        private Node node;
        private boolean negated = false;
        private String name;

        FacetConstraint(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public Node node() {
            return this.node;
        }

        public void node(Node node) {
            this.node = node;
        }

        public boolean negated() {
            return this.negated;
        }

        public FacetConstraint clone() throws CloneNotSupportedException {
            return (FacetConstraint)super.clone();
        }

        public String toString() {
            return (this.negated() ? "withOut" : "with") + " " + this.node().qualifiedName();
        }
    }
}

