/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.dependencyresolution;

import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeReference;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Tag;

public class TerminalResolver {
    private final Model model;
    private final Configuration.Level level;

    public TerminalResolver(Model model, Configuration.Level level) {
        this.model = model;
        this.level = level;
    }

    public void resolve() {
        this.resolveTerminals((Node)this.model);
    }

    private void resolveTerminals(Node node) {
        for (Node component : node.components()) {
            if (component instanceof NodeReference) continue;
            if (component.isTerminal()) {
                this.propagateTerminalToInside(component);
                continue;
            }
            if (Configuration.Level.Application.compareLevelWith(this.level) > 0) {
                this.resolveTerminals(component);
                continue;
            }
            if (this.level.compareLevelWith(Configuration.Level.Application) != 0) continue;
            component.addFlag(Tag.Terminal);
            this.propagateTerminalToInside(component);
        }
    }

    private void propagateTerminalToInside(Node node) {
        for (Node component : node.components()) {
            if (component instanceof NodeReference) continue;
            if (!component.isTerminal()) {
                component.addFlag(Tag.Terminal);
            }
            this.propagateTerminalToInside(component);
        }
        this.propagateTerminalToVariables(node);
    }

    private void propagateTerminalToVariables(Node node) {
        node.variables().stream().filter(variable -> !variable.isTerminal()).forEach(variable -> variable.addFlags(new Tag[]{Tag.Terminal}));
    }
}

