/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.dependencyresolution;

import io.intino.tara.compiler.core.errorcollection.DependencyException;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.lang.model.Element;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Valued;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.NativeWordRule;
import io.intino.tara.lang.model.rules.variable.NativeReferenceRule;
import io.intino.tara.lang.model.rules.variable.NativeRule;
import io.intino.tara.lang.model.rules.variable.ReferenceRule;
import io.intino.tara.lang.model.rules.variable.VariableRule;
import io.intino.tara.lang.model.rules.variable.WordRule;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class NativeResolver {
    private static final Logger LOG = Logger.getGlobal();
    private final Model model;
    private final File functionsDirectory;

    public NativeResolver(Model model, File functionsDirectory) {
        this.model = model;
        this.functionsDirectory = functionsDirectory;
    }

    public void resolve() throws DependencyException {
        for (Node node : this.model.components()) {
            this.resolve(node);
        }
    }

    private void resolve(Node node) throws DependencyException {
        if (!(node instanceof NodeImpl)) {
            return;
        }
        this.resolveNative(node.variables());
        this.resolveNative(node.parameters());
        for (Node include : node.components()) {
            this.resolve(include);
        }
    }

    private void resolveNative(List<? extends Valued> valuedList) throws DependencyException {
        for (Valued valued : valuedList) {
            if (!(valued.rule() instanceof NativeRule) && (valued.values().isEmpty() || !(valued.values().get(0) instanceof Primitive.Expression) && !(valued.values().get(0) instanceof Primitive.MethodReference)) && !valued.flags().contains(Tag.Reactive)) continue;
            this.fillRule(valued);
        }
    }

    private void fillRule(Valued valued) throws DependencyException {
        if (valued.rule() == null) {
            valued.rule((VariableRule)new NativeRule("", "", new ArrayList()));
        } else if (valued.rule() instanceof ReferenceRule) {
            valued.rule((VariableRule)new NativeReferenceRule(((ReferenceRule)valued.rule()).allowedReferences()));
        } else if (valued.rule() instanceof WordRule) {
            valued.rule((VariableRule)new NativeWordRule(((WordRule)valued.rule()).words()));
        } else if (!(valued.rule() instanceof NativeRule)) {
            valued.rule((VariableRule)new NativeRule("", "", new ArrayList()));
        }
        this.fillInfo(valued, (NativeRule)valued.rule());
    }

    private void fillInfo(Valued valued, NativeRule rule) throws DependencyException {
        if (valued instanceof Variable && valued.type().equals((Object)Primitive.FUNCTION)) {
            this.fillVariableInfo((Variable)valued, rule);
        }
    }

    private void fillVariableInfo(Variable variable, NativeRule rule) throws DependencyException {
        if (this.functionsDirectory == null || !this.functionsDirectory.exists()) {
            throw new DependencyException("reject.nonexisting.functions.directory", null, new String[0]);
        }
        File[] files = this.functionsDirectory.listFiles((dir, filename) -> filename.endsWith(".java") && filename.substring(0, filename.lastIndexOf(".")).equalsIgnoreCase(rule.interfaceClass()));
        if ((files != null ? files.length : 0) == 0) {
            throw new DependencyException("reject.nonexisting.variable.rule", (Element)variable, new String[0]);
        }
        String text = this.readFile(files[0]);
        String signature = this.getSignature(text);
        if (signature.isEmpty()) {
            throw new DependencyException("reject.native.signature.not.found", (Element)variable, new String[0]);
        }
        rule.signature(signature);
        rule.imports(this.getInterfaceImports(Arrays.asList(text.split("\n"))));
    }

    private String getSignature(String text) {
        text = text.substring(text.indexOf("{") + 1, text.indexOf(";", text.indexOf("{") + 1)).trim();
        if (!(text = text.replaceAll("//.*\n", "")).startsWith("public")) {
            text = "public " + text;
        }
        return text;
    }

    private List<String> getInterfaceImports(List<String> text) {
        return new ArrayList<String>(text.stream().filter(line -> line.trim().startsWith("import ")).map(String::trim).collect(Collectors.toSet()));
    }

    private String readFile(File file) {
        try {
            return new String(Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            LOG.severe("File cannot be read: " + file.getAbsolutePath());
            return "";
        }
    }
}

