/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.dependencyresolution;

import io.intino.tara.compiler.model.Model;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import java.util.List;
import java.util.stream.Collectors;

public class ModelUtils {
    public static FacetTarget findFacetTarget(Model model, Node target, String facet) {
        for (Node node : model.components()) {
            FacetTarget facetTarget;
            if (!facet.equals(node.name()) || (facetTarget = ModelUtils.correspondingTarget(node, target)) == null) continue;
            return facetTarget;
        }
        return null;
    }

    public static Node findFacetTargetNode(Model model, Node target, String facet) {
        List<Node> candidates = model.components().stream().filter(node -> facet.equals(node.name()) && ModelUtils.correspondingTarget(node, target) != null).collect(Collectors.toList());
        return candidates.isEmpty() ? null : ModelUtils.selectCandidate(target, candidates);
    }

    private static Node selectCandidate(Node target, List<Node> candidates) {
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        for (Node candidate = target; candidate != null; candidate = candidate.parent()) {
            for (Node node : candidates) {
                if (!node.facetTarget().targetNode().equals((Object)candidate)) continue;
                return node;
            }
        }
        return candidates.get(0);
    }

    private static FacetTarget correspondingTarget(Node node, Node target) {
        FacetTarget facetTarget = node.facetTarget();
        return facetTarget != null && (facetTarget.targetNode().equals((Object)target) || ModelUtils.isChild(facetTarget.targetNode(), target)) ? facetTarget : null;
    }

    private static boolean isChild(Node parent, Node target) {
        if (parent.children().contains(target)) {
            return true;
        }
        for (Node node : parent.children()) {
            boolean isChild = ModelUtils.isChild(node, target);
            if (!isChild) continue;
            return true;
        }
        return false;
    }
}

