/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.dependencyresolution;

import io.intino.tara.compiler.codegeneration.Format;
import io.intino.tara.compiler.codegeneration.JavaCompiler;
import io.intino.tara.compiler.core.errorcollection.TaraException;
import io.intino.tara.lang.model.rules.CustomRule;
import io.intino.tara.lang.model.rules.custom.Url;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;

class CustomRuleLoader {
    private static final Logger LOG = Logger.getGlobal();

    private CustomRuleLoader() {
    }

    static Class<?> compileAndLoad(CustomRule rule, String workingPackage, File rulesDirectory, File classPath, File tempDirectory) throws TaraException {
        File source = new File(rulesDirectory, rule.getSource() + ".java");
        if (source.exists()) {
            return CustomRuleLoader.compileAndLoadRules(rule, workingPackage, classPath, tempDirectory, source);
        }
        return CustomRuleLoader.tryAsProvided(rule);
    }

    private static Class<?> tryAsProvided(CustomRule rule) {
        try {
            return Class.forName(Url.class.getPackage().getName() + "." + Format.reference().format((Object)rule.getSource()));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class<?> compileAndLoadRules(CustomRule rule, String workingPackage, File classPath, File temp, File source) throws TaraException {
        CustomRuleLoader.compile(source, classPath, temp);
        return CustomRuleLoader.load(rule.getSource(), workingPackage, temp, classPath);
    }

    private static File compile(File source, File classPath, File compilationDirectory) throws TaraException {
        JavaCompiler.compile(source, classPath.getAbsolutePath(), compilationDirectory);
        compilationDirectory.deleteOnExit();
        return compilationDirectory;
    }

    public static Class<?> load(String source, String workingPackage, File baseDirectory, File classPath) {
        return AccessController.doPrivileged(() -> {
            try {
                URL url = baseDirectory.toURI().toURL();
                URL[] urls = new URL[]{url, classPath.toURI().toURL()};
                URLClassLoader cl = new URLClassLoader(urls);
                return cl.loadClass(CustomRuleLoader.composeQualifiedName(workingPackage, source));
            }
            catch (ClassNotFoundException | MalformedURLException e) {
                LOG.log(Level.SEVERE, "Error loading class " + source + " in " + baseDirectory.getAbsolutePath());
                return null;
            }
        });
    }

    private static String composeQualifiedName(String generatedDslName, String aClass) {
        return generatedDslName.toLowerCase() + ".rules." + aClass;
    }
}

