/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.core.operation.setup;

import io.intino.legio.Legio;
import io.intino.legio.Project;
import io.intino.tara.compiler.core.CompilationUnit;
import io.intino.tara.compiler.core.CompilerConfiguration;
import io.intino.tara.compiler.core.errorcollection.CompilationFailedException;
import io.intino.tara.compiler.core.errorcollection.TaraException;
import io.intino.tara.compiler.core.errorcollection.message.Message;
import io.intino.tara.compiler.core.operation.setup.SetupOperation;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.io.Stash;
import io.intino.tara.io.StashDeserializer;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.logging.Logger;

public class SetupConfigurationOperation
extends SetupOperation {
    private static final Logger LOG = Logger.getGlobal();
    private final CompilerConfiguration configuration;
    private final CompilationUnit unit;

    public SetupConfigurationOperation(CompilationUnit unit) {
        this.configuration = unit.getConfiguration();
        this.unit = unit;
    }

    @Override
    public void call() throws CompilationFailedException {
        if (this.configuration.isVerbose()) {
            System.out.println("@#$%@# Presentable:Tarac: Setup configuration...");
        }
        try {
            this.readConfiguration();
        }
        catch (TaraException e) {
            LOG.severe("Error during dependency resolution: " + e.getMessage());
            this.unit.getErrorCollector().addError(Message.create(e.getMessage(), this.unit));
        }
    }

    private boolean readConfiguration() throws TaraException {
        try {
            File miscDirectory = this.configuration.getMiscDirectory();
            if (miscDirectory == null || !miscDirectory.exists()) {
                return this.checkConfiguration();
            }
            File file = new File(miscDirectory, this.configuration.getModule() + ".conf");
            if (!file.exists()) {
                return this.checkConfiguration();
            }
            Stash stash = StashDeserializer.stashFrom((File)file);
            Graph graph = Graph.use((Class[])new Class[]{Legio.class, null}).loadStashes(new Stash[]{stash});
            if (graph == null) {
                throw new TaraException("Configuration corrupt or not found");
            }
            Legio legio = (Legio)graph.wrapper(Legio.class);
            if (legio == null) {
                return this.checkConfiguration();
            }
            this.extractConfiguration(legio);
            return this.checkConfiguration();
        }
        catch (Throwable t) {
            throw new TaraException(t.getMessage());
        }
    }

    private boolean checkConfiguration() throws TaraException {
        if (this.configuration.languages().isEmpty()) {
            throw new TaraException("Language not defined or not found:");
        }
        if (this.configuration.languages().get(0).get() == null) {
            throw new TaraException("Language not defined or not found: " + this.configuration.languages().get(0).name() + "-" + this.configuration.languages().get(0).version());
        }
        return true;
    }

    private void extractConfiguration(Legio legio) {
        Project project = legio.project();
        Project.Factory factory = project.factory();
        Configuration.Level level = Configuration.Level.valueOf((String)factory.node().conceptList().stream().filter(c -> c.id().contains("#")).map(c -> c.id().split("#")[0]).findFirst().orElse("Platform"));
        this.configuration.outDSL(project.name());
        this.configuration.workingPackage(factory.inPackage() != null ? factory.inPackage() : project.name().toLowerCase());
        this.configuration.artifactId(project.name().toLowerCase());
        this.configuration.groupId(project.groupId());
        this.configuration.version(project.version());
        if (this.configuration.isTest()) {
            this.configuration.addLanguage(project.name(), project.version());
            this.configuration.level(Configuration.Level.values()[level.ordinal() == 0 ? 0 : level.ordinal() - 1]);
        } else {
            for (Project.Factory.Language language : factory.languageList()) {
                this.configuration.addLanguage(language.name(), language.version());
                this.configuration.level(level);
            }
        }
    }
}

