/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.core.operation.model;

import io.intino.tara.compiler.codegeneration.lang.LanguageSerializer;
import io.intino.tara.compiler.core.CompilationUnit;
import io.intino.tara.compiler.core.errorcollection.CompilationFailedException;
import io.intino.tara.compiler.core.errorcollection.TaraException;
import io.intino.tara.compiler.core.operation.model.ModelCollectionOperation;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.shared.Configuration;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenerateLanguageOperation
extends ModelCollectionOperation {
    private static final Logger LOG = Logger.getGlobal();
    private final CompilationUnit unit;

    public GenerateLanguageOperation(CompilationUnit unit) {
        this.unit = unit;
    }

    @Override
    public void call(Collection<Model> models) {
        try {
            if (this.unit.getConfiguration().level().equals((Object)Configuration.Level.System)) {
                return;
            }
            if (this.unit.getConfiguration().isVerbose()) {
                System.out.println("@#$%@# Presentable:[" + this.unit.getConfiguration().getModule() + " - " + this.unit.getConfiguration().outDSL() + "] Generating language...");
            }
            new LanguageSerializer(this.unit.getConfiguration(), models).write();
            this.unit.getErrorCollector().failIfErrors();
        }
        catch (TaraException e) {
            LOG.log(Level.SEVERE, "Error during language generation: " + e.getMessage() + "\n", e);
            throw new CompilationFailedException(10, this.unit);
        }
    }
}

