/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.core.operation;

import io.intino.tara.Language;
import io.intino.tara.compiler.codegeneration.Format;
import io.intino.tara.compiler.codegeneration.magritte.stash.StashCreator;
import io.intino.tara.compiler.core.CompilationUnit;
import io.intino.tara.compiler.core.CompilerConfiguration;
import io.intino.tara.compiler.core.errorcollection.CompilationFailedException;
import io.intino.tara.compiler.core.errorcollection.TaraException;
import io.intino.tara.compiler.core.operation.model.ModelOperation;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.io.Stash;
import io.intino.tara.io.StashSerializer;
import io.intino.tara.lang.model.Node;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class StashGenerationOperation
extends ModelOperation {
    private static final Logger LOG = Logger.getLogger(StashGenerationOperation.class.getName());
    private static final String STASH = ".stash";
    private final CompilationUnit compilationUnit;
    private final CompilerConfiguration conf;
    private String outDSL;

    public StashGenerationOperation(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
        this.conf = compilationUnit.getConfiguration();
    }

    @Override
    public void call(Model model) {
        this.outDSL = this.conf.level().equals((Object)Configuration.Level.System) ? this.conf.getModule() : this.conf.outDSL();
        try {
            if (this.conf.isVerbose()) {
                System.out.println("@#$%@# Presentable:[" + this.conf.getModule() + " - " + this.conf.outDSL() + "] Generating Stashes...");
            }
            if (this.conf.isTest()) {
                this.createTestStashes(model);
            } else {
                this.createStash(model);
            }
        }
        catch (TaraException e) {
            LOG.log(Level.SEVERE, "Error during stash generation: " + e.getMessage(), e);
            throw new CompilationFailedException(this.compilationUnit.getPhase(), this.compilationUnit, e);
        }
    }

    private void createTestStashes(Model model) throws TaraException {
        for (List<Node> nodes : this.pack(model)) {
            if (nodes.isEmpty()) continue;
            this.writeStashTo(this.stashDestiny(new File(nodes.get(0).file())), this.stashOf(nodes, model.getLanguage()));
        }
    }

    private void createStash(Model model) throws TaraException {
        if (model.components().isEmpty()) {
            return;
        }
        this.writeStashTo(this.stashDestiny(new File(model.components().get(0).file())), this.stashOf(model.components(), model.getLanguage()));
    }

    private Stash stashOf(List<Node> nodes, Language language) throws TaraException {
        return new StashCreator(nodes, language, this.outDSL, this.conf).create();
    }

    private String writeStashTo(File taraFile, Stash stash) {
        byte[] content = StashSerializer.serialize((Stash)stash);
        File file = this.stashDestiny(taraFile);
        file.getParentFile().mkdirs();
        try (FileOutputStream stream = new FileOutputStream(file);){
            stream.write(content);
            stream.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error writing stashes: " + e.getMessage(), e);
            throw new CompilationFailedException(this.compilationUnit.getPhase(), this.compilationUnit, e);
        }
        return file.getPath();
    }

    private File stashDestiny(File taraFile) {
        File destiny = this.conf.resourcesDirectory();
        destiny.mkdirs();
        return !this.conf.isTest() ? new File(destiny, Format.firstUpperCase().format((Object)(this.conf.level().equals((Object)Configuration.Level.System) ? "Model" : this.conf.outDSL())).toString() + STASH) : new File(destiny, taraFile.getName().split("\\.")[0] + STASH);
    }

    private List<List<Node>> pack(Model model) {
        HashMap<String, List<Node>> nodes = new HashMap<String, List<Node>>();
        for (Node node : model.components()) {
            if (!nodes.containsKey(node.file())) {
                nodes.put(node.file(), new ArrayList());
            }
            ((List)nodes.get(node.file())).add(node);
        }
        return this.pack(nodes);
    }

    private List<List<Node>> pack(Map<String, List<Node>> nodes) {
        return nodes.values().stream().collect(Collectors.toList());
    }
}

