/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.core;

import io.intino.tara.compiler.core.CompilerConfiguration;
import io.intino.tara.compiler.core.FileReaderSource;
import io.intino.tara.compiler.core.ProcessingUnit;
import io.intino.tara.compiler.core.errorcollection.ErrorCollector;
import io.intino.tara.compiler.core.errorcollection.TaraException;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.parser.Parser;
import java.io.File;
import java.io.IOException;

public class SourceUnit
extends ProcessingUnit {
    protected FileReaderSource source;
    protected String name;
    private Model model;
    private Parser parser;
    private final boolean dirty;

    public SourceUnit(String name, FileReaderSource source, CompilerConfiguration configuration, ErrorCollector er, boolean dirty) {
        super(configuration, er);
        this.configuration = configuration;
        this.errorCollector = er;
        this.name = name;
        this.source = source;
        this.dirty = dirty;
    }

    public SourceUnit(File source, CompilerConfiguration configuration, ErrorCollector er, boolean dirty) {
        this(source.getPath(), new FileReaderSource(source, configuration), configuration, er, dirty);
    }

    public String getName() {
        return this.name;
    }

    public FileReaderSource getSource() {
        return this.source;
    }

    public Model getModel() {
        return this.model;
    }

    public void parse() throws TaraException {
        if (this.parser == null) {
            try {
                this.parser = new Parser(this.source.getFile(), this.configuration.languages(), this.configuration.sourceEncoding(), this.configuration.outDSL());
                this.parser.parse();
            }
            catch (IOException e) {
                throw new TaraException("Error opening source " + this.source.getFile().getName(), e);
            }
        }
    }

    public void importData() throws TaraException {
        this.model = this.parser.convert();
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

