/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.core;

import io.intino.tara.compiler.core.AbstractReaderSource;
import io.intino.tara.compiler.core.CompilerConfiguration;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

class FileReaderSource
extends AbstractReaderSource {
    private static final Logger LOG = Logger.getGlobal();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private File file;

    FileReaderSource(File file, CompilerConfiguration configuration) {
        super(configuration);
        this.file = file;
    }

    @Override
    public Reader getReader() throws IOException {
        Charset cs = Charset.forName(this.configuration.sourceEncoding());
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
        if (UTF8.name().equalsIgnoreCase(cs.name())) {
            ((InputStream)in).mark(3);
            boolean hasBOM = true;
            try {
                int i = ((InputStream)in).read();
                hasBOM &= i == 239;
                i = ((InputStream)in).read();
                hasBOM &= i == 187;
                i = ((InputStream)in).read();
                hasBOM &= i == 255;
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                hasBOM = false;
            }
            if (!hasBOM) {
                ((InputStream)in).reset();
            }
        }
        return new InputStreamReader((InputStream)in, cs);
    }

    public File getFile() {
        return this.file;
    }
}

