/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.magritte.stash;

import io.intino.tara.lang.model.Facet;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.semantics.Constraint;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

class StashHelper {
    private static final String BLOB_KEY = "%";

    StashHelper() {
    }

    static List<String> collectTypes(Node node) {
        ArrayList<String> types = new ArrayList<String>();
        types.add(StashHelper.withDollarAndHashtag(node.type()));
        LinkedHashSet facetTypes = node.facets().stream().map(Facet::type).collect(Collectors.toCollection(LinkedHashSet::new));
        types.addAll(facetTypes.stream().map(type -> StashHelper.withDollarAndHashtag(type + "#" + node.type())).collect(Collectors.toList()));
        return types;
    }

    static List<String> collectTypes(FacetTarget target, List<Constraint> constraints) {
        Constraint constraint = constraints.stream().filter(c -> c instanceof Constraint.MetaFacet).findFirst().orElse(null);
        LinkedHashSet<String> facetTypes = new LinkedHashSet<String>();
        facetTypes.add((target.owner().type() + (constraint instanceof Constraint.MetaFacet || constraint == null ? "" : target.targetNode().simpleType())).replace(":", "#"));
        facetTypes.addAll(target.owner().facets().stream().map(f -> f.type() + "#" + StashHelper.shortType(target)).collect(Collectors.toCollection(LinkedHashSet::new)));
        return new ArrayList<String>(facetTypes);
    }

    private static String shortType(FacetTarget target) {
        String type = target.owner().type();
        return type.contains(":") ? type.substring(0, type.indexOf(":")) : type;
    }

    static boolean hasToBeConverted(List<Object> values, Primitive type) {
        return values.get(0) instanceof String && !type.equals((Object)Primitive.STRING) || type.equals((Object)Primitive.WORD) || type.equals((Object)Primitive.INSTANT) || type.equals((Object)Primitive.RESOURCE);
    }

    static List<Object> buildResourceValue(List<Object> values, String filePath) {
        return new ArrayList<Object>(values.stream().map(v -> BLOB_KEY + StashHelper.getPresentableName(new File(filePath).getName()) + v.toString()).collect(Collectors.toList()));
    }

    private static String getPresentableName(String name) {
        return name.substring(0, name.lastIndexOf("."));
    }

    static String buildInstanceReference(Object o) {
        if (o instanceof Primitive.Reference) {
            Primitive.Reference reference = (Primitive.Reference)o;
            return reference.path() + "#" + StashHelper.withDollarAndHashtag(reference.get());
        }
        return "";
    }

    private static String withDollarAndHashtag(String name) {
        return name.replace(".", "$").replace(":", "#");
    }
}

