/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.magritte.stash;

import io.intino.tara.Language;
import io.intino.tara.compiler.codegeneration.Format;
import io.intino.tara.compiler.codegeneration.magritte.NameFormatter;
import io.intino.tara.compiler.codegeneration.magritte.natives.NativeFormatter;
import io.intino.tara.compiler.codegeneration.magritte.stash.StashHelper;
import io.intino.tara.compiler.codegeneration.magritte.stash.VariableFactory;
import io.intino.tara.compiler.core.CompilerConfiguration;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.io.Concept;
import io.intino.tara.io.Helper;
import io.intino.tara.io.Node;
import io.intino.tara.io.Stash;
import io.intino.tara.lang.model.EmptyNode;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Parameter;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Valued;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.variable.NativeRule;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class StashCreator {
    private final List<io.intino.tara.lang.model.Node> nodes;
    private final Language language;
    private final File resourceFolder;
    private final Configuration.Level level;
    private final boolean test;
    private final Stash stash = new Stash();
    private final String generatedLanguage;
    private final String workingPackage;

    public StashCreator(List<io.intino.tara.lang.model.Node> nodes, Language language, String genLanguage, CompilerConfiguration conf) {
        this.nodes = nodes;
        this.language = language;
        this.generatedLanguage = Format.javaValidName().format((Object)genLanguage).toString();
        this.workingPackage = conf.workingPackage();
        this.resourceFolder = conf.resourcesDirectory();
        this.level = conf.level();
        this.test = conf.isTest();
        this.stash.language = language.languageName();
    }

    public Stash create() {
        this.nodes.forEach(node -> this.create((io.intino.tara.lang.model.Node)node, null));
        this.stash.contentRules = this.collectContents(this.nodes.stream().filter(node -> !node.is(Tag.Component) && !node.isFacet() && !node.is(Tag.Instance)).collect(Collectors.toList()));
        return this.stash;
    }

    private void create(io.intino.tara.lang.model.Node node, Concept container) {
        if (!node.isReference()) {
            this.asNode(node, container);
        }
    }

    private void asNode(io.intino.tara.lang.model.Node node, Concept container) {
        if (node.is(Tag.Instance)) {
            if (container == null) {
                this.stash.nodes.add(this.createInstance(node));
            } else {
                container.nodes.add(this.createInstance(node));
            }
        } else {
            this.createConcept(node);
        }
    }

    private void createConcept(io.intino.tara.lang.model.Node node) {
        if (node.facetTarget() != null) {
            this.stash.concepts.addAll(this.create(node.facetTarget(), node));
        } else {
            List<io.intino.tara.lang.model.Node> nodeList = this.collectTypeComponents(node.components());
            Concept concept = Helper.newConcept((String)this.name(node), (node.isAbstract() || node.isFacet() ? 1 : 0) != 0, (boolean)node.type().equals("MetaConcept"), (node.container() instanceof Model && !node.is(Tag.Component) ? 1 : 0) != 0, (String)(node.name() != null && !node.name().isEmpty() ? NameFormatter.stashQn(node, this.workingPackage).replace("#", "") : null), (String)(node.parentName() != null ? Format.qualifiedName().format((Object)node.parent().cleanQn()).toString() : null), StashHelper.collectTypes(node), this.collectContents(nodeList), this.variablesOf(node), this.parametersOf(node), Collections.emptyList());
            this.stash.concepts.add(concept);
            for (io.intino.tara.lang.model.Node component : node.components()) {
                this.create(component, concept);
            }
        }
    }

    private List<Concept> create(FacetTarget facetTarget, io.intino.tara.lang.model.Node owner) {
        List<io.intino.tara.lang.model.Node> components = this.collectTypeComponents(owner.components());
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        Concept concept = new Concept();
        concepts.add(concept);
        concept.isMetaConcept = owner.type().equals("MetaConcept");
        concept.isAbstract = owner.isAbstract();
        concept.name = this.name(owner);
        concept.className = NameFormatter.getQn(facetTarget, owner, this.workingPackage);
        concept.types = StashHelper.collectTypes(facetTarget, this.language.constraints(owner.type()));
        concept.parent = this.calculateParent(facetTarget);
        concept.contentRules = this.collectContents(components);
        concept.variables = this.variablesOf(owner);
        concept.parameters = this.parametersOf(owner);
        for (io.intino.tara.lang.model.Node component : owner.components()) {
            this.create(component, concept);
        }
        concepts.addAll(this.collectChildren(facetTarget.targetNode()).stream().map(node -> this.createChildFacetType(facetTarget, (io.intino.tara.lang.model.Node)node, concept)).collect(Collectors.toList()));
        return concepts;
    }

    private String name(io.intino.tara.lang.model.Node owner) {
        return Format.withDollar().format(Format.noPackage().format((Object)NameFormatter.stashQn(owner, this.workingPackage))).toString();
    }

    private List<io.intino.tara.lang.model.Node> collectChildren(io.intino.tara.lang.model.Node parent) {
        HashSet<io.intino.tara.lang.model.Node> set = new HashSet<io.intino.tara.lang.model.Node>();
        for (io.intino.tara.lang.model.Node child : parent.children()) {
            set.add(child);
            set.addAll(this.collectChildren(child));
        }
        return new ArrayList<io.intino.tara.lang.model.Node>(set);
    }

    private String calculateParent(FacetTarget facetTarget) {
        if (facetTarget.parent() != null) {
            return facetTarget.parent().cleanQn();
        }
        if (facetTarget.owner().parent() != null) {
            return facetTarget.owner().parent().cleanQn();
        }
        return null;
    }

    private Concept createChildFacetType(FacetTarget facetTarget, io.intino.tara.lang.model.Node node, Concept parent) {
        Concept child = new Concept();
        child.name = facetTarget.owner().name() + "#" + this.name(node);
        child.parent = parent.name;
        child.isAbstract = facetTarget.owner().isAbstract();
        child.className = NameFormatter.getQn(facetTarget, facetTarget.owner(), this.workingPackage);
        ArrayList<String> childTypes = new ArrayList<String>(parent.types);
        childTypes.add(parent.name);
        child.types = new ArrayList(childTypes);
        child.contentRules = parent.contentRules;
        return child;
    }

    private List<io.intino.tara.lang.model.Node> collectTypeComponents(List<io.intino.tara.lang.model.Node> nodes) {
        return nodes.stream().filter(component -> !component.is(Tag.Instance)).collect(Collectors.toList());
    }

    private List<Concept.Content> collectContents(List<io.intino.tara.lang.model.Node> nodes) {
        return nodes.stream().filter(node -> !node.isFacet() && !node.is(Tag.Instance)).map(n -> new Concept.Content(n.isReference() ? n.destinyOfReference().cleanQn() : n.cleanQn(), n.container().sizeOf(n).min(), n.container().sizeOf(n).max())).collect(Collectors.toList());
    }

    private List<Node> createInstances(List<io.intino.tara.lang.model.Node> nodes) {
        return nodes.stream().map(this::createInstance).collect(Collectors.toList());
    }

    private Node createInstance(io.intino.tara.lang.model.Node node) {
        Node instanceNode = new Node();
        instanceNode.name = this.buildReferenceName(node);
        instanceNode.facets = StashHelper.collectTypes(node);
        instanceNode.variables.addAll(this.parametersOf(node));
        instanceNode.nodes.addAll(this.createInstances(node.components()));
        return instanceNode;
    }

    private boolean isNotEmpty(Valued v) {
        return !v.values().isEmpty() && v.values().get(0) != null && !(v.values().get(0) instanceof EmptyNode);
    }

    private List<io.intino.tara.io.Variable> variablesOf(io.intino.tara.lang.model.Node node) {
        ArrayList<io.intino.tara.io.Variable> variables = new ArrayList<io.intino.tara.io.Variable>();
        variables.addAll(node.variables().stream().filter(v -> this.isNotEmpty((Valued)v) && !v.isInherited()).map(this::transformTaraVariableToStashVariable).collect(Collectors.toList()));
        return variables;
    }

    private List<io.intino.tara.io.Variable> parametersOf(io.intino.tara.lang.model.Node node) {
        return node.parameters().stream().filter(this::isNotEmpty).map(this::createVariableFromParameter).collect(Collectors.toList());
    }

    private io.intino.tara.io.Variable transformTaraVariableToStashVariable(Variable modelVariable) {
        io.intino.tara.io.Variable variable = VariableFactory.get(modelVariable.type());
        if (variable == null) {
            return null;
        }
        variable.name = modelVariable.name();
        variable.values = modelVariable.isReference() && !(modelVariable.values().get(0) instanceof Primitive.Expression) ? this.buildReferenceValues(modelVariable.values()) : (modelVariable.values().get(0) instanceof Primitive.Expression ? this.createNativeReference(modelVariable) : (modelVariable.values().get(0).toString().startsWith("$") ? StashHelper.buildResourceValue(modelVariable.values(), modelVariable.file()) : this.getValue(modelVariable)));
        return variable;
    }

    private io.intino.tara.io.Variable createVariableFromParameter(Parameter parameter) {
        io.intino.tara.io.Variable variable = VariableFactory.get(parameter.type());
        if (variable == null) {
            return null;
        }
        variable.name = parameter.name();
        variable.values = parameter.hasReferenceValue() ? this.buildReferenceValues(parameter.values()) : (parameter.values().get(0) instanceof Primitive.Expression ? this.createNativeReference(parameter) : (parameter.values().get(0).toString().startsWith("$") ? StashHelper.buildResourceValue(parameter.values(), parameter.file()) : this.getValue(parameter)));
        return variable;
    }

    private List<Object> createNativeReference(Variable variable) {
        String aPackage = NativeFormatter.calculatePackage(variable.container());
        return new ArrayList<Object>(Collections.singletonList(this.reactivePrefix((Valued)variable) + this.workingPackage.toLowerCase() + ".natives." + (aPackage.isEmpty() ? "" : aPackage + ".") + Format.javaValidName().format((Object)variable.name()).toString() + "_" + variable.getUID()));
    }

    private List<Object> createNativeReference(Parameter parameter) {
        String aPackage = NativeFormatter.calculatePackage(parameter.container());
        return new ArrayList<Object>(Collections.singletonList(this.reactivePrefix((Valued)parameter) + this.workingPackage.toLowerCase() + ".natives." + (aPackage.isEmpty() ? "" : aPackage + ".") + Format.javaValidName().format((Object)parameter.name()).toString() + "_" + parameter.getUID()));
    }

    private String reactivePrefix(Valued variable) {
        return variable.type().equals((Object)Primitive.FUNCTION) || variable.flags().contains(Tag.Reactive) ? "" : "$@";
    }

    private List<Object> getValue(Variable variable) {
        if (variable.values().get(0) instanceof EmptyNode) {
            return new ArrayList<Object>();
        }
        return new ArrayList<Object>(StashHelper.hasToBeConverted(variable.values(), variable.type()) ? this.convert((Valued)variable) : (variable.rule() instanceof NativeRule ? this.formatNativeReferenceOfVariable(variable.values()) : variable.values()));
    }

    private List<Object> formatNativeReferenceOfVariable(List<Object> values) {
        return values.stream().map(value -> "$@" + value.toString()).collect(Collectors.toList());
    }

    private List<Object> getValue(Parameter parameter) {
        if (parameter.values().get(0) instanceof EmptyNode) {
            return new ArrayList<Object>();
        }
        return new ArrayList<Object>(StashHelper.hasToBeConverted(parameter.values(), parameter.type()) ? this.convert((Valued)parameter) : parameter.values());
    }

    private List<?> convert(Valued valued) {
        Primitive type = valued.type();
        if (type.equals((Object)Primitive.WORD)) {
            return Primitive.WORD.convert(valued.values().toArray());
        }
        if (type.equals((Object)Primitive.INSTANT)) {
            return Primitive.INSTANT.convert(valued.values().toArray(new String[valued.values().size()]));
        }
        if (type.equals((Object)Primitive.RESOURCE)) {
            return valued.values().stream().map(o -> StashCreator.toSystemIndependentName(((File)o).getAbsolutePath()).substring(StashCreator.toSystemIndependentName(this.resourceFolder.getAbsolutePath()).length() + 1)).collect(Collectors.toList());
        }
        return type.convert(valued.values().toArray(new String[valued.values().size()]));
    }

    private List<Object> buildReferenceValues(List<Object> values) {
        if (values.get(0) instanceof EmptyNode) {
            return new ArrayList<Object>();
        }
        return new ArrayList<Object>(values.stream().map(this::buildReferenceName).collect(Collectors.toList()));
    }

    private String buildReferenceName(Object o) {
        return o instanceof io.intino.tara.lang.model.Node ? (((io.intino.tara.lang.model.Node)o).is(Tag.Instance) ? this.getStash((io.intino.tara.lang.model.Node)o) + "#" : "") + ((io.intino.tara.lang.model.Node)o).cleanQn() : StashHelper.buildInstanceReference(o);
    }

    private static String toSystemIndependentName(String fileName) {
        return fileName.replace('\\', '/');
    }

    private String getStash(io.intino.tara.lang.model.Node node) {
        return this.test ? this.getTestStash(node) : this.getDefaultStashName();
    }

    private String getTestStash(io.intino.tara.lang.model.Node node) {
        String file = new File(node.file()).getName();
        return file.substring(0, file.lastIndexOf("."));
    }

    private String getDefaultStashName() {
        return this.level.compareLevelWith(Configuration.Level.System) == 0 ? "Model" : this.generatedLanguage;
    }
}

