/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.magritte.natives;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.intino.tara.Language;
import io.intino.tara.Resolver;
import io.intino.tara.compiler.codegeneration.Format;
import io.intino.tara.compiler.codegeneration.magritte.NameFormatter;
import io.intino.tara.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.compiler.codegeneration.magritte.natives.NativeExtractor;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.VariableReference;
import io.intino.tara.lang.model.Facet;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.NodeContainer;
import io.intino.tara.lang.model.NodeRoot;
import io.intino.tara.lang.model.Parameter;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Valued;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.variable.NativeObjectRule;
import io.intino.tara.lang.model.rules.variable.NativeRule;
import io.intino.tara.lang.semantics.Constraint;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class NativeFormatter
implements TemplateTags {
    private final String outDsl;
    private final Language language;
    private final String aPackage;
    private final String workingPackage;
    private String languageWorkingPackage;
    private final boolean system;
    private final Map<String, Set<String>> imports;

    public NativeFormatter(Language language, String outDsl, String aPackage, String workingPackage, String languageWorkingPackage, boolean system, File importsFile) {
        this.outDsl = outDsl;
        this.language = language;
        this.aPackage = aPackage;
        this.workingPackage = workingPackage;
        this.languageWorkingPackage = languageWorkingPackage;
        this.system = system;
        this.imports = this.load(importsFile);
    }

    private Map<String, Set<String>> load(File importsFile) {
        if (importsFile == null) {
            return new HashMap<String, Set<String>>();
        }
        try {
            return (Map)new Gson().fromJson((Reader)new FileReader(importsFile), new TypeToken<Map<String, Set<String>>>(){}.getType());
        }
        catch (FileNotFoundException e) {
            return new HashMap<String, Set<String>>();
        }
    }

    public void fillFrameForFunctionVariable(Frame frame, Variable variable, Object body) {
        List<String> slots = Arrays.asList(frame.slots());
        String signature = NativeFormatter.getSignature(variable);
        frame.addFrame("package", new String[]{this.aPackage});
        HashSet<String> imports = new HashSet<String>(((NativeRule)variable.rule()).imports());
        imports.addAll(this.collectImports((Valued)variable));
        frame.addFrame("imports", imports.toArray(new String[imports.size()]));
        if (!slots.contains("scope".toLowerCase())) {
            frame.addFrame("scope", new String[]{this.workingPackage});
        }
        if (!slots.contains("generatedLanguage".toLowerCase())) {
            frame.addFrame("generatedLanguage", new String[]{this.outDsl.toLowerCase()});
        }
        if (!slots.contains("workingPackage".toLowerCase())) {
            frame.addFrame("workingPackage", new String[]{this.workingPackage.toLowerCase()});
        }
        if (!slots.contains("rule".toLowerCase())) {
            frame.addFrame("rule", new String[]{NameFormatter.cleanQn(NativeFormatter.getInterface(variable))});
        }
        if (!slots.contains("name".toLowerCase())) {
            frame.addFrame("name", new String[]{variable.name()});
        }
        if (!slots.contains("qn".toLowerCase())) {
            frame.addFrame("qn", new String[]{variable.container().qualifiedName()});
        }
        frame.addFrame("file", new String[]{variable.file()});
        frame.addFrame("line", new Integer[]{variable.line()});
        frame.addFrame("column", new Integer[]{variable.column()});
        if (body != null) {
            frame.addFrame("body", new String[]{NativeFormatter.formatBody(body.toString(), signature)});
        }
        frame.addFrame("nativeContainer", new String[]{NameFormatter.cleanQn(NativeFormatter.buildContainerPath(variable.scope(), variable.container(), this.workingPackage))});
        frame.addFrame("signature", new String[]{signature});
        frame.addFrame("uid", new String[]{variable.getUID()});
        NativeExtractor extractor = new NativeExtractor(signature);
        frame.addFrame("methodName", new String[]{extractor.methodName()});
        frame.addFrame("parameters", new String[]{extractor.parameters()});
        frame.addFrame("returnType", new String[]{extractor.returnValue()});
    }

    public void fillFrameForFunctionParameter(Frame frame, Parameter parameter, Object body) {
        List<String> slots = Arrays.asList(frame.slots());
        String signature = NativeFormatter.getSignature(parameter);
        if (!slots.contains("generatedLanguage".toLowerCase())) {
            frame.addFrame("generatedLanguage", new String[]{this.outDsl});
        }
        if (!slots.contains("name".toLowerCase())) {
            frame.addFrame("name", new String[]{parameter.name()});
        }
        if (!this.aPackage.isEmpty()) {
            frame.addFrame("package", new String[]{this.aPackage.toLowerCase()});
        }
        if (!slots.contains("qn".toLowerCase())) {
            frame.addFrame("qn", new String[]{parameter.container().qualifiedName()});
        }
        if (!slots.contains("scope".toLowerCase())) {
            frame.addFrame("scope", new String[]{NativeFormatter.workingPackageScope((Valued)parameter, this.workingPackage)});
        }
        if (!slots.contains("workingPackage".toLowerCase())) {
            frame.addFrame("workingPackage", new String[]{this.workingPackage.toLowerCase()});
        }
        if (!slots.contains("rule".toLowerCase())) {
            frame.addFrame("rule", new String[]{NameFormatter.cleanQn(NativeFormatter.getInterface(parameter))});
        }
        HashSet<String> imports = new HashSet<String>(((NativeRule)parameter.rule()).imports());
        imports.addAll(this.collectImports((Valued)parameter));
        frame.addFrame("imports", imports.toArray(new String[imports.size()]));
        frame.addFrame("signature", new String[]{signature});
        frame.addFrame("file", new String[]{parameter.file()});
        frame.addFrame("line", new Integer[]{parameter.line()});
        frame.addFrame("column", new Integer[]{parameter.column()});
        frame.addFrame("nativeContainer", new String[]{NameFormatter.cleanQn(NativeFormatter.buildContainerPath(parameter.scope(), parameter.container(), this.workingPackage))});
        frame.addFrame("uid", new String[]{parameter.getUID()});
        NativeExtractor extractor = new NativeExtractor(signature);
        frame.addFrame("methodName", new String[]{extractor.methodName()});
        frame.addFrame("parameters", new String[]{extractor.parameters()});
        if (body != null) {
            frame.addFrame("body", new String[]{NativeFormatter.formatBody(body.toString(), signature)});
        }
        frame.addFrame("returnType", new String[]{extractor.returnValue()});
    }

    public void fillFrameNativeVariable(Frame frame, Variable variable, Object body) {
        List<String> slots = Arrays.asList(frame.slots());
        frame.addTypes(new String[]{"native"});
        frame.addFrame("file", new String[]{variable.file()});
        frame.addFrame("line", new Integer[]{variable.line()});
        frame.addFrame("column", new Integer[]{variable.column()});
        HashSet<String> imports = new HashSet<String>(variable.rule() != null ? ((NativeRule)variable.rule()).imports() : new HashSet());
        imports.addAll(this.collectImports((Valued)variable));
        frame.addFrame("imports", imports.toArray(new String[imports.size()]));
        if (!this.aPackage.isEmpty()) {
            frame.addFrame("package", new String[]{this.aPackage.toLowerCase()});
        }
        if (!slots.contains("name".toLowerCase())) {
            frame.addFrame("name", new String[]{variable.name()});
        }
        if (!slots.contains("generatedLanguage".toLowerCase())) {
            frame.addFrame("generatedLanguage", new String[]{this.outDsl});
        }
        if (!slots.contains("workingPackage".toLowerCase())) {
            frame.addFrame("workingPackage", new String[]{this.workingPackage.toLowerCase()});
        }
        frame.addFrame("nativeContainer".toLowerCase(), new String[]{this.buildContainerPathOfExpression((Valued)variable)});
        if (!slots.contains("type".toLowerCase())) {
            frame.addFrame("type", new AbstractFrame[]{this.typeFrame(this.type(variable), variable.isMultiple())});
        }
        frame.addFrame("uid", new String[]{variable.getUID()});
        if (body != null) {
            frame.addFrame("body", new String[]{NativeFormatter.formatBody(body.toString(), variable.type().getName())});
        }
    }

    public void fillFrameNativeParameter(Frame frame, Parameter parameter, String body) {
        List<String> slots = Arrays.asList(frame.slots());
        frame.addTypes(new String[]{"native"});
        frame.addFrame("file", new String[]{parameter.file()});
        frame.addFrame("line", new Integer[]{parameter.line()});
        frame.addFrame("column", new Integer[]{parameter.column()});
        HashSet<String> imports = new HashSet<String>(parameter.rule() != null ? ((NativeRule)parameter.rule()).imports() : new HashSet());
        imports.addAll(this.collectImports((Valued)parameter));
        frame.addFrame("imports", imports.toArray(new String[imports.size()]));
        frame.addFrame("nativeContainer", new String[]{this.buildContainerPathOfExpression((Valued)parameter)});
        frame.addFrame("uid", new String[]{parameter.getUID()});
        if (!this.aPackage.isEmpty()) {
            frame.addFrame("package", new String[]{this.aPackage.toLowerCase()});
        }
        if (!slots.contains("name".toLowerCase())) {
            frame.addFrame("name", new String[]{parameter.name()});
        }
        if (!slots.contains("generatedLanguage".toLowerCase())) {
            frame.addFrame("generatedLanguage", new String[]{this.outDsl.toLowerCase()});
        }
        if (!slots.contains("workingPackage".toLowerCase())) {
            frame.addFrame("workingPackage", new String[]{this.workingPackage.toLowerCase()});
        }
        if (!slots.contains("type".toLowerCase())) {
            frame.addFrame("type", new AbstractFrame[]{this.typeFrame(this.type(parameter), this.isMultiple(parameter))});
        }
        if (body != null) {
            frame.addFrame("body", new String[]{NativeFormatter.formatBody(body, parameter.type().getName())});
        }
    }

    public String type(Variable variable) {
        boolean multiple = variable.isMultiple();
        if (variable.isReference()) {
            return NameFormatter.getQn(((VariableReference)variable).destinyOfReference(), this.workingPackage);
        }
        if (Primitive.OBJECT.equals((Object)variable.type())) {
            return ((NativeObjectRule)variable.rule()).type();
        }
        if (Primitive.WORD.equals((Object)variable.type())) {
            return NameFormatter.getQn(variable.container(), this.workingPackage) + "." + Format.firstUpperCase().format((Object)variable.name());
        }
        return variable.type().javaName();
    }

    private boolean isMultiple(Parameter parameter) {
        Constraint.Parameter constraint = this.parameterConstraintOf(parameter);
        return constraint != null && !constraint.size().isSingle();
    }

    public String type(Parameter parameter) {
        boolean multiple = parameter.isMultiple();
        return parameter.type().equals((Object)Primitive.OBJECT) ? ((NativeObjectRule)parameter.rule()).type() : parameter.type().javaName();
    }

    private Frame typeFrame(String type, boolean multiple) {
        return multiple ? new Frame().addTypes(new String[]{"type", "list"}).addFrame("value", new String[]{type}) : new Frame().addTypes(new String[]{"type"}).addFrame("value", new String[]{type});
    }

    private List<String> collectImports(Valued parameter) {
        String qn = (parameter.container().qualifiedName() + "." + parameter.name()).replace(":", "");
        return this.imports.containsKey(qn) ? new ArrayList(this.imports.get(qn)) : Collections.emptyList();
    }

    public static String workingPackageScope(Valued valued, String workingPackage) {
        return valued.scope() != null && !valued.scope().isEmpty() ? valued.scope() : workingPackage;
    }

    private static String getQn(Node owner, String language, boolean m0) {
        return NativeFormatter.asNode(owner, language, m0, null);
    }

    private static String getQn(Facet facet, String language, boolean m0) {
        return NativeFormatter.asFacet(facet, language);
    }

    private static String asFacet(Facet facet, String language) {
        return null;
    }

    private static String getQn(Node owner, Node node, String language, boolean m0) {
        FacetTarget facetTarget = NativeFormatter.isInFacetTarget(node);
        if (owner.isFacet() && facetTarget != null) {
            return NativeFormatter.asFacetTarget(owner, language, facetTarget);
        }
        return NativeFormatter.asNode(owner, language, m0, facetTarget);
    }

    private static String asNode(Node node, String language, boolean m0, FacetTarget facetTarget) {
        return !m0 ? language.toLowerCase() + "." + (facetTarget == null ? node.qualifiedName() : NameFormatter.composeInFacetTargetQN(node, facetTarget)) : language.toLowerCase() + "." + node.type();
    }

    private static String asFacetTarget(Node owner, String language, FacetTarget facetTarget) {
        return language.toLowerCase() + "." + owner.name().toLowerCase() + "." + Format.reference().format((Object)owner.name()) + Format.reference().format((Object)facetTarget.target());
    }

    public static String getSignature(Parameter parameter) {
        return ((NativeRule)parameter.rule()).signature();
    }

    public static String getInterface(Parameter parameter) {
        NativeRule rule = (NativeRule)parameter.rule();
        if (rule.interfaceClass() == null) {
            return "";
        }
        return rule.interfaceClass();
    }

    public static String getInterface(Variable variable) {
        NativeRule rule = (NativeRule)variable.rule();
        if (rule.interfaceClass() == null) {
            return "";
        }
        return rule.interfaceClass();
    }

    public String buildContainerPathOfExpression(Valued valued) {
        return NativeFormatter.buildExpressionContainerPath(valued.scope(), valued.container(), this.outDsl, this.system ? this.languageWorkingPackage : this.workingPackage);
    }

    public static String formatBody(String body, String signature) {
        String formattedBody;
        String returnText = "return ";
        String string = formattedBody = body.endsWith(";") || body.endsWith("}") ? body : body + ";";
        if (!(signature.contains(" void ") || formattedBody.contains("\n") || formattedBody.startsWith("return "))) {
            return "return " + formattedBody;
        }
        return formattedBody;
    }

    public static String getReturn(String body) {
        String returnText = "return ";
        String string = body = body.endsWith(";") || body.endsWith("}") ? body : body + ";";
        if (!body.contains("\n") && !body.startsWith("return ")) {
            return "return ";
        }
        return "";
    }

    public static String getSignature(Variable variable) {
        return ((NativeRule)variable.rule()).signature();
    }

    public static String buildContainerPath(String scopeLanguage, Node owner, String workingPackage) {
        if (owner instanceof Node && owner.facetTarget() == null) {
            Node scope;
            Node node = scope = owner.is(Tag.Instance) ? NativeFormatter.firstNoFeature((NodeContainer)owner) : NativeFormatter.firstNoFeatureAndNamed((NodeContainer)owner);
            if (scope == null) {
                return "";
            }
            if (scope.is(Tag.Instance)) {
                return NativeFormatter.getTypeAsScope(scope, scopeLanguage);
            }
            if (scope.facetTarget() != null) {
                return NameFormatter.getQn(scope.facetTarget(), scope, workingPackage);
            }
            return NativeFormatter.getQn(scope, owner, workingPackage, false);
        }
        if (owner instanceof Node) {
            return NameFormatter.getQn(owner.facetTarget(), owner, workingPackage);
        }
        if (owner instanceof Facet) {
            Node parent = NativeFormatter.firstNoFeatureAndNamed((NodeContainer)owner);
            if (parent == null) {
                return "";
            }
            return parent.is(Tag.Instance) ? NativeFormatter.getTypeAsScope(parent, scopeLanguage) : NativeFormatter.getQn(parent, workingPackage, false);
        }
        return "";
    }

    public static String buildExpressionContainerPath(String typeWorkingPackage, Node owner, String outDSL, String workingPackage) {
        String trueWorkingPackage = NativeFormatter.extractWorkingPackage(typeWorkingPackage, workingPackage);
        if (owner instanceof Node) {
            Node scope;
            Node node = scope = owner.is(Tag.Instance) ? NativeFormatter.firstNoFeature((NodeContainer)owner) : NativeFormatter.firstNoFeatureAndNamed((NodeContainer)owner);
            if (scope == null) {
                return "";
            }
            if (scope.is(Tag.Instance)) {
                return NativeFormatter.getTypeAsScope(scope, trueWorkingPackage);
            }
            if (scope.facetTarget() != null) {
                return NameFormatter.getQn(scope.facetTarget(), scope, workingPackage);
            }
            return NativeFormatter.getQn(scope, owner, workingPackage, false);
        }
        if (owner instanceof FacetTarget) {
            return NameFormatter.getQn((FacetTarget)owner, workingPackage);
        }
        if (owner instanceof Facet) {
            return owner.container().is(Tag.Instance) ? NativeFormatter.getTypeAsScope(owner, trueWorkingPackage) : NativeFormatter.getQn((Facet)owner, workingPackage, false);
        }
        return "";
    }

    private static String extractWorkingPackage(String scope, String language) {
        return scope != null && !scope.isEmpty() ? scope : language;
    }

    private static String getTypeAsScope(Node scope, String workingPackage) {
        return workingPackage + "." + (scope instanceof Node ? NameFormatter.cleanQn(NativeFormatter.qualifiedType(scope, NativeFormatter.containerFacets(scope))) : NameFormatter.cleanQn(NativeFormatter.facetType((Facet)scope)));
    }

    private static List<Facet> containerFacets(Node scope) {
        Node container;
        for (container = scope.container(); container != null && container.facets().isEmpty(); container = container.container()) {
        }
        return container != null ? container.facets() : Collections.emptyList();
    }

    private static String qualifiedType(Node scope, List<Facet> facets) {
        if (facets.isEmpty()) {
            return scope.type();
        }
        for (Facet facet : facets) {
            if (!scope.type().startsWith(facet.type() + ':') && !scope.type().startsWith("." + facet.type() + ':')) continue;
            return facet.type().toLowerCase() + "." + scope.type();
        }
        return scope.type();
    }

    private static String facetType(Facet scope) {
        return scope.type().toLowerCase() + "." + scope.type() + Resolver.shortType((String)scope.container().type());
    }

    private static Node firstNoFeature(NodeContainer owner) {
        for (NodeContainer container = owner; container != null; container = container.container()) {
            if (!(container instanceof Node) || container instanceof NodeRoot || ((Node)container).is(Tag.Feature)) continue;
            return (Node)container;
        }
        return owner instanceof Node ? (Node)owner : owner.container();
    }

    private static Node firstNoFeatureAndNamed(NodeContainer owner) {
        for (NodeContainer container = owner; container != null; container = container.container()) {
            if (!(container instanceof Node) || container instanceof NodeRoot || ((Node)container).isAnonymous() || ((Node)container).is(Tag.Feature)) continue;
            return (Node)container;
        }
        return owner instanceof Node ? (Node)owner : owner.container();
    }

    private static NodeContainer searchFeatureReference(Node owner) {
        Model model = NativeFormatter.model((NodeContainer)owner);
        if (model == null) {
            return owner;
        }
        NodeContainer nodeContainer = NativeFormatter.searchFeatureReference((NodeContainer)model, owner);
        return nodeContainer != null ? nodeContainer : owner;
    }

    private static NodeContainer searchFeatureReference(NodeContainer node, Node target) {
        if (node instanceof Node && ((Node)node).isReference() && target.equals((Object)((Node)node).destinyOfReference())) {
            return node.container();
        }
        if (node instanceof Node && ((Node)node).isReference()) {
            return null;
        }
        for (Node component : node.components()) {
            NodeContainer nodeContainer = NativeFormatter.searchFeatureReference((NodeContainer)component, target);
            if (nodeContainer == null) continue;
            return nodeContainer;
        }
        return null;
    }

    private static Model model(NodeContainer owner) {
        for (NodeContainer container = owner; container != null; container = container.container()) {
            if (!(container instanceof Node) || !(container instanceof Model)) continue;
            return (Model)container;
        }
        return null;
    }

    private static FacetTarget isInFacetTarget(Node node) {
        Node container;
        for (container = node.container(); container != null && container instanceof Node && container.facetTarget() == null; container = container.container()) {
        }
        return container != null && container instanceof Node ? container.facetTarget() : null;
    }

    public static String calculatePackage(Node container) {
        Node node = NativeFormatter.firstNamedContainer(container);
        return node == null ? "" : node.cleanQn().replace("$", ".").replace("#", ".").toLowerCase();
    }

    private static Node firstNamedContainer(Node container) {
        List<Node> containers = NativeFormatter.collectStructure(container);
        Node candidate = null;
        for (Node nodeContainer : containers) {
            if (nodeContainer instanceof Node && !nodeContainer.isAnonymous()) {
                candidate = nodeContainer;
                continue;
            }
            if (nodeContainer instanceof Node) break;
            candidate = nodeContainer;
        }
        return candidate;
    }

    private static List<Node> collectStructure(Node container) {
        ArrayList<Node> containers = new ArrayList<Node>();
        for (Node current = container; current != null && !(current instanceof NodeRoot); current = current.container()) {
            containers.add(0, current);
        }
        return containers;
    }

    public Constraint.Parameter parameterConstraintOf(Parameter parameter) {
        List<Constraint.Parameter> parameters = this.parameterConstraintsOf(parameter.container());
        if (parameters.isEmpty() || parameters.size() <= parameter.position()) {
            return null;
        }
        return NativeFormatter.findParameter(parameters, parameter.name());
    }

    private List<Constraint.Parameter> parameterConstraintsOf(Node node) {
        if (this.language == null) {
            return Collections.emptyList();
        }
        List nodeConstraints = this.language.constraints(node.resolve().type());
        if (nodeConstraints == null) {
            return Collections.emptyList();
        }
        ArrayList constraints = new ArrayList(nodeConstraints);
        ArrayList<Constraint.Parameter> parameters = new ArrayList<Constraint.Parameter>();
        for (Constraint constraint : constraints) {
            if (constraint instanceof Constraint.Parameter) {
                parameters.add((Constraint.Parameter)constraint);
                continue;
            }
            if (!(constraint instanceof Constraint.Facet)) continue;
            parameters.addAll(((Constraint.Facet)constraint).constraints().stream().filter(c -> c instanceof Constraint.Parameter).map(c -> (Constraint.Parameter)c).collect(Collectors.toList()));
        }
        return parameters;
    }

    private static Constraint.Parameter findParameter(List<Constraint.Parameter> parameters, String name) {
        for (Constraint.Parameter variable : parameters) {
            if (!variable.name().equals(name)) continue;
            return variable;
        }
        return null;
    }
}

