/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.magritte.layer;

import io.intino.tara.Language;
import io.intino.tara.Resolver;
import io.intino.tara.compiler.codegeneration.magritte.Generator;
import io.intino.tara.compiler.codegeneration.magritte.NameFormatter;
import io.intino.tara.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.compiler.codegeneration.magritte.layer.TypesProvider;
import io.intino.tara.compiler.dependencyresolution.ModelUtils;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeReference;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.dsl.Proteo;
import io.intino.tara.dsl.Verso;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Rule;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.Size;
import io.intino.tara.lang.semantics.Constraint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.siani.itrules.Adapter;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

class LayerNodeAdapter
extends Generator
implements Adapter<Node>,
TemplateTags {
    private static final Logger LOG = Logger.getGlobal();
    private Node initNode;
    private Adapter.FrameContext context;
    private final Configuration.Level level;

    LayerNodeAdapter(String outDsl, Configuration.Level level, Language language, Node initNode, String workingPackage, String languageWorkingPackage) {
        super(language, outDsl, workingPackage, languageWorkingPackage);
        this.level = level;
        this.initNode = initNode;
    }

    public void execute(Frame frame, Node node, Adapter.FrameContext context) {
        this.context = context;
        frame.addTypes(TypesProvider.getTypes(node, this.language));
        frame.addFrame("modelType", new String[]{this.level == Configuration.Level.Platform ? "Platform" : "Application"});
        this.addNodeInfo(frame, node);
        this.addComponents(frame, node, (Adapter.FrameContext<FacetTarget>)context);
        this.addNonAbstractCreates(frame, node);
        this.addAllowedFacets(frame, node, context);
    }

    private Model findModel(Node node) {
        Node result;
        for (result = node; result != null && !(result instanceof Model); result = result.container()) {
        }
        return (Model)result;
    }

    private void addNodeInfo(Frame frame, Node node) {
        frame.addFrame("generatedLanguage", new String[]{this.outDsl}).addFrame("workingPackage", new String[]{this.workingPackage});
        if (this.initNode != null && !node.equals((Object)this.initNode) || LayerNodeAdapter.isInFacet(node) != null) {
            frame.addFrame("inner", new Boolean[]{true});
        }
        if (node.doc() != null) {
            frame.addFrame("doc", new String[]{node.doc()});
        }
        if (node.container() != null) {
            frame.addFrame("containerName", new String[]{node.container().name()});
        }
        this.addType(frame, node);
        this.addName(frame, node);
        this.addParent(frame, node);
        if (node.isAbstract()) {
            frame.addFrame("abstract", new Boolean[]{true});
        }
        node.flags().stream().filter(this.isLayerInterface()).forEach(tag -> frame.addFrame("flag", new Object[]{tag}));
        if (node.parent() != null) {
            frame.addTypes(new String[]{"child"});
        }
        frame.addFrame("parentSuper", new Boolean[]{node.parent() != null});
        if (node.components().stream().anyMatch(c -> c.is(Tag.Instance))) {
            frame.addFrame("metaType", new String[]{this.languageWorkingPackage + "." + this.metaType(node)});
        }
        this.addVariables(frame, node);
    }

    private void addNonAbstractCreates(Frame frame, Node node) {
        if (node instanceof NodeReference) {
            return;
        }
        List components = node.components();
        components.stream().filter(c -> !c.isAnonymous() && c.isAbstract()).forEach(c -> {
            ArrayList children = new ArrayList();
            this.collectChildren((Node)c).stream().filter(n -> !n.isAnonymous() && !n.isAbstract() && !components.contains(n)).forEach(n -> children.add(this.createFrame(n.isReference() ? n.destinyOfReference() : n)));
            for (Frame child : children) {
                frame.addFrame("create", new AbstractFrame[]{child.addTypes(new String[]{"node", "owner"})});
            }
        });
    }

    private Frame createFrame(Node node) {
        Frame frame = new Frame().addTypes(new String[]{"reference", "create"});
        frame.addTypes(TypesProvider.getTypes(node, this.language));
        this.addName(frame, node);
        this.addVariables(frame, node);
        return frame;
    }

    private List<Node> collectChildren(Node parent) {
        HashSet<Node> set = new HashSet<Node>();
        for (Node child : parent.children()) {
            set.add(child);
            set.addAll(this.collectChildren(child));
        }
        return new ArrayList<Node>(set);
    }

    private void addType(Frame frame, Node node) {
        if (!(this.language instanceof Proteo) && !(this.language instanceof Verso)) {
            frame.addFrame("conceptLayer", new String[]{this.language.doc(node.type()).layer()});
            frame.addFrame("type", new String[]{this.nodeType(node, this.sizeConstraint(node))});
        }
    }

    private Size sizeConstraint(Node node) {
        Constraint.Component constraint = this.language.constraints(node.container().type()).stream().filter(c -> c instanceof Constraint.Component && ((Constraint.Component)c).type().equals(node.type())).findFirst().orElse(null);
        if (constraint == null) {
            return Size.MULTIPLE();
        }
        return (Size)constraint.rules().stream().filter(rule -> rule instanceof Size).findFirst().orElse((Rule)Size.MULTIPLE());
    }

    private String nodeType(Node node, Size size) {
        return Resolver.shortType((String)node.type()) + (!size.isSingle() ? "List" : "");
    }

    private void addAllowedFacets(Frame frame, Node node, Adapter.FrameContext context) {
        for (String facet : node.allowedFacets()) {
            Frame available = new Frame().addTypes(new String[]{"availableFacet"});
            available.addFrame("name", new String[]{facet});
            FacetTarget facetTarget = ModelUtils.findFacetTarget(this.findModel(node), node, facet);
            if (facetTarget == null) {
                LOG.severe("error finding facet: " + facet + " in node " + node.name());
                throw new RuntimeException("error finding facet: " + facet + " in node " + node.name());
            }
            if (facetTarget.owner().isAbstract()) {
                available.addFrame("abstract", new String[]{"null"});
            }
            available.addFrame("qn", new String[]{NameFormatter.cleanQn(NameFormatter.getQn(facetTarget, facetTarget.owner(), this.workingPackage))});
            available.addFrame("stashQn", new String[]{NameFormatter.stashQn(facetTarget.owner(), this.workingPackage)});
            List required = facetTarget.owner().variables().stream().filter(v -> v.size().isRequired()).collect(Collectors.toList());
            for (Variable variable : required) {
                available.addFrame("variable", new AbstractFrame[]{((Frame)context.build((Object)variable)).addTypes(new String[]{"required"})});
            }
            frame.addFrame("availableFacet", new AbstractFrame[]{available});
        }
    }

    private void addName(Frame frame, Node node) {
        if (node.name() != null) {
            frame.addFrame("name", new String[]{node.name() + this.facetName(node.facetTarget())});
        }
        frame.addFrame("qn", new String[]{NameFormatter.cleanQn(this.buildQN(node))});
        frame.addFrame("stashQn", new String[]{this.stashQN(node)});
    }

    private String stashQN(Node node) {
        return NameFormatter.stashQn(node instanceof NodeReference ? ((NodeReference)node).getDestiny() : node, this.workingPackage.toLowerCase());
    }

    private String facetName(FacetTarget facetTarget) {
        return facetTarget != null ? facetTarget.target().replace(".", "") : "";
    }

    private String buildQN(Node node) {
        return NameFormatter.getQn(node instanceof NodeReference ? ((NodeReference)node).getDestiny() : node, this.workingPackage.toLowerCase());
    }

    private void addVariables(Frame frame, Node node) {
        node.variables().forEach(v -> this.addVariable(frame, (Variable)v));
        this.addTerminalVariables(node, frame);
    }

    private void addVariable(Frame frame, Variable variable) {
        Frame varFrame = (Frame)this.context.build((Object)variable);
        varFrame.addTypes(new String[]{"owner"});
        frame.addFrame("variable", new AbstractFrame[]{varFrame});
    }

    void setInitNode(Node initNode) {
        this.initNode = initNode;
    }
}

