/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.magritte.layer;

import io.intino.tara.Language;
import io.intino.tara.Resolver;
import io.intino.tara.compiler.codegeneration.Format;
import io.intino.tara.compiler.codegeneration.magritte.Generator;
import io.intino.tara.compiler.codegeneration.magritte.NameFormatter;
import io.intino.tara.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.compiler.codegeneration.magritte.layer.GraphWrapperTemplate;
import io.intino.tara.compiler.codegeneration.magritte.layer.LayerVariableAdapter;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.dsl.Proteo;
import io.intino.tara.dsl.Verso;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.Size;
import java.util.Collection;
import java.util.stream.Collectors;
import org.siani.itrules.Adapter;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class GraphWrapperCreator
extends Generator
implements TemplateTags {
    private final Configuration.Level modelLevel;

    public GraphWrapperCreator(Language language, String outDSL, Configuration.Level modelLevel, String workingPackage, String languageWorkingPackage) {
        super(language, outDSL, workingPackage, languageWorkingPackage);
        this.modelLevel = modelLevel;
    }

    public String create(Model model) {
        Frame frame = new Frame().addTypes(new String[]{"graph"});
        frame.addFrame("workingPackage", new String[]{this.workingPackage});
        frame.addFrame("name", new String[]{this.outDsl});
        this.collectMainNodes(model).stream().filter(node -> node.name() != null).forEach(node -> frame.addFrame("node", new AbstractFrame[]{this.createRootNodeFrame((Node)node, model.sizeOf((Node)node))}));
        return Format.customize(GraphWrapperTemplate.create()).format((Object)frame);
    }

    private Frame createRootNodeFrame(Node node, Size size) {
        Frame frame = new Frame();
        frame.addTypes(new String[]{"node"});
        if (size.isSingle()) {
            frame.addTypes(new String[]{"single"});
        }
        if (node.isTerminal()) {
            frame.addTypes(new String[]{"concept"});
        }
        if (node.is(Tag.Instance)) {
            frame.addTypes(new String[]{"instance"});
        }
        if (node.isAbstract()) {
            frame.addTypes(new String[]{"abstract"});
        }
        frame.addFrame("qn", new String[]{this.getQn(node)});
        frame.addFrame("generatedLanguage", new String[]{this.outDsl});
        frame.addFrame("stashQn", new String[]{NameFormatter.stashQn(node, this.workingPackage.toLowerCase()).replace(":", "")});
        this.addType(node, size, frame);
        frame.addFrame("name", new String[]{node.name() + (node.facetTarget() != null ? node.facetTarget().targetNode().name() : "")});
        node.variables().stream().filter(variable -> variable.values().isEmpty()).forEach(variable -> this.createVariable(frame, (Variable)variable));
        this.addTerminalVariables(node, frame);
        return frame;
    }

    private void addType(Node node, Size rule, Frame frame) {
        if (!(this.language instanceof Proteo) && !(this.language instanceof Verso)) {
            frame.addFrame("conceptLayer", new String[]{this.language.doc(node.type()).layer()});
        }
        frame.addFrame("type", new String[]{this.nodeType(node, rule)});
    }

    private String nodeType(Node node, Size rule) {
        return Resolver.shortType((String)node.type()) + (!rule.isSingle() ? "List" : "");
    }

    private void createVariable(Frame frame, Variable variable) {
        Frame variableFrame = new Frame();
        variableFrame.addTypes(new String[]{"variable", variable.type().getName()});
        LayerVariableAdapter adapter = new LayerVariableAdapter(this.language, this.outDsl, this.modelLevel, this.workingPackage, this.languageWorkingPackage);
        adapter.execute(variableFrame, variable, (Adapter.FrameContext<Variable>)null);
        frame.addFrame("variable", new AbstractFrame[]{variableFrame});
    }

    private String getQn(Node node) {
        return node.facetTarget() != null ? NameFormatter.getQn(node.facetTarget(), this.workingPackage.toLowerCase()).replace(":", "") : NameFormatter.getQn(node, this.workingPackage.toLowerCase()).replace(":", "");
    }

    private Collection<Node> collectMainNodes(Model model) {
        return model.components().stream().filter(n -> !n.is(Tag.Component) && !n.into(Tag.Component) && !n.is(Tag.Feature) && !n.into(Tag.Feature) && !((NodeImpl)n).isVirtual()).collect(Collectors.toList());
    }
}

