/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.lang;

import io.intino.tara.Language;
import io.intino.tara.compiler.codegeneration.magritte.Generator;
import io.intino.tara.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.compiler.model.VariableReference;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Rule;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.Size;
import io.intino.tara.lang.model.rules.variable.NativeRule;
import io.intino.tara.lang.model.rules.variable.VariableRule;
import io.intino.tara.lang.semantics.Constraint;
import io.intino.tara.lang.semantics.constraints.parameter.ReferenceParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.engine.FrameBuilder;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

class LanguageParameterAdapter
extends Generator
implements TemplateTags {
    private final Language language;
    private final Configuration.Level level;

    LanguageParameterAdapter(Language language, String outDSL, String workingPackage, String languageWorkingPackage, Configuration.Level level) {
        super(language, outDSL, workingPackage, languageWorkingPackage);
        this.language = language;
        this.level = level;
    }

    void addParameterConstraint(Frame frame, String facet, int position, Variable variable, String relation) {
        if (variable instanceof VariableReference) {
            frame.addFrame(relation, new AbstractFrame[]{this.referenceParameter(position, facet, variable, relation)});
        } else {
            frame.addFrame(relation, new AbstractFrame[]{this.primitiveParameter(position, facet, variable, relation)});
        }
    }

    int addTerminalParameterConstraints(Node node, Frame allowsFrame) {
        int index = 0;
        List constraints = this.language.constraints(node.type());
        if (constraints == null) {
            return 0;
        }
        for (Constraint c : constraints) {
            if (!(c instanceof Constraint.Parameter) || !this.isTerminal((Constraint.Parameter)c) || this.isRedefined((Constraint.Parameter)c, node.variables()) || this.isRequired((Constraint.Parameter)c)) continue;
            this.addTerminalParameter(allowsFrame, (Constraint.Parameter)c, index, "constraint");
            ++index;
        }
        return index;
    }

    private void addTerminalParameter(Frame frame, Constraint.Parameter parameter, int position, String type) {
        if (parameter instanceof ReferenceParameter) {
            frame.addFrame(type, new AbstractFrame[]{this.referenceParameter((ReferenceParameter)parameter, position, type)});
        } else {
            frame.addFrame(type, new AbstractFrame[]{this.primitiveParameter(parameter, position, type)});
        }
    }

    private boolean isRequired(Constraint.Parameter constraint) {
        return constraint.size().isRequired();
    }

    private boolean isRedefined(Constraint.Parameter constraint, List<? extends Variable> variables) {
        for (Variable variable : variables) {
            if (!variable.name().equals(constraint.name())) continue;
            return true;
        }
        return false;
    }

    private boolean isTerminal(Constraint.Parameter constraint) {
        for (Tag flag : constraint.flags()) {
            if (!flag.equals((Object)Tag.Terminal)) continue;
            return true;
        }
        return false;
    }

    private void addDefaultInfo(int position, Variable variable, Frame frame) {
        frame.addFrame("position", new Integer[]{position});
        frame.addFrame("tags", this.getFlags(variable));
        frame.addFrame("scope", new String[]{this.workingPackage});
        frame.addFrame("size", new AbstractFrame[]{this.isTerminal(variable) ? this.transformSizeRuleOfTerminalNode(variable) : new FrameBuilder().build((Object)variable.size())});
        Frame rule = this.ruleToFrame((Rule)variable.rule());
        if (rule != null) {
            frame.addFrame("rule", new AbstractFrame[]{rule});
        } else if (variable.flags().contains(Tag.Reactive)) {
            frame.addFrame("rule", new AbstractFrame[]{this.ruleToFrame((Rule)new NativeRule("", "", Collections.emptyList()))});
        }
    }

    private boolean isTerminal(Variable variable) {
        return variable.isTerminal() && !variable.container().isTerminal() && Configuration.Level.Application.compareLevelWith(this.level) > 0;
    }

    private Frame transformSizeRuleOfTerminalNode(Variable variable) {
        Size rule = variable.size();
        Size size = new Size(0, rule.max(), rule);
        return (Frame)new FrameBuilder().build((Object)size);
    }

    private Frame referenceParameter(int i, String facet, Variable variable, String relation) {
        Frame frame = new Frame().addTypes(new String[]{relation, "parameter", "reference"}).addFrame("name", new String[]{variable.name()}).addFrame("facet", new String[]{facet}).addFrame("type", new String[]{variable.destinyOfReference().qualifiedName()});
        this.addDefaultInfo(i, variable, frame);
        return frame;
    }

    private Frame primitiveParameter(int i, String facet, Variable variable, String relation) {
        Frame frame = new Frame().addTypes(new String[]{relation, "parameter"}).addFrame("name", new String[]{variable.name()}).addFrame("facet", new String[]{facet}).addFrame("type", new Object[]{variable.type()});
        this.addDefaultInfo(i, variable, frame);
        return frame;
    }

    private Frame referenceParameter(ReferenceParameter parameter, int position, String type) {
        Frame frame = new Frame().addTypes(new String[]{type, "parameter", "reference"}).addFrame("name", new String[]{parameter.name()}).addFrame("facet", new String[]{parameter.facet()});
        this.addDefaultInfo((Constraint.Parameter)parameter, frame, position);
        return frame;
    }

    private Frame primitiveParameter(Constraint.Parameter parameter, int position, String type) {
        Frame frame = new Frame().addTypes(new String[]{type, "parameter"}).addFrame("facet", new String[]{parameter.facet()}).addFrame("name", new String[]{parameter.name()}).addFrame("type", new Object[]{parameter.type()});
        this.addDefaultInfo(parameter, frame, position);
        return frame;
    }

    private void addDefaultInfo(Constraint.Parameter parameter, Frame frame, int position) {
        frame.addFrame("size", new AbstractFrame[]{new FrameBuilder().build((Object)new Size(1, parameter.size().max()))});
        frame.addFrame("position", new Integer[]{position});
        frame.addFrame("tags", this.getFlags(parameter));
        Frame rule = this.calculateRule(parameter);
        if (rule != null) {
            frame.addFrame("rule", new AbstractFrame[]{rule});
        }
    }

    private Frame calculateRule(Constraint.Parameter parameter) {
        VariableRule rule = parameter.rule();
        if (rule == null) {
            return null;
        }
        Frame frame = this.ruleToFrame((Rule)rule);
        return frame.addTypes(new String[]{parameter.type().getName()});
    }

    private String[] getFlags(Variable variable) {
        List<String> flags = variable.flags().stream().map(Enum::name).collect(Collectors.toList());
        return flags.toArray(new String[flags.size()]);
    }

    private String[] getFlags(Constraint.Parameter variable) {
        ArrayList<Tag> flags = new ArrayList<Tag>();
        for (Tag tag : variable.flags()) {
            if (tag.equals((Object)Tag.Terminal)) {
                flags.add(Tag.Instance);
                continue;
            }
            flags.add(tag);
        }
        return (String[])flags.stream().map(Enum::name).toArray(String[]::new);
    }
}

