/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.compiler.codegeneration.lang;

import io.intino.tara.Language;
import io.intino.tara.compiler.codegeneration.Format;
import io.intino.tara.compiler.codegeneration.lang.LanguageInheritanceManager;
import io.intino.tara.compiler.codegeneration.lang.LanguageParameterAdapter;
import io.intino.tara.compiler.codegeneration.lang.TerminalConstraintManager;
import io.intino.tara.compiler.codegeneration.magritte.NameFormatter;
import io.intino.tara.compiler.codegeneration.magritte.TemplateTags;
import io.intino.tara.compiler.dependencyresolution.ModelUtils;
import io.intino.tara.compiler.model.Model;
import io.intino.tara.compiler.model.NodeImpl;
import io.intino.tara.compiler.model.NodeReference;
import io.intino.tara.compiler.model.VariableReference;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.NodeContainer;
import io.intino.tara.lang.model.NodeRoot;
import io.intino.tara.lang.model.Rule;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.Size;
import io.intino.tara.lang.model.rules.composition.NodeCustomRule;
import io.intino.tara.lang.semantics.Assumption;
import io.intino.tara.lang.semantics.Constraint;
import io.intino.tara.lang.semantics.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.siani.itrules.Adapter;
import org.siani.itrules.engine.FrameBuilder;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

class LanguageModelAdapter
implements Adapter<Model>,
TemplateTags {
    private static final String FacetSeparator = ":";
    private final Configuration.Level level;
    private final String workingPackage;
    private final String languageWorkingPackage;
    private Frame root;
    private Model model;
    private Set<Node> processed = new HashSet<Node>();
    private String outDSL;
    private Locale locale;
    private Language language;

    LanguageModelAdapter(String outDSL, Locale locale, Language language, Configuration.Level type, String workingPackage, String languageWorkingPackage) {
        this.outDSL = outDSL;
        this.locale = locale;
        this.language = language;
        this.level = type;
        this.workingPackage = workingPackage;
        this.languageWorkingPackage = languageWorkingPackage;
    }

    public void execute(Frame root, Model model, Adapter.FrameContext<Model> context) {
        this.root = root;
        this.model = model;
        this.initRoot();
        this.buildNode((Node)model);
        this.addInheritedRules(model);
    }

    private void initRoot() {
        this.root.addFrame("name", new String[]{this.outDSL});
        this.root.addFrame("terminal", new Boolean[]{this.level.equals((Object)Configuration.Level.Application)});
        this.root.addFrame("metaLanguage", new String[]{this.language.languageName()});
        this.root.addFrame("locale", new String[]{this.locale.getLanguage()});
    }

    private void buildNode(Node node) {
        if (this.alreadyProcessed(node)) {
            return;
        }
        Frame frame = new Frame().addTypes(new String[]{"node"});
        if (!(node.isAbstract() || node.isAnonymous() || node.is(Tag.Instance))) {
            this.createRuleFrame(node, frame);
        } else if (node.is(Tag.Instance) && !node.isAnonymous()) {
            this.root.addFrame("node", new AbstractFrame[]{this.createInstanceFrame(node)});
        }
        if (!node.isAnonymous()) {
            node.components().stream().filter(inner -> !(inner instanceof NodeReference)).forEach(this::buildNode);
        }
    }

    private void createRuleFrame(Node node, Frame frame) {
        frame.addFrame("name", new String[]{this.name(node)});
        this.addTypes(node, frame);
        this.addConstraints(node, frame);
        this.addAssumptions(node, frame);
        this.addDoc(node, frame);
        this.root.addFrame("node", new AbstractFrame[]{frame});
    }

    private Frame createInstanceFrame(Node node) {
        Frame frame = new Frame().addTypes(new String[]{"instance"}).addFrame("qn", new String[]{this.name(node)});
        this.addTypes(node, frame);
        frame.addFrame("path", new String[]{this.outDSL});
        return frame;
    }

    private void addInheritedRules(Model model) {
        new LanguageInheritanceManager(this.root, this.collectInstanceConstraints(), this.language, model).fill();
    }

    private List<String> collectInstanceConstraints() {
        return this.language.catalog().entrySet().stream().filter(entry -> this.isInstance((Context)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private boolean isInstance(Context context) {
        return context.assumptions().stream().anyMatch(a -> a instanceof Assumption.Instance);
    }

    private void addDoc(Node node, Frame frame) {
        Frame docFrame = new Frame();
        docFrame.addTypes(new String[]{"doc"}).addFrame("Layer", new String[]{this.findLayer(node)}).addFrame("file", new String[]{node.file().replace("\\", "\\\\")}).addFrame("line", new Integer[]{node.line()}).addFrame("doc", new String[]{node.doc() != null ? this.format(node) : ""});
        frame.addFrame("doc", new AbstractFrame[]{docFrame});
    }

    private String findLayer(Node node) {
        if (node instanceof Model) {
            return "";
        }
        return NameFormatter.getQn(node, this.workingPackage);
    }

    private String format(Node node) {
        return node.doc().replace("\"", "\\\"").replace("\n", "\\n");
    }

    private void addTypes(Node node, Frame frame) {
        if (node.type() == null) {
            return;
        }
        Frame typesFrame = new Frame().addTypes(new String[]{"nodeType"});
        LinkedHashSet<String> typeSet = new LinkedHashSet<String>();
        typeSet.add(node.type());
        Collection<String> languageTypes = this.getLanguageTypes(node);
        if (languageTypes != null) {
            typeSet.addAll(languageTypes);
        }
        for (String type : typeSet) {
            typesFrame.addFrame("type", new String[]{type});
        }
        if (typesFrame.slots().length > 0) {
            frame.addFrame("nodeType", new AbstractFrame[]{typesFrame});
        }
    }

    private Collection<String> getLanguageTypes(Node node) {
        return this.language.types(node.type());
    }

    private boolean alreadyProcessed(Node node) {
        return !this.processed.add(node);
    }

    private void addConstraints(Node node, Frame frame) {
        Frame constraints = this.buildComponentConstraints(node);
        this.addTerminalConstrains(node, constraints);
        this.addContextConstraints(node, constraints);
        frame.addFrame("constraints", new AbstractFrame[]{constraints});
    }

    private void addContextConstraints(Node node, Frame constraints) {
        if (node instanceof NodeImpl) {
            if (!node.isTerminal()) {
                this.addRequiredVariableRedefines(constraints, node);
            }
            this.addParameterConstraints(node.variables(), node.type().startsWith("Facet:") ? node.name() : "", constraints, new LanguageParameterAdapter(this.language, this.outDSL, this.workingPackage, this.languageWorkingPackage, this.level).addTerminalParameterConstraints(node, constraints) + this.terminalParameterIndex(constraints));
        }
        if (node.type().startsWith("MetaFacet:")) {
            this.addMetaFacetConstraints(node, constraints);
        }
        this.addFacetConstraints(node, constraints);
    }

    private int terminalParameterIndex(Frame constraints) {
        Iterator iterator = constraints.frames("constraint");
        int index = 0;
        while (iterator.hasNext()) {
            if (!((AbstractFrame)iterator.next()).is("parameter")) continue;
            ++index;
        }
        return index;
    }

    private void addParameterConstraints(List<Variable> variables, String facet, Frame constrainsFrame, int parentIndex) {
        int privateVariables = 0;
        for (int index = 0; index < variables.size(); ++index) {
            Variable variable = variables.get(index);
            if (!variable.isPrivate() && !this.finalWithValues(variable)) {
                new LanguageParameterAdapter(this.language, this.outDSL, this.workingPackage, this.languageWorkingPackage, this.level).addParameterConstraint(constrainsFrame, facet, parentIndex + index - privateVariables, variable, "constraint");
                continue;
            }
            ++privateVariables;
        }
    }

    private boolean finalWithValues(Variable variable) {
        return variable.isFinal() && !variable.values().isEmpty();
    }

    private void addMetaFacetConstraints(Node node, Frame constraints) {
        FacetTarget facetTarget = node.facetTarget();
        if (!node.type().startsWith("MetaFacet:") || facetTarget == null || node.isAbstract()) {
            return;
        }
        Node target = facetTarget.targetNode();
        if (target.isAbstract()) {
            for (Node child : target.children()) {
                this.createMetaFacetConstraint(child, facetTarget.constraints(), constraints);
            }
        } else {
            this.createMetaFacetConstraint(target, facetTarget.constraints(), constraints);
        }
    }

    private void createMetaFacetConstraint(Node node, List<FacetTarget.Constraint> with, Frame constraints) {
        Frame frame = new Frame().addTypes(new String[]{"constraint", "metafacet"}).addFrame("value", new String[]{node.qualifiedName()});
        if (with != null && !with.isEmpty()) {
            frame.addFrame("with", with.stream().map(c -> c.node().qualifiedName()).collect(Collectors.toList()).toArray(new String[with.size()]));
        }
        constraints.addFrame("constraint", new AbstractFrame[]{frame});
    }

    private void addFacetConstraints(Node node, Frame constraints) {
        for (String facet : node.allowedFacets()) {
            Node facetTargetNode = ModelUtils.findFacetTargetNode(this.model, node, facet);
            if (facetTargetNode == null || facetTargetNode.facetTarget() == null || facetTargetNode.isAbstract()) continue;
            Frame frame = new Frame().addTypes(new String[]{"constraint", "facet"}).addFrame("value", new String[]{facet});
            constraints.addFrame("constraint", new AbstractFrame[]{frame});
            FacetTarget facetTarget = facetTargetNode.facetTarget();
            frame.addFrame("terminal", new String[]{facetTargetNode.isTerminal() + ""});
            if (facetTarget.constraints() != null && !facetTarget.constraints().isEmpty()) {
                for (FacetTarget.Constraint constraint : facetTarget.constraints()) {
                    frame.addFrame(constraint.negated() ? "without" : "with", new String[]{constraint.node().name()});
                }
            }
            this.addParameterConstraints(facetTargetNode.variables(), facet, frame, 0);
            this.addComponentsConstraints(frame, facetTargetNode);
            this.addTerminalConstrains(facetTargetNode, frame);
        }
        this.addTerminalFacets(node, constraints);
    }

    private void addTerminalFacets(Node node, Frame frame) {
        List<Constraint> facetAllows = this.language.constraints(node.type()).stream().filter(allow -> allow instanceof Constraint.Facet && ((Constraint.Facet)allow).terminal()).collect(Collectors.toList());
        new TerminalConstraintManager(this.language, (NodeContainer)node).addConstraints(facetAllows, frame);
    }

    private void addTerminalConstrains(Node container, Frame frame) {
        List constraints = this.language.constraints(container.type());
        List<Constraint> terminalConstraints = constraints.stream().filter(c -> c instanceof Constraint.Component && LanguageModelAdapter.is(LanguageModelAdapter.annotations(c), Tag.Instance) && !this.sizeComplete((NodeContainer)container, this.typeOf((Constraint)c)) || c instanceof Constraint.Parameter && ((Constraint.Parameter)c).flags().contains(Tag.Terminal) && !this.isRedefined((Constraint.Parameter)c, container.variables())).collect(Collectors.toList());
        new TerminalConstraintManager(this.language, (NodeContainer)container).addConstraints(terminalConstraints, frame);
    }

    private boolean isRedefined(Constraint.Parameter allow, List<? extends Variable> variables) {
        for (Variable variable : variables) {
            if (!variable.name().equals(allow.name())) continue;
            return true;
        }
        return false;
    }

    private String typeOf(Constraint constraint) {
        return ((Constraint.Component)constraint).type();
    }

    private boolean sizeComplete(NodeContainer container, String type) {
        List components = container.components().stream().filter(node -> node.type().equals(type)).collect(Collectors.toList());
        return !components.isEmpty() && container.sizeOf((Node)components.get(0)).max() == components.size();
    }

    private void addRequiredVariableRedefines(Frame constraints, Node node) {
        node.variables().stream().filter(variable -> variable.isTerminal() && variable instanceof VariableReference && !((VariableReference)variable).getDestiny().isTerminal()).forEach(variable -> constraints.addFrame("constraint", new AbstractFrame[]{new Frame().addTypes(new String[]{"redefine", "constraint"}).addFrame("name", new String[]{variable.name()}).addFrame("supertype", new Object[]{variable.type()})}));
    }

    private void addAssumptions(Node node, Frame frame) {
        Frame assumptions = this.buildAssumptions(node);
        if (assumptions.slots().length != 0) {
            frame.addFrame("assumptions", new AbstractFrame[]{assumptions});
        }
    }

    private Frame buildAssumptions(Node node) {
        Frame assumptions = new Frame().addTypes(new String[]{"assumptions"});
        this.addAnnotationAssumptions(node, assumptions);
        return assumptions;
    }

    private void addAnnotationAssumptions(Node node, Frame assumptions) {
        node.annotations().forEach(tag -> assumptions.addFrame("assumption", new String[]{tag.name().toLowerCase()}));
        for (Tag tag2 : node.flags()) {
            if (tag2.equals((Object)Tag.Terminal)) {
                assumptions.addFrame("assumption", new Object[]{Tag.Instance});
                continue;
            }
            if (tag2.equals((Object)Tag.Feature)) {
                assumptions.addFrame("assumption", new Object[]{Tag.Feature});
                continue;
            }
            if (tag2.equals((Object)Tag.Component)) {
                assumptions.addFrame("assumption", new String[]{Format.capitalize(Tag.Component.name())});
                continue;
            }
            if (tag2.equals((Object)Tag.Volatile)) {
                assumptions.addFrame("assumption", new String[]{Format.capitalize(Tag.Volatile.name())});
                continue;
            }
            if (!tag2.equals((Object)Tag.Versioned)) continue;
            assumptions.addFrame("assumption", new String[]{Format.capitalize(Tag.Versioned.name())});
        }
        if (node.type().startsWith("MetaFacet:")) {
            assumptions.addFrame("assumption", new Object[]{Tag.Facet});
        }
        if (node.isFacet()) {
            assumptions.addFrame("assumption", new Object[]{Tag.Terminal});
        }
    }

    private Frame buildComponentConstraints(Node container) {
        Frame constraints = new Frame().addTypes(new String[]{"constraints"});
        this.addComponentsConstraints(constraints, container);
        return constraints;
    }

    private void addComponentsConstraints(Frame constraints, Node container) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        this.createComponentsConstraints(container, frames);
        if (!frames.isEmpty()) {
            constraints.addFrame("constraint", (AbstractFrame[])frames.toArray(new Frame[frames.size()]));
        }
    }

    private void createComponentsConstraints(Node node, List<Frame> frames) {
        node.components().stream().filter(c -> this.componentCompliant(node, (Node)c)).forEach(c -> {
            if (c.type().startsWith("MetaFacet:")) {
                this.createMetaFacetComponentConstraint(frames, (Node)c);
            } else if (!c.isSub()) {
                this.createComponentConstraint(frames, (Node)c);
            }
        });
        if (node.facetTarget() != null && node.facetTarget().parent() != null) {
            node.facetTarget().parent().components().stream().filter(c -> !(node instanceof Model) || !c.into(Tag.Component) && (!c.isTerminal() || !c.is(Tag.Component))).forEach(c -> {
                if (c.type().startsWith("MetaFacet:")) {
                    this.createMetaFacetComponentConstraint(frames, (Node)c);
                } else {
                    this.createComponentConstraint(frames, (Node)c);
                }
            });
        }
    }

    private boolean componentCompliant(Node container, Node node) {
        return !(container instanceof NodeRoot) || this.rootCompliant(node);
    }

    private boolean rootCompliant(Node c) {
        return !c.is(Tag.Component) && !this.rootFacetOverComponentOrAbstract(c) && !c.is(Tag.Feature) && (!c.isTerminal() || !c.into(Tag.Component) && !c.into(Tag.Feature));
    }

    private boolean rootFacetOverComponentOrAbstract(Node node) {
        Node targetNode = node.facetTarget() != null ? node.facetTarget().targetNode() : null;
        return node.type().startsWith("Facet:") && targetNode != null && (targetNode.is(Tag.Component) || !(targetNode.container() instanceof NodeRoot) || targetNode.isAbstract());
    }

    private void createMetaFacetComponentConstraint(List<Frame> frames, Node node) {
        FacetTarget facetTarget = node.facetTarget();
        if (!node.type().startsWith("MetaFacet:") || facetTarget == null || node.isAbstract()) {
            return;
        }
        Node target = facetTarget.targetNode();
        if (target.isAbstract()) {
            for (Node child : target.children()) {
                Frame frame = new Frame().addTypes(new String[]{"constraint", "component"}).addFrame("type", new String[]{node.name() + FacetSeparator + child.qualifiedName()});
                frame.addFrame("size", new Object[]{node.isTerminal() && Configuration.Level.Application.compareLevelWith(this.level) > 0 ? LanguageModelAdapter.transformSizeRuleOfTerminalNode(node) : this.createRulesFrames(node.container().rulesOf(node))});
                LanguageModelAdapter.addTags(node, frame);
                frames.add(frame);
            }
        } else {
            this.createComponentConstraint(frames, node);
        }
    }

    private void createComponentConstraint(List<Frame> frames, Node component) {
        List<Node> candidates = LanguageModelAdapter.collectCandidates(component);
        Size size = component.container().sizeOf(component);
        List allRules = component.container().rulesOf(component);
        if ((size.isSingle() || size.isRequired() || component.isReference()) && candidates.size() > 1) {
            Frame oneOf = this.createOneOf(candidates, allRules);
            if (!component.isAbstract()) {
                oneOf.addFrame("constraint", new AbstractFrame[]{this.createComponentConstraint(component, allRules)});
            }
            if (!component.isSub()) {
                frames.add(oneOf);
            }
        } else {
            frames.addAll(candidates.stream().filter(c -> this.componentCompliant(c.container(), (Node)c)).map(c -> this.createComponentConstraint((Node)c, allRules)).collect(Collectors.toList()));
        }
    }

    private Frame createComponentConstraint(Node component, List<Rule> rules) {
        Frame frame = new Frame().addTypes(new String[]{"constraint", "component"}).addFrame("type", new String[]{this.name(component)});
        if (this.isTerminal(component)) {
            frame.addFrame("size", new AbstractFrame[]{LanguageModelAdapter.transformSizeRuleOfTerminalNode(component)});
        } else {
            frame.addFrame("size", this.createRulesFrames(rules));
        }
        LanguageModelAdapter.addTags(component, frame);
        return frame;
    }

    private boolean isTerminal(Node component) {
        return component.isTerminal() && !LanguageModelAdapter.isInTerminal(component) && Configuration.Level.Application.compareLevelWith(this.level) > 0;
    }

    private static boolean isInTerminal(Node component) {
        return component.container().isTerminal();
    }

    private static Frame transformSizeRuleOfTerminalNode(Node component) {
        Size rule = component.container().sizeOf(component);
        Size size = new Size(0, rule.max(), rule);
        return (Frame)new FrameBuilder().build((Object)size);
    }

    private static void addTags(Node node, Frame frame) {
        Set tags = node.annotations().stream().map(Enum::name).collect(Collectors.toCollection(LinkedHashSet::new));
        node.flags().forEach(tag -> tags.add(LanguageModelAdapter.convertTag(tag)));
        frame.addFrame("tags", tags.toArray(new String[tags.size()]));
    }

    private static List<Node> collectCandidates(Node node) {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>();
        if (node.isAnonymous() || node.is(Tag.Instance)) {
            return new ArrayList<Node>(nodes);
        }
        if (!node.isAbstract()) {
            nodes.add(node);
        }
        LanguageModelAdapter.getNonAbstractChildren(node, nodes);
        return new ArrayList<Node>(nodes);
    }

    private static void getNonAbstractChildren(Node node, Set<Node> nodes) {
        for (Node child : node.children()) {
            if (child.isAbstract()) {
                LanguageModelAdapter.getNonAbstractChildren(child, nodes);
                continue;
            }
            if (!child.container().equals((Object)node.container()) && !node.isReference()) continue;
            nodes.add(child);
        }
    }

    private static String convertTag(Tag tag) {
        if (tag.equals((Object)Tag.Terminal)) {
            return Tag.Instance.name();
        }
        return tag.name();
    }

    private String name(Node node) {
        return node instanceof NodeReference ? ((NodeReference)node).getDestiny().qualifiedName() : node.qualifiedName();
    }

    private Frame createOneOf(Collection<Node> candidates, List<Rule> rules) {
        Frame frame = new Frame().addTypes(new String[]{"oneOf", "constraint"});
        frame.addFrame("rule", this.createRulesFrames(rules));
        for (Node candidate : candidates) {
            frame.addFrame("constraint", new AbstractFrame[]{this.createComponentConstraint(candidate, rules)});
        }
        return frame;
    }

    private AbstractFrame[] createRulesFrames(List<Rule> rules) {
        return (AbstractFrame[])rules.stream().map(rule -> rule instanceof NodeCustomRule ? this.buildCustomRuleFrame((NodeCustomRule)rule) : (Frame)new FrameBuilder().build(rule)).toArray(AbstractFrame[]::new);
    }

    private Frame buildCustomRuleFrame(NodeCustomRule rule) {
        return new Frame().addTypes(new String[]{"rule", "customRule"}).addFrame("qn", new String[]{rule.getLoadedClass().getName()});
    }

    private static List<Tag> annotations(Constraint constraint) {
        return ((Constraint.Component)constraint).annotations();
    }

    private static boolean is(List<Tag> annotations, Tag tag) {
        return annotations.contains(tag);
    }
}

